/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import com.google.common.collect.Lists;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewer;
import io.github.lgatodu47.screenshot_viewer.screens.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screens.widgets.ButtonAction;
import io.github.lgatodu47.screenshot_viewer.screens.widgets.ScreenshotViewerButton;
import io.github.lgatodu47.screenshot_viewer.screens.widgets.ScreenshotViewerImageButton;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

class ScreenshotPropertiesMenu
extends Gui {
    private static final int BUTTON_SIZE = 19;
    private final Supplier<Minecraft> mcSupplier;
    private final IntSupplier parentWidth;
    private final IntSupplier parentHeight;
    private final List<ScreenshotViewerButton> buttons = new ArrayList<ScreenshotViewerButton>();
    private int x;
    private int y;
    private int width;
    private int height;
    @Nonnull
    private String fileName = "";
    private boolean shouldRender;
    @Nullable
    private GuiScreen childScreen;

    ScreenshotPropertiesMenu(Supplier<Minecraft> mcSupplier, IntSupplier parentWidth, IntSupplier parentHeight) {
        this.mcSupplier = mcSupplier;
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
    }

    void tick() {
        if (this.childScreen != null) {
            this.childScreen.func_73876_c();
        }
    }

    void show(int x, int y, Runnable remover, File screenshotFile, Consumer<File> fileUpdater) {
        this.buttons.clear();
        this.fileName = screenshotFile.getName();
        int spacing = 2;
        Consumer<Boolean> deleteAction = value -> {
            if (value.booleanValue()) {
                if (screenshotFile.exists() && !screenshotFile.delete()) {
                    ManageScreenshotsScreen.LOGGER.error("Failed to delete 'screenshot' file at location '{}'", (Object)screenshotFile.toPath().toAbsolutePath());
                    return;
                }
                remover.run();
            }
            this.hide();
        };
        ArrayList buttonInfo = Lists.newArrayList((Object[])new Triple[]{Triple.of((Object)0, (Object)ScreenshotViewer.translated("screen", "button.delete_screenshot"), btn -> {
            if (ManageScreenshotsScreen.CONFIG.promptWhenDeletingScreenshot.getAsBoolean()) {
                this.childScreen = new ConfirmationScreen(deleteAction, screenshotFile.getName());
                this.childScreen.func_146280_a(this.mcSupplier.get(), this.parentWidth.getAsInt(), this.parentHeight.getAsInt());
            } else {
                deleteAction.accept(true);
            }
        }), Triple.of((Object)1, (Object)ScreenshotViewer.translated("screen", "button.open_file"), btn -> ManageScreenshotsScreen.openFile(screenshotFile)), Triple.of((Object)3, (Object)ScreenshotViewer.translated("screen", "button.rename_file"), btn -> {
            this.childScreen = new RenameScreen(this.fileName.substring(0, this.fileName.lastIndexOf(46)), s -> {
                try {
                    Path moved = Files.move(screenshotFile.toPath(), screenshotFile.toPath().resolveSibling((String)s), new CopyOption[0]);
                    fileUpdater.accept(moved.toFile());
                }
                catch (IOException e) {
                    ManageScreenshotsScreen.LOGGER.error("Failed to rename 'screenshot' file at '" + screenshotFile.toPath().toAbsolutePath() + "' from '" + screenshotFile.getName() + "' to '" + s + "'", (Throwable)e);
                }
            }, this::hide);
            this.childScreen.func_146280_a(this.mcSupplier.get(), this.parentWidth.getAsInt(), this.parentHeight.getAsInt());
        }), Triple.of((Object)2, (Object)ScreenshotViewer.translated("screen", "button.close_properties_menu"), btn -> this.hide())});
        FontRenderer font = this.mcSupplier.get().field_71466_p;
        int largestTextWidth = buttonInfo.stream().map(Triple::getMiddle).mapToInt(arg_0 -> ((FontRenderer)font).func_78256_a(arg_0)).max().orElse(0);
        this.width = 4 + Math.max(font.func_78256_a(this.fileName), 19 + largestTextWidth + 2);
        this.height = 6 + font.field_78288_b + 19 * buttonInfo.size();
        this.x = x + this.width > this.parentWidth.getAsInt() ? x - this.width : x;
        this.y = y + this.height > this.parentHeight.getAsInt() ? y - this.height : y;
        for (int i = 0; i < buttonInfo.size(); ++i) {
            Triple pair = (Triple)buttonInfo.get(i);
            this.buttons.add(new ScreenButton(this.x + 2, this.y + 4 + font.field_78288_b + 19 * i, 19 * (Integer)pair.getLeft(), 19, (String)pair.getMiddle(), (ButtonAction)pair.getRight()));
        }
        this.shouldRender = true;
    }

    void hide() {
        this.buttons.clear();
        this.shouldRender = false;
        this.childScreen = null;
        this.height = 0;
        this.width = 0;
        this.y = 0;
        this.x = 0;
        this.fileName = "";
    }

    boolean renders() {
        return this.shouldRender;
    }

    public void render(int mouseX, int mouseY, float delta) {
        if (this.shouldRender) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            if (this.childScreen == null) {
                int spacing = 2;
                ScreenshotPropertiesMenu.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-12434878);
                this.mcSupplier.get().field_71466_p.func_175063_a(this.fileName, (float)(this.x + 2), (float)(this.y + 2), -1);
                for (GuiButton guiButton : this.buttons) {
                    guiButton.func_191745_a(this.mcSupplier.get(), mouseX, mouseY, delta);
                    this.mcSupplier.get().field_71466_p.func_175063_a(guiButton.field_146126_j, (float)(guiButton.field_146128_h + guiButton.field_146120_f + 2), (float)guiButton.field_146129_i + (float)(guiButton.field_146121_g - 9) / 2.0f + 2.0f, -1);
                }
            } else {
                this.childScreen.func_73863_a(mouseX, mouseY, delta);
            }
            GlStateManager.func_179121_F();
        }
    }

    public void handleMouseInput() throws IOException {
        if (this.childScreen != null) {
            this.childScreen.func_146274_d();
            return;
        }
        Minecraft mc = this.mcSupplier.get();
        int mouseX = Mouse.getEventX() * this.parentWidth.getAsInt() / mc.field_71443_c;
        int mouseY = this.parentHeight.getAsInt() - Mouse.getEventY() * this.parentHeight.getAsInt() / mc.field_71440_d - 1;
        int button = Mouse.getEventButton();
        if (Mouse.getEventButtonState()) {
            this.mouseClicked(mouseX, mouseY, button);
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (mouseX < this.x || mouseY < this.y || mouseX > this.x + this.width || mouseY > this.y + this.height) {
            this.hide();
        }
        if (button == 0) {
            for (ScreenshotViewerButton btn : this.buttons) {
                if (!btn.func_146116_c(this.mcSupplier.get(), mouseX, mouseY)) continue;
                btn.func_146113_a(this.mcSupplier.get().func_147118_V());
                btn.onPress(btn);
                break;
            }
        }
    }

    public void handleKeyboardInput() throws IOException {
        if (this.childScreen instanceof RenameScreen) {
            this.childScreen.func_146282_l();
            return;
        }
        char c = Keyboard.getEventCharacter();
        if (Keyboard.getEventKey() == 0 && c >= ' ' || Keyboard.getEventKeyState()) {
            this.keyTyped(Keyboard.getEventKey());
        }
        this.mcSupplier.get().func_152348_aa();
    }

    public void keyTyped(int keyCode) {
        if (keyCode == 1) {
            this.hide();
        }
    }

    private static final class RenameScreen
    extends GuiScreen {
        private final String previousName;
        private final Consumer<String> newNameConsumer;
        private final Runnable closeAction;
        private GuiTextField textField;
        private ScreenshotViewerButton doneBtn;

        private RenameScreen(String previousName, Consumer<String> newNameConsumer, Runnable closeAction) {
            this.previousName = previousName;
            this.newNameConsumer = newNameConsumer;
            this.closeAction = closeAction;
        }

        public void func_73876_c() {
            if (this.textField != null) {
                this.textField.func_146178_a();
            }
        }

        public void func_73866_w_() {
            super.func_73866_w_();
            this.textField = new GuiTextField(-1, this.field_146289_q, (this.field_146294_l - 150) / 2, (this.field_146295_m - 20) / 2, 150, 20);
            this.textField.func_146203_f(128);
            this.textField.func_175205_a(RenameScreen::checkInvalidCharacters);
            this.doneBtn = new ScreenshotViewerButton(this.field_146294_l / 2 - 4 - 150, this.field_146295_m / 2 + 50, 150, 20, ManageScreenshotsScreen.GUI_DONE, btn -> {
                this.newNameConsumer.accept(this.textField.func_146179_b().trim().concat(".png"));
                this.closeAction.run();
            });
            this.doneBtn.field_146124_l = false;
            this.textField.func_175207_a(new GuiPageButtonList.GuiResponder(){

                public void func_175321_a(int id, boolean value) {
                }

                public void func_175320_a(int id, float value) {
                }

                public void func_175319_a(int id, @Nonnull String value) {
                    ((RenameScreen)this).doneBtn.field_146124_l = !StringUtils.isBlank((CharSequence)value) && !value.trim().equals(previousName) && !value.endsWith(".");
                }
            });
            this.textField.func_146180_a(this.previousName);
            this.textField.func_146195_b(true);
            this.func_189646_b(this.doneBtn);
            this.func_189646_b(new ScreenshotViewerButton(this.field_146294_l / 2 + 4, this.field_146295_m / 2 + 50, 150, 20, ManageScreenshotsScreen.GUI_BACK, btn -> this.closeAction.run()));
        }

        public void func_73863_a(int mouseX, int mouseY, float delta) {
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
            this.func_73732_a(this.field_146289_q, ScreenshotViewer.translated("screen", "rename_screenshot"), this.field_146294_l / 2, this.field_146295_m / 2 - 70, 0xFFFFFF);
            super.func_73863_a(mouseX, mouseY, delta);
            if (this.textField != null) {
                this.textField.func_146194_f();
            }
        }

        protected void func_73869_a(char typedChar, int keyCode) {
            if (keyCode == 28 && this.doneBtn != null && this.doneBtn.field_146124_l) {
                this.doneBtn.onPress(this.doneBtn);
                return;
            }
            if (keyCode == 1) {
                this.close();
            }
            if (this.textField.func_146206_l()) {
                this.textField.func_146201_a(typedChar, keyCode);
            }
        }

        protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            this.textField.func_146192_a(mouseX, mouseY, mouseButton);
        }

        protected void func_146284_a(@Nonnull GuiButton button) {
            if (button instanceof ButtonAction) {
                ((ButtonAction)button).onPress(button);
            }
        }

        private void close() {
            this.closeAction.run();
        }

        private static boolean checkInvalidCharacters(String s) {
            return s.chars().noneMatch(c -> c == 92 || c == 47 || c == 58 || c == 42 || c == 63 || c == 34 || c == 60 || c == 62 || c == 124);
        }
    }

    private static final class ConfirmationScreen
    extends GuiYesNo {
        public ConfirmationScreen(Consumer<Boolean> callback, String fileName) {
            super((result, id) -> callback.accept(result), new TextComponentTranslation("screen.screenshot_viewer.delete_prompt", new Object[]{fileName}).func_150254_d(), ScreenshotViewer.translated("screen", "delete_prompt.message"), -1);
        }

        public void func_146270_b(int tint) {
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
        }
    }

    private static final class ScreenButton
    extends ScreenshotViewerImageButton {
        private static final ResourceLocation TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/screenshot_viewer_icons.png");
        private final int imgU;
        private final int imgV;

        public ScreenButton(int x, int y, int imgU, int imgV, String title, ButtonAction pressAction) {
            super(x, y, 19, 19, 0, 0, 0, GuiButton.field_146122_a, 128, 128, title, pressAction);
            this.imgU = imgU;
            this.imgV = imgV;
        }

        @Override
        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float delta) {
            if (!this.field_146125_m) {
                return;
            }
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            mc.func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179097_i();
            ScreenButton.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)(this.field_146123_n ? 19.0f : 38.0f), (float)0.0f, (int)this.field_146120_f, (int)this.field_146121_g, (float)128.0f, (float)128.0f);
            ScreenButton.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)this.imgU, (float)this.imgV, (int)this.field_146120_f, (int)this.field_146121_g, (float)128.0f, (float)128.0f);
            GlStateManager.func_179126_j();
        }
    }
}

