/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import io.github.lgatodu47.screenshot_viewer.ScreenshotViewer;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfig;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfigListener;
import io.github.lgatodu47.screenshot_viewer.screens.EnlargedScreenshotScreen;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotList;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotPropertiesMenu;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotWidget;
import io.github.lgatodu47.screenshot_viewer.screens.widgets.ButtonAction;
import io.github.lgatodu47.screenshot_viewer.screens.widgets.ButtonTooltip;
import io.github.lgatodu47.screenshot_viewer.screens.widgets.ScreenshotViewerButton;
import io.github.lgatodu47.screenshot_viewer.screens.widgets.ScreenshotViewerImageButton;
import io.github.lgatodu47.screenshot_viewer.util.DynamicButtonTexture;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Mouse;

public class ManageScreenshotsScreen
extends GuiScreen
implements ScreenshotViewerConfigListener {
    static final ScreenshotViewerConfig CONFIG = ScreenshotViewer.getInstance().getConfig();
    static final Logger LOGGER = LogManager.getLogger();
    static final String GUI_DONE = I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]);
    static final String GUI_BACK = I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]);
    private static final ResourceLocation CONFIG_BUTTON_TEXTURE = new DynamicButtonTexture("config_button");
    private static final ResourceLocation REFRESH_BUTTON_TEXTURE = new DynamicButtonTexture("refresh_button");
    private static final ResourceLocation ASCENDING_ORDER_BUTTON_TEXTURE = new DynamicButtonTexture("ascending_order_button");
    private static final ResourceLocation DESCENDING_ORDER_BUTTON_TEXTURE = new DynamicButtonTexture("descending_order_button");
    private static final ResourceLocation OPEN_FOLDER_BUTTON_TEXTURE = new DynamicButtonTexture("open_folder_button");
    private final GuiScreen parent;
    private final EnlargedScreenshotScreen enlargedScreenshot;
    private final ScreenshotPropertiesMenu screenshotProperties;
    private ScreenshotList list;
    private float screenshotScaleAnimation;

    public ManageScreenshotsScreen(GuiScreen parent) {
        this.parent = parent;
        this.enlargedScreenshot = new EnlargedScreenshotScreen();
        this.screenshotProperties = new ScreenshotPropertiesMenu(this::client, () -> this.field_146294_l, () -> this.field_146295_m);
        ScreenshotViewer.getInstance().registerConfigListener(this);
    }

    Minecraft client() {
        return this.field_146297_k;
    }

    public void func_73876_c() {
        if (this.screenshotProperties != null) {
            this.screenshotProperties.tick();
        }
    }

    public void func_73866_w_() {
        if (this.field_146297_k == null) {
            return;
        }
        int spacing = 8;
        int btnHeight = 20;
        this.enlargedScreenshot.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        int contentWidth = this.field_146294_l - 24;
        int contentHeight = this.field_146295_m - 40 - 20;
        if (this.list == null) {
            this.list = new ScreenshotList(this, 12, 24, this.field_146294_l - 24, this.field_146295_m - 40 - 20);
            this.list.init();
        } else {
            this.list.updateSize(contentWidth, contentHeight);
            this.list.updateChildren();
        }
        int btnY = this.field_146295_m - 8 - 20;
        int btnSize = 20;
        int bigBtnWidth = 200;
        Optional<UnaryOperator<GuiScreen>> configScreenFactory = ScreenshotViewer.getInstance().getConfigScreenFactory();
        ExtendedTexturedButtonWidget configButton = new ExtendedTexturedButtonWidget(2, 2, 20, 20, 0, 0, 20, CONFIG_BUTTON_TEXTURE, 32, 64, button -> configScreenFactory.ifPresent(f -> this.field_146297_k.func_147108_a((GuiScreen)f.apply(this))), (button, x, y) -> this.func_146279_a(this.field_146289_q.func_78269_a(ScreenshotViewer.translated("screen", configScreenFactory.isPresent() ? "button.config" : "no_config"), Math.max(this.field_146294_l / 2 - 43, 170)), x, y + 20), ScreenshotViewer.translated("screen", configScreenFactory.isPresent() ? "button.config" : "no_config"));
        configButton.field_146124_l = configScreenFactory.isPresent();
        this.func_189646_b(configButton);
        this.func_189646_b(new ExtendedTexturedButtonWidget(8, btnY, 20, 20, 0, 0, 20, null, 32, 64, button -> {
            if (this.list != null) {
                this.list.invertOrder();
            }
        }, (button, x, y) -> {
            if (this.list != null) {
                this.func_146279_a(this.field_146289_q.func_78269_a(ScreenshotViewer.translated("screen", this.list.isInvertedOrder() ? "button.order.descending" : "button.order.ascending"), Math.max(this.field_146294_l / 2 - 43, 170)), x, y);
            }
        }, ScreenshotViewer.translated("screen", "button.order")){

            @Override
            @Nullable
            public ResourceLocation getTexture() {
                return ManageScreenshotsScreen.this.list == null ? null : (ManageScreenshotsScreen.this.list.isInvertedOrder() ? DESCENDING_ORDER_BUTTON_TEXTURE : ASCENDING_ORDER_BUTTON_TEXTURE);
            }
        });
        this.func_189646_b(new ExtendedTexturedButtonWidget(36, btnY, 20, 20, 0, 0, 20, OPEN_FOLDER_BUTTON_TEXTURE, 32, 64, btn -> ManageScreenshotsScreen.openFile(new File(this.field_146297_k.field_71412_D, "screenshots")), (button, x, y) -> this.func_146279_a(this.field_146289_q.func_78269_a(ScreenshotViewer.translated("screen", "button.screenshot_folder"), Math.max(this.field_146294_l / 2 - 43, 170)), x, y), ScreenshotViewer.translated("screen", "button.screenshot_folder")));
        this.func_189646_b(new ExtendedButtonWidget((this.field_146294_l - 200) / 2, btnY, 200, 20, GUI_DONE, button -> this.close()));
        this.func_189646_b(new ExtendedTexturedButtonWidget(this.field_146294_l - 8 - 20, btnY, 20, 20, 0, 0, 20, REFRESH_BUTTON_TEXTURE, 32, 64, button -> this.list.init(), (btn, x, y) -> this.func_146279_a(this.field_146289_q.func_78269_a(ScreenshotViewer.translated("screen", "button.refresh"), Math.max(this.field_146294_l / 2 - 43, 170)), x, y), ScreenshotViewer.translated("screen", "button.refresh")));
    }

    protected void func_146284_a(@Nonnull GuiButton button) {
        if (button instanceof ButtonAction) {
            ((ButtonAction)button).onPress(button);
        }
    }

    public void func_175273_b(@Nonnull Minecraft client, int width, int height) {
        super.func_175273_b(client, width, height);
        this.enlargedScreenshot.func_175273_b(client, width, height);
        this.screenshotProperties.hide();
    }

    static void openFile(File file) {
        try {
            URL fileUrl = file.toURI().toURL();
            Process process = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(ManageScreenshotsScreen.getCommand(fileUrl)));
            process.getInputStream().close();
            process.getErrorStream().close();
            process.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("Couldn't open file at '{}'", (Object)file.toPath().toAbsolutePath(), (Object)e);
        }
    }

    private static String[] getCommand(URL url) {
        switch (Util.func_110647_a()) {
            case WINDOWS: {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", url.toString()};
            }
            case OSX: {
                return new String[]{"open", url.toString()};
            }
        }
        return new String[]{"xdg-open", url.toString().replace("file:", "file://")};
    }

    public void func_73863_a(int mouseX, int mouseY, float delta) {
        this.func_146276_q_();
        if (this.list != null) {
            this.list.render(mouseX, mouseY, !this.enlargedScreenshot.renders() && !this.screenshotProperties.renders());
        }
        this.func_73732_a(this.field_146289_q, ScreenshotViewer.translated("screen", "manage_screenshots"), this.field_146294_l / 2, 8, 0xFFFFFF);
        String text = ScreenshotViewer.translated("screen", "screenshot_manager.zoom");
        this.func_73731_b(this.field_146289_q, text, this.field_146294_l - this.field_146289_q.func_78256_a(text) - 8, 8, ManageScreenshotsScreen.func_146271_m() ? 1629753 : 15780386);
        super.func_73863_a(mouseX, mouseY, delta);
        this.screenshotProperties.render(mouseX, mouseY, delta);
        if (this.enlargedScreenshot.renders()) {
            float animationTime = 1.0f;
            if (ManageScreenshotsScreen.CONFIG.enableScreenshotEnlargementAnimation.getAsBoolean() && this.screenshotScaleAnimation < 1.0f) {
                this.screenshotScaleAnimation = (float)((double)this.screenshotScaleAnimation + 0.03);
                animationTime = (float)(1.0 - Math.pow(1.0f - this.screenshotScaleAnimation, 3.0));
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            this.enlargedScreenshot.func_146276_q_();
            GlStateManager.func_179109_b((float)((float)this.enlargedScreenshot.field_146294_l / 2.0f * (1.0f - animationTime)), (float)((float)this.enlargedScreenshot.field_146295_m / 2.0f * (1.0f - animationTime)), (float)0.0f);
            GlStateManager.func_179152_a((float)animationTime, (float)animationTime, (float)animationTime);
            this.enlargedScreenshot.func_73863_a(mouseX, mouseY, delta);
            GlStateManager.func_179121_F();
        } else {
            if (this.screenshotScaleAnimation > 0.0f) {
                this.screenshotScaleAnimation = 0.0f;
            }
            if (!this.screenshotProperties.renders()) {
                for (GuiButton btn : this.field_146292_n) {
                    if (!(btn instanceof CustomHoverState)) continue;
                    ((CustomHoverState)btn).updateHoveredState(mouseX, mouseY);
                }
                this.handleHoveredChildren(mouseX, mouseY);
            }
        }
    }

    private void handleHoveredChildren(double mouseX, double mouseY) {
        this.field_146292_n.stream().filter(GuiButton::func_146115_a).filter(ButtonTooltip.class::isInstance).forEach(btn -> ((ButtonTooltip)btn).renderTooltip((GuiButton)btn, (int)mouseX, (int)mouseY));
    }

    void enlargeScreenshot(ScreenshotImageHolder showing) {
        this.enlargedScreenshot.show(showing, this.list);
    }

    void showScreenshotProperties(double mouseX, double mouseY, ScreenshotWidget widget) {
        this.screenshotProperties.show((int)mouseX, (int)mouseY, () -> this.list.removeEntry(widget), widget.getScreenshotFile(), widget::updateScreenshotFile);
    }

    public void func_146282_l() throws IOException {
        if (this.screenshotProperties.renders()) {
            this.screenshotProperties.handleKeyboardInput();
            return;
        }
        if (this.enlargedScreenshot.renders()) {
            this.enlargedScreenshot.func_146282_l();
            return;
        }
        super.func_146282_l();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.close();
        }
    }

    public void func_146274_d() throws IOException {
        if (this.screenshotProperties.renders()) {
            this.screenshotProperties.handleMouseInput();
            return;
        }
        if (this.enlargedScreenshot.renders()) {
            this.enlargedScreenshot.func_146274_d();
            return;
        }
        if (this.list != null) {
            if (ManageScreenshotsScreen.func_146271_m()) {
                this.list.updateScreenshotsPerRow(Mouse.getEventDWheel());
            } else {
                this.list.handleMouseInput();
            }
        }
        super.func_146274_d();
    }

    private void close() {
        if (this.field_146297_k != null) {
            this.field_146297_k.func_147108_a(this.parent);
        }
        ScreenshotViewer.getInstance().unregisterConfigListener(this);
    }

    public void func_146281_b() {
        this.list.close();
    }

    @Override
    public void onConfigReloaded() {
        this.list.configUpdated();
    }

    private static interface CustomHoverState {
        public void updateHoveredState(int var1, int var2);
    }

    private static class ExtendedTexturedButtonWidget
    extends ScreenshotViewerImageButton
    implements CustomHoverState {
        @Nullable
        private final ResourceLocation texture;

        ExtendedTexturedButtonWidget(int x, int y, int width, int height, int u, int v, int hoveredVOffset, @Nullable ResourceLocation texture, int textureWidth, int textureHeight, ButtonAction action, ButtonTooltip tooltip, String text) {
            super(x, y, width, height, u, v, hoveredVOffset, GuiButton.field_146122_a, textureWidth, textureHeight, text, action, tooltip);
            this.texture = texture;
            this.field_146126_j = text;
        }

        @Nullable
        public ResourceLocation getTexture() {
            return this.texture;
        }

        @Override
        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                ResourceLocation texture = this.getTexture();
                if (texture == null) {
                    ExtendedTexturedButtonWidget.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)0xFFFFFF);
                } else {
                    mc.func_110434_K().func_110577_a(texture);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179097_i();
                    int vOffset = this.v;
                    if (!this.field_146124_l) {
                        vOffset += this.hoveredVOffset * 2;
                    } else if (this.field_146123_n) {
                        vOffset += this.hoveredVOffset;
                    }
                    ExtendedTexturedButtonWidget.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)this.u, (float)vOffset, (int)this.field_146120_f, (int)this.field_146121_g, (float)this.textureWidth, (float)this.textureHeight);
                    GlStateManager.func_179126_j();
                }
            }
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        }
    }

    private static final class ExtendedButtonWidget
    extends ScreenshotViewerButton
    implements CustomHoverState {
        ExtendedButtonWidget(int x, int y, int width, int height, String message, ButtonAction action) {
            super(x, y, width, height, message, action);
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                FontRenderer fontRenderer = mc.field_71466_p;
                mc.func_110434_K().func_110577_a(field_146122_a);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int hoverState = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + hoverState * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46 + hoverState * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_146119_b(mc, mouseX, mouseY);
                int j = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    j = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    j = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    j = 0xFFFFA0;
                }
                this.func_73732_a(fontRenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
            }
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        }
    }
}

