/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer;

import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfig;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfigListener;
import io.github.lgatodu47.screenshot_viewer.screens.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screens.widgets.ButtonTooltip;
import io.github.lgatodu47.screenshot_viewer.screens.widgets.ScreenshotViewerButton;
import io.github.lgatodu47.screenshot_viewer.screens.widgets.ScreenshotViewerImageButton;
import io.github.lgatodu47.screenshot_viewer.util.DynamicButtonTexture;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonLanguage;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Keyboard;

@Mod(modid="screenshot_viewer", name="Screenshot Viewer", version="1.1.1", acceptedMinecraftVersions="1.12.2", clientSideOnly=true, guiFactory="io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfigGuiFactory")
public class ScreenshotViewer {
    public static final String MODID = "screenshot_viewer";
    @Mod.Instance(value="screenshot_viewer")
    private static ScreenshotViewer instance;
    private final List<ScreenshotViewerConfigListener> configListeners = new ArrayList<ScreenshotViewerConfigListener>();
    private ModContainer modContainer;
    private ScreenshotViewerConfig config;
    private KeyBinding openScreenshotsScreenKey;
    private static final ResourceLocation MANAGE_SCREENSHOTS_BUTTON_TEXTURE;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.modContainer = Loader.instance().activeModContainer();
        this.config = ScreenshotViewerConfig.registerConfig(event.getModConfigurationDirectory());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerKeyBindings();
        MinecraftForge.EVENT_BUS.register((Object)new ScreenshotViewerEvents());
    }

    private void registerKeyBindings() {
        this.openScreenshotsScreenKey = new KeyBinding(ScreenshotViewer.translation("key", "open_screenshots_screen"), (IKeyConflictContext)KeyConflictContext.IN_GAME, 0, "key.categories.misc");
        ClientRegistry.registerKeyBinding((KeyBinding)this.openScreenshotsScreenKey);
    }

    public ScreenshotViewerConfig getConfig() {
        return this.config;
    }

    public KeyBinding getOpenScreenshotsScreenKey() {
        return this.openScreenshotsScreenKey;
    }

    public void registerConfigListener(ScreenshotViewerConfigListener listener) {
        this.configListeners.add(listener);
    }

    public void unregisterConfigListener(ScreenshotViewerConfigListener listener) {
        this.configListeners.remove(listener);
    }

    public Optional<UnaryOperator<GuiScreen>> getConfigScreenFactory() {
        return Optional.ofNullable(FMLClientHandler.instance().getGuiFactoryFor(this.modContainer)).filter(IModGuiFactory::hasConfigGui).map(factory -> arg_0 -> ((IModGuiFactory)factory).createConfigGui(arg_0));
    }

    @Nonnull
    public static ScreenshotViewer getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Screenshot Viewer is not loaded yet!");
        }
        return instance;
    }

    public static String translation(String prefix, String suffix) {
        return prefix + '.' + MODID + '.' + suffix;
    }

    public static ITextComponent translatable(String prefix, String suffix) {
        return new TextComponentTranslation(ScreenshotViewer.translation(prefix, suffix), new Object[0]);
    }

    public static String translated(String prefix, String suffix) {
        return ScreenshotViewer.translatable(prefix, suffix).func_150254_d();
    }

    static {
        MANAGE_SCREENSHOTS_BUTTON_TEXTURE = new DynamicButtonTexture("screenshots_button");
    }

    public final class ScreenshotViewerEvents {
        private final Field buttonListField = ObfuscationReflectionHelper.findField(GuiScreen.class, (String)"field_146292_n");

        @SubscribeEvent
        public void onConfigReloaded(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (ScreenshotViewer.MODID.equals(event.getModID())) {
                ScreenshotViewer.this.config.save();
                ScreenshotViewer.this.configListeners.forEach(ScreenshotViewerConfigListener::onConfigReloaded);
            }
        }

        @SubscribeEvent
        public void onKeyInput(InputEvent.KeyInputEvent event) {
            Minecraft client = Minecraft.func_71410_x();
            KeyBinding openScreenshotsScreenKey = ScreenshotViewer.getInstance().getOpenScreenshotsScreenKey();
            if (client.field_71441_e != null && client.field_71462_r == null && Keyboard.getEventKeyState() && openScreenshotsScreenKey != null && openScreenshotsScreenKey.func_151463_i() == Keyboard.getEventKey()) {
                client.func_147108_a((GuiScreen)new ManageScreenshotsScreen(null));
            }
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public void onScreenPostInit(GuiScreenEvent.InitGuiEvent.Post event) {
            GuiScreen screen = event.getGui();
            Minecraft client = screen.field_146297_k;
            List buttons = event.getButtonList();
            if (((ScreenshotViewer)ScreenshotViewer.this).config.showButtonInGamePauseMenu.getAsBoolean() && screen instanceof GuiIngameMenu) {
                GuiButton topButton = buttons.stream().filter(button -> button.field_146127_k == 4).findFirst().orElseGet(() -> (GuiButton)buttons.get(1));
                buttons.add(new ScreenshotViewerImageButton(topButton.field_146128_h + topButton.field_146120_f + 8, topButton.field_146129_i, topButton.field_146121_g, topButton.field_146121_g, 0, 0, 20, MANAGE_SCREENSHOTS_BUTTON_TEXTURE, 32, 64, ScreenshotViewer.translated("screen", "manage_screenshots"), button -> client.func_147108_a((GuiScreen)new ManageScreenshotsScreen(screen)), (button, mouseX, mouseY) -> screen.func_146279_a(client.field_71466_p.func_78269_a(ScreenshotViewer.translated("screen", "manage_screenshots"), Math.max(screen.field_146294_l / 2 - 43, 170)), mouseX, mouseY)));
            }
            if (((ScreenshotViewer)ScreenshotViewer.this).config.showButtonOnTitleScreen.getAsBoolean() && screen instanceof GuiMainMenu) {
                Optional<GuiButton> languageButton = buttons.stream().filter(GuiButtonLanguage.class::isInstance).findFirst();
                int x = screen.field_146294_l / 2 + 104;
                int y = languageButton.map(widget -> widget.field_146129_i).orElse(screen.field_146295_m / 4 + 132);
                int width = languageButton.map(widget -> widget.field_146120_f).orElse(20);
                int height = languageButton.map(widget -> widget.field_146121_g).orElse(20);
                buttons.add(new ScreenshotViewerImageButton(x, y, width, height, 0, 0, 20, MANAGE_SCREENSHOTS_BUTTON_TEXTURE, 32, 64, ScreenshotViewer.translated("screen", "manage_screenshots"), button -> client.func_147108_a((GuiScreen)new ManageScreenshotsScreen(screen)), (button, mouseX, mouseY) -> screen.func_146279_a(client.field_71466_p.func_78269_a(ScreenshotViewer.translated("screen", "manage_screenshots"), Math.max(screen.field_146294_l / 2 - 43, 170)), mouseX, mouseY)));
            }
        }

        @SubscribeEvent
        public void onScreenButtonPressed(GuiScreenEvent.ActionPerformedEvent.Post event) {
            if ((event.getGui() instanceof GuiIngameMenu || event.getGui() instanceof GuiMainMenu) && event.getButton() instanceof ScreenshotViewerButton) {
                ((ScreenshotViewerButton)event.getButton()).onPress(event.getButton());
            }
        }

        @SubscribeEvent
        public void onScreenRendered(GuiScreenEvent.DrawScreenEvent.Post event) {
            if (event.getGui() instanceof GuiIngameMenu || event.getGui() instanceof GuiMainMenu) {
                try {
                    List buttons = (List)this.buttonListField.get(event.getGui());
                    buttons.stream().filter(GuiButton::func_146115_a).filter(ButtonTooltip.class::isInstance).forEach(btn -> ((ButtonTooltip)btn).renderTooltip((GuiButton)btn, event.getMouseX(), event.getMouseY()));
                }
                catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException throwable) {
                    // empty catch block
                }
            }
        }
    }
}

