/*
 * Decompiled with CFR 0.152.
 */
package com.animania.manual.resources;

import com.animania.Animania;
import com.animania.addons.AddonResourcePack;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.helper.StringParser;
import com.animania.manual.components.ConfigComponent;
import com.animania.manual.components.CraftingComponent;
import com.animania.manual.components.EntityComponent;
import com.animania.manual.components.IManualComponent;
import com.animania.manual.components.ImageComponent;
import com.animania.manual.components.ItemComponent;
import com.animania.manual.components.LinkComponent;
import com.animania.manual.components.TextComponent;
import com.animania.manual.groups.ManualPage;
import com.animania.manual.groups.ManualTopic;
import com.animania.manual.gui.GuiManual;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ManualResourceLoader {
    public static boolean errored = false;
    private static List<ManualTopic> topics = new ArrayList<ManualTopic>();
    public static ManualTopic firstTopic = null;
    private static List<ResourceLocation> allManualFiles = new ArrayList<ResourceLocation>();

    private static void fetchManualFiles() {
        allManualFiles.clear();
        FileSystem filesystem = null;
        URL url = Animania.class.getResource("/assets/animania/manual/");
        try {
            if (url != null) {
                URI uri = url.toURI();
                Path path = null;
                if ("file".equals(uri.getScheme())) {
                    path = Paths.get(Animania.class.getResource("/assets/animania/manual").toURI());
                } else {
                    if (!"jar".equals(uri.getScheme())) {
                        return;
                    }
                    filesystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    path = filesystem.getPath("/assets/animania/manual", new String[0]);
                }
                Iterator it = Files.walk(path, new FileVisitOption[0]).iterator();
                while (it.hasNext()) {
                    Path next = (Path)it.next();
                    if (!next.toString().endsWith(".json")) continue;
                    String sp = next.toString();
                    String resLoc = sp.substring(sp.indexOf("manual"), sp.length());
                    ResourceLocation loc = new ResourceLocation("animania", resLoc.replace("\\", "/"));
                    allManualFiles.add(loc);
                }
            }
        }
        catch (Exception e) {
            Animania.LOGGER.error((Object)e);
        }
        if (filesystem != null) {
            try {
                filesystem.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List packs = (List)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String)"field_110449_ao");
        for (IResourcePack pack : packs) {
            if (pack instanceof AddonResourcePack.Jar) {
                allManualFiles.addAll(((AddonResourcePack.Jar)pack).manualFiles);
                continue;
            }
            if (!(pack instanceof AddonResourcePack.Folder)) continue;
            allManualFiles.addAll(((AddonResourcePack.Folder)pack).manualFiles);
        }
    }

    public static void loadResources() {
        topics.clear();
        firstTopic = null;
        errored = false;
        GuiManual.INSTANCE.manualContent.clear();
        GuiManual.INSTANCE.lastTopic = null;
        GuiManual.INSTANCE.currentTopic = null;
        GuiManual.INSTANCE.pageIndex = 0;
        ManualResourceLoader.fetchManualFiles();
        for (ResourceLocation loc : allManualFiles) {
            try {
                List resources = Minecraft.func_71410_x().func_110442_L().func_135056_b(loc);
                if (resources.isEmpty()) continue;
                InputStream stream = ((IResource)resources.get(resources.size() - 1)).func_110527_b();
                ManualResourceLoader.readJson(stream, loc);
            }
            catch (Exception e) {
                Animania.LOGGER.error((Object)e);
            }
        }
        GuiManual m = GuiManual.INSTANCE;
        for (ManualTopic c : topics) {
            if (!c.isPermitted()) continue;
            m.manualContent.put(c.getId(), c);
        }
        m.currentTopic = firstTopic;
        m.lastTopic = firstTopic;
    }

    public static void readJson(InputStream stream, ResourceLocation loc) {
        try {
            JsonParser parser = new JsonParser();
            JsonElement e = parser.parse((Reader)new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)));
            if (e.isJsonObject()) {
                JsonObject obj = e.getAsJsonObject();
                boolean firstPage = false;
                if (obj.has("isFirstPage")) {
                    firstPage = obj.get("isFirstPage").getAsBoolean();
                }
                String requiredModid = "animania";
                if (obj.has("requiredModid")) {
                    requiredModid = obj.get("requiredModid").getAsString();
                }
                String name = "UNTITLED";
                if (obj.has("name")) {
                    name = AnimaniaHelper.translateWithFormattingCodes(obj.get("name").getAsString());
                }
                if (obj.has("contents")) {
                    JsonArray contents = obj.get("contents").getAsJsonArray();
                    ArrayList<IManualComponent> components = new ArrayList<IManualComponent>();
                    ArrayList<ManualPage> pages = new ArrayList<ManualPage>();
                    for (int i = 0; i < contents.size(); ++i) {
                        JsonElement content = contents.get(i);
                        List<IManualComponent> c = ManualResourceLoader.getComponentFromString(content.getAsString(), components);
                        components.addAll(c);
                    }
                    IManualComponent prevComponent = null;
                    int height = 0;
                    for (int k = 0; k < components.size(); ++k) {
                        IManualComponent c = (IManualComponent)components.get(k);
                        if (prevComponent != null && c.getY() == prevComponent.getY() && c.getObjectHeight() == prevComponent.getObjectHeight()) {
                            height -= c.getObjectHeight() + 1;
                        }
                        prevComponent = c;
                        if ((height += c.getObjectHeight() + 1) <= 154) continue;
                        ArrayList<IManualComponent> splitComponents = new ArrayList<IManualComponent>();
                        for (int j = 0; j < k; ++j) {
                            splitComponents.add((IManualComponent)components.get(0));
                            components.remove(0);
                        }
                        ManualResourceLoader.regerenatePositions(components);
                        ManualPage page = new ManualPage(splitComponents);
                        pages.add(page);
                        height = 0;
                        height += c.getObjectHeight() + 1;
                        k = 0;
                    }
                    ManualPage finalPage = new ManualPage(components);
                    pages.add(finalPage);
                    ManualTopic topic = new ManualTopic(loc, firstPage, name, pages);
                    topic.setRequiredModid(requiredModid);
                    if (firstPage) {
                        firstTopic = topic;
                    }
                    topics.add(topic);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errored = true;
        }
    }

    public static void regerenatePositions(List<IManualComponent> components) {
        int offsetY = 0;
        int prevPosY = 0;
        int prevHeight = 0;
        for (int i = 0; i < components.size(); ++i) {
            IManualComponent lastComponent = i == 0 ? null : components.get(i - 1);
            IManualComponent thisComponent = components.get(i);
            if (lastComponent != null) {
                offsetY = prevPosY == thisComponent.getY() && prevHeight == thisComponent.getObjectHeight() ? lastComponent.getY() : lastComponent.getY() + lastComponent.getObjectHeight() + 1;
            }
            prevPosY = thisComponent.getY();
            prevHeight = thisComponent.getObjectHeight();
            thisComponent.setY(offsetY);
        }
    }

    public static List<IManualComponent> getComponentFromString(String s, List<IManualComponent> otherComponents) {
        int offsetY = 0;
        if (!otherComponents.isEmpty()) {
            IManualComponent lastComponent = otherComponents.get(otherComponents.size() - 1);
            offsetY = lastComponent.getY() + lastComponent.getObjectHeight();
        }
        if (s.startsWith("@link@")) {
            if (s.contains("#")) {
                boolean prevLine = false;
                if ((s = s.replace("@link@", "")).contains("#prevline")) {
                    s = s.replace("#prevline", "");
                    prevLine = true;
                }
                String requiredModid = "animania";
                if (s.contains("$")) {
                    requiredModid = s.substring(s.indexOf("$") + 1);
                    s = s.replace("$" + requiredModid, "");
                }
                if (!ManualTopic.isPermitted(requiredModid)) {
                    return Collections.EMPTY_LIST;
                }
                String linkLoc = s.substring(0, s.indexOf("#"));
                ResourceLocation loc = new ResourceLocation(linkLoc);
                String string2 = s.substring(s.indexOf("#") + 1);
                string2 = AnimaniaHelper.translateWithFormattingCodes(string2);
                List<IManualComponent> list = ManualResourceLoader.getTextComp(string2, otherComponents, prevLine);
                ArrayList<IManualComponent> arrayList = new ArrayList<IManualComponent>();
                for (IManualComponent comp : list) {
                    String displ = ((TextComponent)comp).toString();
                    arrayList.add(new LinkComponent(comp.getX(), comp.getY(), displ, loc));
                }
                return arrayList;
            }
        } else {
            if (s.startsWith("@image@")) {
                s = s.replace("@image@", "");
                ResourceLocation loc = new ResourceLocation(s);
                ImageComponent i = new ImageComponent(0, offsetY + 1, loc);
                return ManualResourceLoader.getList(i);
            }
            if (s.startsWith("@entity@")) {
                s = s.replace("@entity@", "");
                String[] locs = s.split(",");
                ResourceLocation[] loc = AnimaniaHelper.getResourceLocations(locs);
                EntityComponent i = new EntityComponent(0, offsetY + 1, loc);
                return ManualResourceLoader.getList(i);
            }
            if (s.startsWith("@crafting@")) {
                List<IRecipe> recipes = AnimaniaHelper.getRecipesForOutput(s = s.replace("@crafting@", ""));
                if (!recipes.isEmpty()) {
                    CraftingComponent i = new CraftingComponent(0, offsetY + 1, recipes);
                    return ManualResourceLoader.getList(i);
                }
            } else {
                if (s.startsWith("@item@")) {
                    String[] items = (s = s.replace("@item@", "")).split(",");
                    ItemStack[] stacks = AnimaniaHelper.getItemStackArray(items);
                    if (stacks.length > 6) {
                        ArrayList<IManualComponent> itemComps = new ArrayList<IManualComponent>();
                        ArrayList<ItemStack[]> splitStacks = new ArrayList<ItemStack[]>();
                        while (stacks.length > 6) {
                            ItemStack[] itemStackArray = new ItemStack[6];
                            System.arraycopy(stacks, 0, itemStackArray, 0, 6);
                            splitStacks.add(itemStackArray);
                            ItemStack[] itemStackArray2 = new ItemStack[stacks.length - 6];
                            System.arraycopy(stacks, 6, itemStackArray2, 0, stacks.length - 6);
                            stacks = itemStackArray2;
                        }
                        if (stacks.length > 0) {
                            splitStacks.add(stacks);
                        }
                        for (ItemStack[] itemStackArray : splitStacks) {
                            ItemComponent itemComponent = new ItemComponent(0, offsetY + 1, itemStackArray);
                            itemComps.add(itemComponent);
                            offsetY = itemComponent.getY() + itemComponent.getObjectHeight();
                        }
                        return itemComps;
                    }
                    ItemComponent i = new ItemComponent(0, offsetY + 1, stacks);
                    return ManualResourceLoader.getList(i);
                }
                if (s.startsWith("@loottable@")) {
                    ItemStack[] stacks = AnimaniaHelper.getItemsForLoottable(new ResourceLocation(s = s.replace("@loottable@", "")));
                    if (stacks.length > 6) {
                        ArrayList<IManualComponent> itemComps = new ArrayList<IManualComponent>();
                        ArrayList<Object> splitStacks = new ArrayList<Object>();
                        while (stacks.length > 6) {
                            ItemStack[] sA = new ItemStack[6];
                            System.arraycopy(stacks, 0, sA, 0, 6);
                            splitStacks.add(sA);
                            ItemStack[] itemStackArray = new ItemStack[stacks.length - 6];
                            System.arraycopy(stacks, 6, itemStackArray, 0, stacks.length - 6);
                            stacks = itemStackArray;
                        }
                        if (stacks.length > 0) {
                            splitStacks.add(stacks);
                        }
                        for (ItemStack[] itemStackArray : splitStacks) {
                            ItemComponent itemComponent = new ItemComponent(0, offsetY + 1, itemStackArray);
                            itemComps.add(itemComponent);
                            offsetY = itemComponent.getY() + itemComponent.getObjectHeight();
                        }
                        return itemComps;
                    }
                    ItemComponent i = new ItemComponent(0, offsetY + 1, stacks);
                    return ManualResourceLoader.getList(i);
                }
                if (s.startsWith("@configitem@")) {
                    Object configObject = AnimaniaHelper.getConfigValue(s = s.replace("@configitem@", ""));
                    if (configObject != null && configObject instanceof String[] || configObject instanceof String) {
                        if (configObject instanceof String) {
                            ItemStack stack = StringParser.getItemStack((String)configObject);
                            ItemComponent i = new ItemComponent(0, offsetY + 1, new ItemStack[]{stack});
                            return ManualResourceLoader.getList(i);
                        }
                        String[] items = (String[])configObject;
                        ItemStack[] stacks = AnimaniaHelper.getItemStackArray(items);
                        if (stacks.length > 6) {
                            ArrayList<IManualComponent> itemComps = new ArrayList<IManualComponent>();
                            ArrayList<ItemStack[]> arrayList = new ArrayList<ItemStack[]>();
                            while (stacks.length > 6) {
                                ItemStack[] itemStackArray = new ItemStack[6];
                                System.arraycopy(stacks, 0, itemStackArray, 0, 6);
                                arrayList.add(itemStackArray);
                                ItemStack[] itemStackArray3 = new ItemStack[stacks.length - 6];
                                System.arraycopy(stacks, 6, itemStackArray3, 0, stacks.length - 6);
                                stacks = itemStackArray3;
                            }
                            if (stacks.length > 0) {
                                arrayList.add(stacks);
                            }
                            for (ItemStack[] itemStackArray : arrayList) {
                                ItemComponent iC = new ItemComponent(0, offsetY + 1, itemStackArray);
                                itemComps.add(iC);
                                offsetY = iC.getY() + iC.getObjectHeight();
                            }
                            return itemComps;
                        }
                        ItemComponent i = new ItemComponent(0, offsetY + 1, stacks);
                        return ManualResourceLoader.getList(i);
                    }
                } else {
                    if (s.startsWith("@config@")) {
                        String display;
                        Object o;
                        boolean prevLine = false;
                        if ((s = s.replace("@config@", "")).contains("#prevline")) {
                            s = s.replace("#prevline", "");
                            prevLine = true;
                        }
                        if ((o = AnimaniaHelper.getConfigValue(s)) instanceof Number) {
                            double d = ((Number)o).doubleValue();
                            d *= 100.0;
                            d = Math.round(d);
                            o = (d /= 100.0) == (double)((int)d) ? (Number)((int)d) : (Number)d;
                        }
                        if (o.getClass().isArray()) {
                            o = Arrays.toString((Object[])o).replace("[", "").replace("]", "");
                        }
                        if ((display = o + "").isEmpty()) {
                            return Collections.EMPTY_LIST;
                        }
                        List<IManualComponent> textComps = ManualResourceLoader.getTextComp(display, otherComponents, prevLine);
                        ArrayList<IManualComponent> arrayList = new ArrayList<IManualComponent>();
                        for (IManualComponent iManualComponent : textComps) {
                            String displ = ((TextComponent)iManualComponent).toString();
                            arrayList.add(new ConfigComponent(iManualComponent.getX(), iManualComponent.getY(), displ, s));
                        }
                        return arrayList;
                    }
                    if (s.startsWith("@configitemname@")) {
                        Object o;
                        String itemname;
                        boolean prevLine = false;
                        if ((s = s.replace("@configitemname@", "")).contains("#prevline")) {
                            s = s.replace("#prevline", "");
                            prevLine = true;
                        }
                        if ((itemname = (o = AnimaniaHelper.getConfigValue(s)) + "").isEmpty()) {
                            return Collections.EMPTY_LIST;
                        }
                        ItemStack stack = StringParser.getItemStack(itemname);
                        if (stack.func_190926_b()) {
                            return Collections.EMPTY_LIST;
                        }
                        String string = stack.func_82833_r();
                        TextComponent textComponent = new TextComponent(0, offsetY + 1, string);
                        if (prevLine) {
                            IManualComponent iManualComponent = ManualResourceLoader.getTextComp(string, otherComponents, true).get(0);
                            textComponent.setX(iManualComponent.getX()).setY(iManualComponent.getY());
                            if (Minecraft.func_71410_x().field_71466_p.func_78256_a(string) > 114 - textComponent.getX()) {
                                textComponent.setX(0).setY(offsetY + 1);
                            }
                        }
                        return ManualResourceLoader.getList(textComponent);
                    }
                    if (s.startsWith("@text@")) {
                        s = s.replace("@text@", "");
                        boolean prevLine = false;
                        if (s.contains("#prevline")) {
                            prevLine = true;
                            s = s.replace("#prevline", "");
                        }
                        return ManualResourceLoader.getTextComp(AnimaniaHelper.translateWithFormattingCodes(s), otherComponents, prevLine);
                    }
                    String translated = AnimaniaHelper.translateWithFormattingCodes(s);
                    return ManualResourceLoader.getTextComp(translated, otherComponents, false);
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static List<IManualComponent> getTextComp(String s, List<IManualComponent> otherComponents, boolean prevLine) {
        int strWidth;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int offsetY = 0;
        int offsetX = 0;
        if (s.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (!otherComponents.isEmpty()) {
            IManualComponent lastComponent = otherComponents.get(otherComponents.size() - 1);
            if (!prevLine) {
                offsetY = lastComponent.getY() + lastComponent.getObjectHeight();
            }
            if (prevLine) {
                offsetY = lastComponent.getY();
                offsetX = lastComponent.getX() + lastComponent.getObjectWidth() + GuiManual.LINE_X_OFFSET;
            }
        }
        if (offsetX >= 114) {
            offsetX = 0;
        }
        if ((strWidth = fr.func_78256_a(s)) > 114 - offsetX) {
            IManualComponent lastComponent;
            List wrappedStrings;
            String firstWrapped = "";
            if (fr.func_78256_a(s.split(" ")[0]) < 114 - offsetX) {
                wrappedStrings = fr.func_78271_c(s, 114 - offsetX);
                firstWrapped = (String)wrappedStrings.get(0);
                s = s.replaceFirst(Pattern.quote(firstWrapped), "");
            }
            String format = FontRenderer.func_78282_e((String)(firstWrapped.isEmpty() ? s : firstWrapped));
            wrappedStrings = fr.func_78271_c(format + s, 114);
            ArrayList<IManualComponent> comps = new ArrayList<IManualComponent>();
            if (!firstWrapped.isEmpty()) {
                TextComponent first;
                if (fr.func_78256_a(firstWrapped) > 114 - offsetX) {
                    if (!otherComponents.isEmpty()) {
                        lastComponent = otherComponents.get(otherComponents.size() - 1);
                        offsetY = lastComponent.getY() + lastComponent.getObjectHeight();
                    }
                    first = new TextComponent(0, offsetY, firstWrapped);
                    comps.add(first);
                    offsetX = 0;
                } else {
                    first = new TextComponent(offsetX, offsetY, firstWrapped);
                    offsetY = first.getY() + first.getObjectHeight();
                    comps.add(first);
                    offsetX = 0;
                }
            } else if (!otherComponents.isEmpty()) {
                lastComponent = otherComponents.get(otherComponents.size() - 1);
                offsetY = lastComponent.getY() + lastComponent.getObjectHeight();
            }
            for (String str : wrappedStrings) {
                if (str.isEmpty()) continue;
                TextComponent comp = new TextComponent(0, offsetY + 1, str);
                offsetY = comp.getY() + comp.getObjectHeight();
                comps.add(comp);
            }
            return comps;
        }
        if (!prevLine) {
            TextComponent comp = new TextComponent(0, offsetY + 1, s);
            return ManualResourceLoader.getList(comp);
        }
        TextComponent first = new TextComponent(offsetX, offsetY, s);
        return ManualResourceLoader.getList(first);
    }

    public static List<IManualComponent> getList(IManualComponent ... components) {
        return Arrays.asList(components);
    }
}

