/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.handler;

import com.animania.common.helper.InvalidConfigException;
import com.animania.common.helper.StringParser;
import com.animania.common.items.ItemAnimaniaFood;
import com.animania.config.AnimaniaConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;

public class FoodValueHandler {
    private static Map<ItemAnimaniaFood, String> food_values = new HashMap<ItemAnimaniaFood, String>();

    public static void init() {
        String[] overrides;
        for (String s : overrides = AnimaniaConfig.foodValues.foodValueOverrides) {
            if (s.isEmpty()) continue;
            String name = s;
            boolean errored = false;
            if (!name.contains("(")) {
                new InvalidConfigException("Missing ( in line: " + s).printException();
                errored = true;
            }
            if (!name.contains(")")) {
                new InvalidConfigException("Missing ) in line: " + s).printException();
                errored = true;
            }
            if (errored) continue;
            String values = name.substring(name.indexOf("("));
            Item item = StringParser.getItem(name = name.replace(values, ""));
            if (!(item instanceof ItemAnimaniaFood)) {
                new InvalidConfigException("The item specified is not a food item from Animania: " + name).printException();
                errored = true;
            }
            values = values.replace("(", "");
            if (!(values = values.replace(")", "")).contains(",")) {
                new InvalidConfigException("Missing number separator (comma) in line: " + s).printException();
                errored = true;
            }
            if (errored) continue;
            String[] v = values.split(",");
            try {
                int n = Integer.parseInt(v[0]);
            }
            catch (Exception e) {
                new InvalidConfigException(v[0] + " at line " + s + " is not a valid Integer").printException();
                errored = true;
            }
            try {
                float e = Float.parseFloat(v[1]);
            }
            catch (Exception e) {
                new InvalidConfigException(v[1] + " at line " + s + " is not a valid Float").printException();
                errored = true;
            }
            if (errored) continue;
            food_values.put((ItemAnimaniaFood)item, values);
        }
    }

    public static boolean hasOverride(Item item) {
        return food_values.containsKey(item);
    }

    public static int getHealAmount(Item item) {
        String s = food_values.get(item);
        String[] values = s.split(",");
        int healAmount = Integer.parseInt(values[0]);
        return healAmount;
    }

    public static float getSaturation(Item item) {
        String s = food_values.get(item);
        String[] values = s.split(",");
        float saturation = Float.parseFloat(values[1]);
        return saturation;
    }
}

