/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.events;

import com.animania.Animania;
import com.animania.common.entities.amphibians.EntityAmphibian;
import com.animania.common.entities.chickens.ChickenLeghorn;
import com.animania.common.entities.chickens.ChickenOrpington;
import com.animania.common.entities.chickens.ChickenPlymouthRock;
import com.animania.common.entities.chickens.ChickenRhodeIslandRed;
import com.animania.common.entities.chickens.ChickenWyandotte;
import com.animania.common.entities.chickens.EntityAnimaniaChicken;
import com.animania.common.entities.cows.CowAngus;
import com.animania.common.entities.cows.CowFriesian;
import com.animania.common.entities.cows.CowHereford;
import com.animania.common.entities.cows.CowHighland;
import com.animania.common.entities.cows.CowHolstein;
import com.animania.common.entities.cows.CowLonghorn;
import com.animania.common.entities.cows.CowMooshroom;
import com.animania.common.entities.cows.EntityAnimaniaCow;
import com.animania.common.entities.goats.EntityAnimaniaGoat;
import com.animania.common.entities.horses.EntityAnimaniaHorse;
import com.animania.common.entities.horses.HorseDraft;
import com.animania.common.entities.pigs.EntityAnimaniaPig;
import com.animania.common.entities.pigs.PigDuroc;
import com.animania.common.entities.pigs.PigHampshire;
import com.animania.common.entities.pigs.PigLargeBlack;
import com.animania.common.entities.pigs.PigOldSpot;
import com.animania.common.entities.pigs.PigYorkshire;
import com.animania.common.entities.rodents.EntityFerretBase;
import com.animania.common.entities.rodents.EntityHamster;
import com.animania.common.entities.rodents.EntityHedgehogBase;
import com.animania.common.entities.rodents.rabbits.EntityAnimaniaRabbit;
import com.animania.common.entities.rodents.rabbits.RabbitChinchilla;
import com.animania.common.entities.rodents.rabbits.RabbitCottonail;
import com.animania.common.entities.rodents.rabbits.RabbitHavana;
import com.animania.common.entities.rodents.rabbits.RabbitJack;
import com.animania.common.entities.sheep.EntityAnimaniaSheep;
import com.animania.common.entities.sheep.SheepDorset;
import com.animania.common.entities.sheep.SheepFriesian;
import com.animania.common.entities.sheep.SheepMerino;
import com.animania.common.entities.sheep.SheepSuffolk;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.compat.top.providers.entity.TOPInfoProviderBase;
import com.animania.config.AnimaniaConfig;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SpawnHandler {
    @SubscribeEvent
    public void removeSpawns(LivingSpawnEvent.CheckSpawn event) {
        BlockPos pos = new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ());
        World worldIn = event.getWorld();
        Biome biome = event.getWorld().func_180494_b(pos);
        int chooser = 0;
        TOPInfoProviderBase replacementEntity = null;
        if (AnimaniaConfig.gameRules.replaceVanillaCows && (event.getEntity().getClass().equals(EntityCow.class) || event.getEntity().getClass().equals(EntityMooshroom.class)) && !worldIn.field_72995_K) {
            List<EntityLivingBase> otheranimals;
            if (!event.getEntity().func_145818_k_()) {
                event.setResult(Event.Result.DENY);
            }
            if ((otheranimals = AnimaniaHelper.getEntitiesInRange(EntityLivingBase.class, 100.0, event.getEntity().field_70170_p, pos)).size() <= 2) {
                chooser = Animania.RANDOM.nextInt(2) + 1;
                if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.cowHolsteinBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new CowHolstein.EntityCowHolstein(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new CowHolstein.EntityBullHolstein(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.cowLonghornBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new CowLonghorn.EntityCowLonghorn(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new CowLonghorn.EntityBullLonghorn(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.cowHerefordBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new CowHereford.EntityCowHereford(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new CowHereford.EntityBullHereford(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.cowHighlandBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new CowHighland.EntityCowHighland(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new CowHighland.EntityBullHighland(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.cowAngusBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new CowAngus.EntityCowAngus(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new CowAngus.EntityBullAngus(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.cowMooshroomBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new CowMooshroom.EntityCowMooshroom(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new CowMooshroom.EntityBullMooshroom(worldIn);
                    }
                } else if (chooser == 1) {
                    replacementEntity = new CowFriesian.EntityCowFriesian(worldIn);
                } else if (chooser == 2) {
                    replacementEntity = new CowFriesian.EntityBullFriesian(worldIn);
                }
            }
        } else if (AnimaniaConfig.gameRules.replaceVanillaPigs && event.getEntity().getClass().equals(EntityPig.class) && !worldIn.field_72995_K) {
            if (!event.getEntity().func_145818_k_()) {
                event.setResult(Event.Result.DENY);
            }
            chooser = Animania.RANDOM.nextInt(2) + 1;
            List<EntityLivingBase> otheranimals = AnimaniaHelper.getEntitiesInRange(EntityLivingBase.class, 100.0, event.getEntity().field_70170_p, pos);
            if (otheranimals.size() <= 2) {
                chooser = Animania.RANDOM.nextInt(2) + 1;
                if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.pigOldSpotBiomeTypes))) {
                    if (Animania.RANDOM.nextBoolean()) {
                        if (chooser == 1) {
                            replacementEntity = new PigOldSpot.EntitySowOldSpot(worldIn);
                        } else if (chooser == 2) {
                            replacementEntity = new PigOldSpot.EntityHogOldSpot(worldIn);
                        }
                    } else if (chooser == 1) {
                        replacementEntity = new PigHampshire.EntitySowHampshire(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new PigHampshire.EntityHogHampshire(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.pigDurocBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new PigDuroc.EntitySowDuroc(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new PigDuroc.EntityHogDuroc(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.pigLargeBlackBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new PigLargeBlack.EntitySowLargeBlack(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new PigLargeBlack.EntityHogLargeBlack(worldIn);
                    }
                } else if (chooser == 1) {
                    replacementEntity = new PigYorkshire.EntitySowYorkshire(worldIn);
                } else if (chooser == 2) {
                    replacementEntity = new PigYorkshire.EntityHogYorkshire(worldIn);
                }
            }
        } else if (AnimaniaConfig.gameRules.replaceVanillaChickens && event.getEntity().getClass().equals(EntityChicken.class) && !worldIn.field_72995_K) {
            if (!event.getEntity().func_145818_k_()) {
                event.setResult(Event.Result.DENY);
            }
            chooser = Animania.RANDOM.nextInt(2) + 1;
            List<EntityLivingBase> otheranimals = AnimaniaHelper.getEntitiesInRange(EntityLivingBase.class, 100.0, event.getEntity().field_70170_p, pos);
            if (otheranimals.size() <= 2) {
                chooser = Animania.RANDOM.nextInt(3);
                if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.chickenOrpingtonBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new ChickenOrpington.EntityHenOrpington(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new ChickenOrpington.EntityRoosterOrpington(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.chickenPlymouthRockBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new ChickenPlymouthRock.EntityHenPlymouthRock(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new ChickenPlymouthRock.EntityRoosterPlymouthRock(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.chickenRhodeIslandRedBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new ChickenRhodeIslandRed.EntityHenRhodeIslandRed(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new ChickenRhodeIslandRed.EntityRoosterRhodeIslandRed(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.chickenWyandotteBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new ChickenWyandotte.EntityHenWyandotte(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new ChickenWyandotte.EntityRoosterWyandotte(worldIn);
                    }
                } else if (chooser == 1) {
                    replacementEntity = new ChickenLeghorn.EntityHenLeghorn(worldIn);
                } else if (chooser == 2) {
                    replacementEntity = new ChickenLeghorn.EntityRoosterLeghorn(worldIn);
                }
            }
        } else if (AnimaniaConfig.gameRules.replaceVanillaSheep && event.getEntity().getClass().equals(EntitySheep.class) && !worldIn.field_72995_K) {
            if (!event.getEntity().func_145818_k_()) {
                event.setResult(Event.Result.DENY);
            }
            chooser = Animania.RANDOM.nextInt(2) + 1;
            List<EntityLivingBase> otheranimals = AnimaniaHelper.getEntitiesInRange(EntityLivingBase.class, 100.0, event.getEntity().field_70170_p, pos);
            if (otheranimals.size() <= 2) {
                chooser = Animania.RANDOM.nextInt(3);
                if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.sheepDorsetBiomeTypes))) {
                    int chooser2 = Animania.RANDOM.nextInt(2);
                    if (Animania.RANDOM.nextBoolean()) {
                        if (chooser == 1) {
                            replacementEntity = new SheepDorset.EntityEweDorset(worldIn);
                        } else if (chooser == 2) {
                            replacementEntity = new SheepDorset.EntityRamDorset(worldIn);
                        }
                    } else if (chooser == 1) {
                        replacementEntity = new SheepFriesian.EntityEweFriesian(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new SheepFriesian.EntityRamFriesian(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.sheepSuffolkBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new SheepSuffolk.EntityEweSuffolk(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new SheepSuffolk.EntityRamSuffolk(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.sheepDorsetBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new SheepDorset.EntityEweDorset(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new SheepDorset.EntityRamDorset(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.sheepMerinoBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new SheepMerino.EntityEweMerino(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new SheepMerino.EntityRamMerino(worldIn);
                    }
                } else if (chooser == 1) {
                    replacementEntity = new SheepFriesian.EntityEweFriesian(worldIn);
                } else if (chooser == 2) {
                    replacementEntity = new SheepFriesian.EntityRamFriesian(worldIn);
                }
            }
        } else if (AnimaniaConfig.gameRules.replaceVanillaRabbits && event.getEntity().getClass().equals(EntityRabbit.class) && !worldIn.field_72995_K) {
            if (!event.getEntity().func_145818_k_()) {
                event.setResult(Event.Result.DENY);
            }
            chooser = Animania.RANDOM.nextInt(2) + 1;
            List<EntityLivingBase> otheranimals = AnimaniaHelper.getEntitiesInRange(EntityLivingBase.class, 100.0, event.getEntity().field_70170_p, pos);
            if (otheranimals.size() <= 2) {
                chooser = Animania.RANDOM.nextInt(3);
                if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.rabbitCottontailBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new RabbitCottonail.EntityRabbitBuckCottontail(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new RabbitCottonail.EntityRabbitDoeCottontail(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.rabbitJackBiomeTypes)) || AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.rabbitJackBiomeTypes)[1])) {
                    if (chooser == 1) {
                        replacementEntity = new RabbitJack.EntityRabbitBuckJack(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new RabbitJack.EntityRabbitDoeJack(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.rabbitHavanaBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new RabbitHavana.EntityRabbitBuckHavana(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new RabbitHavana.EntityRabbitDoeHavana(worldIn);
                    }
                } else if (AnimaniaHelper.hasBiomeType(biome, AnimaniaHelper.getBiomeTypes(AnimaniaConfig.spawnLocations.rabbitChinchillaBiomeTypes))) {
                    if (chooser == 1) {
                        replacementEntity = new RabbitChinchilla.EntityRabbitDoeChinchilla(worldIn);
                    } else if (chooser == 2) {
                        replacementEntity = new RabbitChinchilla.EntityRabbitBuckChinchilla(worldIn);
                    }
                } else if (chooser == 1) {
                    replacementEntity = new RabbitCottonail.EntityRabbitBuckCottontail(worldIn);
                } else if (chooser == 2) {
                    replacementEntity = new RabbitCottonail.EntityRabbitDoeCottontail(worldIn);
                }
            }
        } else if (AnimaniaConfig.gameRules.replaceVanillaHorses && event.getEntity().getClass().equals(EntityHorse.class) && !worldIn.field_72995_K) {
            if (!event.getEntity().func_145818_k_()) {
                event.setResult(Event.Result.DENY);
            }
        } else if (AnimaniaConfig.spawn.spawnAnimaniaHorses && event.getEntity().getClass().equals(EntityHorse.class) && !worldIn.field_72995_K) {
            boolean toggler = Animania.RANDOM.nextBoolean();
            if (!event.getEntity().func_145818_k_() && toggler) {
                event.setResult(Event.Result.DENY);
                replacementEntity = Animania.RANDOM.nextBoolean() ? new HorseDraft.EntityMareDraftHorse(worldIn) : new HorseDraft.EntityStallionDraftHorse(worldIn);
            }
        } else if (!(AnimaniaConfig.spawn.spawnFreshWaterSquids || !event.getEntity().getClass().equals(EntitySquid.class) || worldIn.field_72995_K || AnimaniaHelper.hasBiomeType(biome, BiomeDictionary.Type.OCEAN) || event.getEntity().func_145818_k_())) {
            event.setResult(Event.Result.DENY);
        }
        if (replacementEntity != null) {
            replacementEntity.func_70107_b(event.getX(), event.getY(), event.getZ());
            event.getWorld().func_72838_d(replacementEntity);
        }
    }

    @SubscribeEvent
    public void limitAnimaniaSpawns(LivingSpawnEvent.CheckSpawn event) {
        List<EntityHedgehogBase> others;
        BlockPos pos = new BlockPos((double)event.getX(), (double)(event.getY() + 1.0f), (double)event.getZ());
        World worldIn = event.getWorld();
        Biome biome = event.getWorld().func_180494_b(pos);
        if (AnimaniaConfig.spawn.spawnAnimaniaCows && event.getEntity() instanceof EntityAnimaniaCow && !worldIn.field_72995_K) {
            List<EntityAnimaniaCow> others2 = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaCow.class, 100.0, event.getEntity().field_70170_p, pos);
            if (others2.size() > AnimaniaConfig.spawn.spawnLimitCows) {
                event.setResult(Event.Result.DENY);
            }
        } else if (AnimaniaConfig.spawn.spawnAnimaniaPigs && event.getEntity() instanceof EntityAnimaniaPig && !worldIn.field_72995_K) {
            List<EntityAnimaniaPig> others3 = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaPig.class, 100.0, event.getEntity().field_70170_p, pos);
            if (others3.size() > AnimaniaConfig.spawn.spawnLimitPigs) {
                event.setResult(Event.Result.DENY);
            }
        } else if (AnimaniaConfig.spawn.spawnAnimaniaChickens && event.getEntity() instanceof EntityAnimaniaChicken && !worldIn.field_72995_K) {
            List<EntityAnimaniaChicken> others4 = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaChicken.class, 100.0, event.getEntity().field_70170_p, pos);
            if (others4.size() > AnimaniaConfig.spawn.spawnLimitChickens) {
                event.setResult(Event.Result.DENY);
            }
        } else if (AnimaniaConfig.spawn.spawnAnimaniaSheep && event.getEntity() instanceof EntityAnimaniaSheep && !worldIn.field_72995_K) {
            List<EntityAnimaniaSheep> others5 = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaSheep.class, 100.0, event.getEntity().field_70170_p, pos);
            if (others5.size() > AnimaniaConfig.spawn.spawnLimitSheep) {
                event.setResult(Event.Result.DENY);
            }
        } else if (AnimaniaConfig.spawn.spawnAnimaniaGoats && event.getEntity() instanceof EntityAnimaniaGoat && !worldIn.field_72995_K) {
            List<EntityAnimaniaGoat> others6 = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaGoat.class, 100.0, event.getEntity().field_70170_p, pos);
            if (others6.size() > AnimaniaConfig.spawn.spawnLimitGoats) {
                event.setResult(Event.Result.DENY);
            }
        } else if (AnimaniaConfig.spawn.spawnAnimaniaRabbits && event.getEntity() instanceof EntityAnimaniaRabbit && !worldIn.field_72995_K) {
            List<EntityAnimaniaRabbit> others7 = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaRabbit.class, 100.0, event.getEntity().field_70170_p, pos);
            if (others7.size() > AnimaniaConfig.spawn.spawnLimitRabbits) {
                event.setResult(Event.Result.DENY);
            }
        } else if (AnimaniaConfig.spawn.spawnAnimaniaHorses && event.getEntity() instanceof EntityAnimaniaHorse && !worldIn.field_72995_K) {
            List<EntityAnimaniaHorse> others8 = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaHorse.class, 100.0, event.getEntity().field_70170_p, pos);
            if (others8.size() > AnimaniaConfig.spawn.spawnLimitHorses) {
                event.setResult(Event.Result.DENY);
            }
        } else if (AnimaniaConfig.spawn.spawnAnimaniaHorses && event.getEntity() instanceof EntityAnimaniaHorse && !worldIn.field_72995_K) {
            List<EntityAnimaniaHorse> others9 = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaHorse.class, 100.0, event.getEntity().field_70170_p, pos);
            if (others9.size() > AnimaniaConfig.spawn.spawnLimitHorses) {
                event.setResult(Event.Result.DENY);
            }
        } else if (AnimaniaConfig.spawn.spawnAnimaniaAmphibians && event.getEntity() instanceof EntityAmphibian && !worldIn.field_72995_K) {
            List<EntityAmphibian> others10 = AnimaniaHelper.getEntitiesInRange(EntityAmphibian.class, 100.0, event.getEntity().field_70170_p, pos);
            if (others10.size() > AnimaniaConfig.spawn.spawnLimitAmphibians) {
                event.setResult(Event.Result.DENY);
            }
        } else if (AnimaniaConfig.spawn.spawnAnimaniaRodents && event.getEntity() instanceof EntityHamster && !worldIn.field_72995_K) {
            List<EntityHamster> others11 = AnimaniaHelper.getEntitiesInRange(EntityHamster.class, 100.0, event.getEntity().field_70170_p, pos);
            if (others11.size() > AnimaniaConfig.spawn.spawnLimitHamsters) {
                event.setResult(Event.Result.DENY);
            }
        } else if (AnimaniaConfig.spawn.spawnAnimaniaRodents && event.getEntity() instanceof EntityFerretBase && !worldIn.field_72995_K) {
            List<EntityFerretBase> others12 = AnimaniaHelper.getEntitiesInRange(EntityFerretBase.class, 100.0, event.getEntity().field_70170_p, pos);
            if (others12.size() > AnimaniaConfig.spawn.spawnLimitFerrets) {
                event.setResult(Event.Result.DENY);
            }
        } else if (AnimaniaConfig.spawn.spawnAnimaniaRodents && event.getEntity() instanceof EntityHedgehogBase && !worldIn.field_72995_K && (others = AnimaniaHelper.getEntitiesInRange(EntityHedgehogBase.class, 100.0, event.getEntity().field_70170_p, pos)).size() > AnimaniaConfig.spawn.spawnLimitFerrets) {
            event.setResult(Event.Result.DENY);
        }
    }
}

