/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.events;

import com.animania.api.interfaces.IAnimaniaAnimal;
import com.animania.api.interfaces.ISleeping;
import com.animania.common.handler.ItemHandler;
import com.animania.config.AnimaniaConfig;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityEventHandler {
    @SubscribeEvent
    public void onEntityTakeDamage(LivingHurtEvent event) {
        float amount = event.getAmount();
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (entity instanceof EntityAnimal) {
            EntityAnimal animal = (EntityAnimal)entity;
            if (source == DamageSource.field_76379_h && animal.func_110167_bD()) {
                event.setAmount(amount * AnimaniaConfig.gameRules.fallDamageReduceMultiplier);
                animal.field_70143_R = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onEntityHit(LivingAttackEvent event) {
        ISleeping isleeping;
        EntityLivingBase animal;
        float amount = event.getAmount();
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (entity instanceof EntityLivingBase && entity instanceof IAnimaniaAnimal && (animal = entity).func_184218_aH()) {
            event.setCanceled(true);
        }
        if (entity instanceof ISleeping && (isleeping = (ISleeping)entity).getSleeping()) {
            if (source == DamageSource.field_76366_f) {
                event.setCanceled(true);
            }
            ((ISleeping)entity).setSleeping(false);
        }
        if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70906_o()) {
            ((EntityTameable)entity).func_70904_g(false);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            ItemHandler.regItemEggColors(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        ISleeping isleeping;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof ISleeping && entity instanceof EntityAnimal && (isleeping = (ISleeping)entity).getSleeping() && ((EntityAnimal)entity).func_110167_bD()) {
            isleeping.setSleeping(false);
        }
    }
}

