/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.pigs;

import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.IImpregnable;
import com.animania.api.interfaces.IMateable;
import com.animania.common.ModSoundEvents;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.pigs.EntityAnimaniaPig;
import com.animania.common.entities.pigs.EntityHogBase;
import com.animania.compat.top.providers.entity.TOPInfoProviderPig;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class EntitySowBase
extends EntityAnimaniaPig
implements TOPInfoProviderPig,
IMateable,
IImpregnable {
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntitySowBase.class, (DataSerializer)DataSerializers.field_187203_m);
    public int dryTimerSow;
    protected static final DataParameter<Boolean> PREGNANT = EntityDataManager.func_187226_a(EntitySowBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HAS_KIDS = EntityDataManager.func_187226_a(EntitySowBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FERTILE = EntityDataManager.func_187226_a(EntitySowBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> GESTATION_TIMER = EntityDataManager.func_187226_a(EntitySowBase.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntitySowBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.1f, 1.0f);
        this.field_70130_N = 1.1f;
        this.field_70131_O = 1.0f;
        this.field_70138_W = 1.1f;
        this.gender = EntityGender.FEMALE;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        GenericBehavior.initialSpawnFemale(this, EntityAnimaniaPig.class);
        return livingdata;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.265);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer entityplayer = (EntityPlayer)entity;
        ItemStack itemstack = entityplayer.func_184614_ca();
        if (itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == Items.field_151146_bM) {
            return true;
        }
        itemstack = entityplayer.func_184592_cb();
        return itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == Items.field_151146_bM;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(PREGNANT, (Object)false);
        this.field_70180_af.func_187214_a(HAS_KIDS, (Object)false);
        this.field_70180_af.func_187214_a(FERTILE, (Object)true);
        this.field_70180_af.func_187214_a(GESTATION_TIMER, (Object)(AnimaniaConfig.careAndFeeding.gestationTimer + this.field_70146_Z.nextInt(200)));
    }

    @Override
    public DataParameter<Integer> getGestationParam() {
        return GESTATION_TIMER;
    }

    @Override
    public DataParameter<Boolean> getPregnantParam() {
        return PREGNANT;
    }

    @Override
    public int getDryTimer() {
        return this.dryTimerSow;
    }

    @Override
    public void setDryTimer(int i) {
        this.dryTimerSow = i;
    }

    @Override
    public DataParameter<Boolean> getFertileParam() {
        return FERTILE;
    }

    @Override
    public DataParameter<Boolean> getHasKidsParam() {
        return HAS_KIDS;
    }

    @Override
    public DataParameter<Optional<UUID>> getMateUniqueIdParam() {
        return MATE_UNIQUE_ID;
    }

    protected SoundEvent func_184639_G() {
        return GenericBehavior.getAmbientSound(this, ModSoundEvents.pig1, ModSoundEvents.pig2, ModSoundEvents.pig4, ModSoundEvents.pig5, ModSoundEvents.pig6, ModSoundEvents.pig7);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return GenericBehavior.getRandomSound(ModSoundEvents.pigHurt1, ModSoundEvents.pigHurt2, ModSoundEvents.pig3);
    }

    protected SoundEvent func_184615_bR() {
        return GenericBehavior.getRandomSound(ModSoundEvents.pigHurt1, ModSoundEvents.pigHurt2, ModSoundEvents.pig3);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() == Items.field_151146_bM && !this.func_184207_aI() && this.getWatered() && this.getFed()) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
    }

    @Override
    public void func_70636_d() {
        GenericBehavior.livingUpdateFemale(this, EntityHogBase.class);
        super.func_70636_d();
    }

    public EntitySowBase createChild(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && (EntityAnimaniaPig.TEMPTATION_ITEMS.contains(stack.func_77973_b()) || ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.slop));
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (player.func_70093_af()) {
            if (this.getMateUniqueId() != null) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.mated"));
            }
            if (this.getFertile() && !this.getPregnant()) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.fertile1"));
            }
            if (this.getPregnant()) {
                if (this.getGestation() > 1) {
                    int bob = this.getGestation();
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1") + " (" + bob + " " + I18n.func_74838_a((String)"text.waila.pregnant2") + ")");
                } else {
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1"));
                }
            }
        }
        TOPInfoProviderPig.super.addProbeInfo(mode, probeInfo, player, world, entity, data);
    }
}

