/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.pigs;

import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.IMateable;
import com.animania.api.interfaces.ISterilizable;
import com.animania.common.ModSoundEvents;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIMate;
import com.animania.common.entities.pigs.EntityAnimaniaPig;
import com.animania.common.entities.pigs.EntityPigletBase;
import com.animania.common.entities.pigs.EntitySowBase;
import com.animania.compat.top.providers.entity.TOPInfoProviderPig;
import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityHogBase
extends EntityAnimaniaPig
implements TOPInfoProviderPig,
IMateable,
ISterilizable {
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityHogBase.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Boolean> STERILIZED = EntityDataManager.func_187226_a(EntityHogBase.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityHogBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70130_N = 1.0f;
        this.field_70131_O = 1.0f;
        this.field_70138_W = 1.1f;
        this.gender = EntityGender.MALE;
        if (!this.getSterilized()) {
            this.field_70714_bg.func_75776_a(3, new GenericAIMate(this, 1.0, EntitySowBase.class, EntityPigletBase.class, EntityAnimaniaPig.class));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.265);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer entityplayer = (EntityPlayer)entity;
        ItemStack itemstack = entityplayer.func_184614_ca();
        if (itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == Items.field_151146_bM) {
            return true;
        }
        itemstack = entityplayer.func_184592_cb();
        return itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == Items.field_151146_bM;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(STERILIZED, (Object)false);
    }

    @Override
    public DataParameter<Optional<UUID>> getMateUniqueIdParam() {
        return MATE_UNIQUE_ID;
    }

    protected SoundEvent func_184639_G() {
        return GenericBehavior.getAmbientSound(this, ModSoundEvents.hog1, ModSoundEvents.hog2, ModSoundEvents.hog3, ModSoundEvents.hog4, ModSoundEvents.hog5, ModSoundEvents.pig1, ModSoundEvents.pig2, ModSoundEvents.pig4);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return GenericBehavior.getRandomSound(ModSoundEvents.pigHurt1, ModSoundEvents.pigHurt2, ModSoundEvents.pig3);
    }

    protected SoundEvent func_184615_bR() {
        return GenericBehavior.getRandomSound(ModSoundEvents.pigHurt1, ModSoundEvents.pigHurt2, ModSoundEvents.pig3);
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && !this.getSleeping()) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.2f);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.1f, 0.8f);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() == Items.field_151146_bM && !this.func_184207_aI() && this.getWatered() && this.getFed()) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        GenericBehavior.livingUpdateMateable(this, EntitySowBase.class);
        super.func_70636_d();
    }

    public EntityHogBase createChild(EntityAgeable ageable) {
        return null;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && (EntityAnimaniaPig.TEMPTATION_ITEMS.contains(stack.func_77973_b()) || ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.slop));
    }

    @Override
    public DataParameter<Boolean> getSterilizedParam() {
        return STERILIZED;
    }

    @Override
    public void sterilize() {
        Iterator it = this.field_70714_bg.field_75782_a.iterator();
        while (it.hasNext()) {
            EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)it.next();
            EntityAIBase ai = entry.field_75733_a;
            if (!(ai instanceof GenericAIMate)) continue;
            entry.field_188524_c = false;
            ai.func_75251_c();
            it.remove();
        }
        this.setSterilized(true);
    }
}

