/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.pigs;

import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.api.interfaces.IAnimaniaAnimalBase;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindSaltLick;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAILookIdle;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISleep;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWanderAvoidWater;
import com.animania.common.entities.generic.ai.GenericAIWatchClosest;
import com.animania.common.entities.pigs.EntityPigletBase;
import com.animania.common.entities.pigs.PigType;
import com.animania.common.entities.pigs.ai.EntityAIFindMud;
import com.animania.common.entities.pigs.ai.EntityAIPigSnuffle;
import com.animania.common.entities.pigs.ai.EntityAITemptItemStack;
import com.animania.common.handler.BlockHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.config.AnimaniaConfig;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimaniaPig
extends EntityPig
implements IAnimaniaAnimalBase {
    protected static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> MUDDY = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SPLASHTIMER = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> MUDTIMER = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> PLAYED = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SLEEPTIMER = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> INTERACTED = EntityDataManager.func_187226_a(EntityAnimaniaPig.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemArray(AnimaniaConfig.careAndFeeding.pigFood));
    protected boolean field_184765_bx;
    protected int field_184766_bz;
    protected int field_184767_bA;
    public int eatTimer;
    public EntityAIPigSnuffle entityAIEatGrass;
    protected int fedTimer;
    protected int wateredTimer;
    protected int playedTimer;
    protected int happyTimer;
    public int blinkTimer;
    protected int damageTimer;
    protected ItemStack slop;
    protected PigType pigType;
    protected EntityGender gender;

    public EntityAnimaniaPig(World worldIn) {
        super(worldIn);
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        this.playedTimer = AnimaniaConfig.careAndFeeding.playTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 80 + this.field_70146_Z.nextInt(80);
        this.func_110163_bv();
        this.slop = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)BlockHandler.fluidSlop);
        this.entityAIEatGrass = new EntityAIPigSnuffle(this);
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)this.entityAIEatGrass);
        this.initAI();
    }

    protected void initAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFindMud(this, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.0));
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(3, new GenericAIFindWater<EntityAnimaniaPig>(this, 1.0, this.entityAIEatGrass, EntityAnimaniaPig.class));
            this.field_70714_bg.func_75776_a(3, new GenericAIFindFood<EntityAnimaniaPig>(this, 1.0, this.entityAIEatGrass, true));
        }
        this.field_70714_bg.func_75776_a(4, new GenericAIPanic<EntityAnimaniaPig>(this, 1.5));
        if (AnimaniaConfig.gameRules.animalsSleep) {
            this.field_70714_bg.func_75776_a(8, new GenericAISleep<EntityAnimaniaPig>(this, 0.8, AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.pigBed), AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.pigBed2), EntityAnimaniaPig.class));
        }
        this.field_70714_bg.func_75776_a(9, new GenericAITempt<EntityAnimaniaPig>(this, 1.2, Items.field_151146_bM, false));
        this.field_70714_bg.func_75776_a(10, new GenericAITempt<EntityAnimaniaPig>(this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAITemptItemStack(this, 1.2, UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)BlockHandler.fluidSlop)));
        this.field_70714_bg.func_75776_a(12, new GenericAIFindSaltLick<EntityAnimaniaPig>(this, 1.0, this.entityAIEatGrass));
        this.field_70714_bg.func_75776_a(13, (EntityAIBase)new GenericAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(15, new GenericAILookIdle<EntityAnimaniaPig>(this));
        this.field_70715_bh.func_75776_a(16, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_184651_r() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public void func_191986_a(float p_191986_1_, float p_191986_2_, float p_191986_3_) {
        Entity entity;
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = entity.field_70177_z;
            this.field_70125_A = entity.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.field_184765_bx && this.field_184766_bz++ > this.field_184767_bA) {
                this.field_184765_bx = false;
            }
            if (this.func_184186_bw()) {
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.225f;
                if (this.field_184765_bx) {
                    f += f * 1.15f * MathHelper.func_76126_a((float)((float)this.field_184766_bz / (float)this.field_184767_bA * (float)Math.PI));
                }
                this.func_70659_e(f);
                super.func_191986_a(0.0f, 0.0f, 1.0f);
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            p_191986_3_ = this.field_191988_bg;
            this.field_70747_aH = 0.02f;
            super.func_191986_a(p_191986_1_, p_191986_2_, p_191986_3_);
        }
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(MUDDY, (Object)false);
        this.field_70180_af.func_187214_a(MUDTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SPLASHTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(PLAYED, (Object)true);
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(INTERACTED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        GenericBehavior.writeCommonNBT(compound, this);
        compound.func_74757_a("Saddle", this.func_70901_n());
        compound.func_74757_a("Muddy", this.getMuddy());
        compound.func_74776_a("MudTimer", this.getMudTimer().floatValue());
        compound.func_74776_a("SplashTimer", this.getSplashTimer().floatValue());
        compound.func_74757_a("Played", this.getPlayed());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        GenericBehavior.readCommonNBT(compound, this);
        this.func_70900_e(compound.func_74767_n("Saddle"));
        this.setMuddy(compound.func_74767_n("Muddy"));
        this.setMudTimer(Float.valueOf(compound.func_74760_g("MudTimer")));
        this.setSplashTimer(Float.valueOf(compound.func_74760_g("SplashTimer")));
        this.setPlayed(compound.func_74767_n("Played"));
    }

    @Override
    public DataParameter<Integer> getAgeParam() {
        return AGE;
    }

    @Override
    public DataParameter<Boolean> getHandFedParam() {
        return HANDFED;
    }

    @Override
    public DataParameter<Boolean> getSleepingParam() {
        return SLEEPING;
    }

    @Override
    public DataParameter<Float> getSleepTimerParam() {
        return SLEEPTIMER;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151141_av) {
            return true;
        }
        if (stack != ItemStack.field_190927_a && AnimaniaHelper.hasFluid(stack, BlockHandler.fluidSlop) && !this.getSleeping()) {
            if (!player.func_184812_l_()) {
                ItemStack emptied = AnimaniaHelper.emptyContainer(stack);
                stack.func_190918_g(1);
                AnimaniaHelper.addItem(player, emptied);
            }
            this.eatTimer = 40;
            if (this.entityAIEatGrass != null) {
                this.entityAIEatGrass.func_75249_e();
            }
            this.setHandFed(true);
            this.setFed(true);
            this.func_146082_f(player);
            return true;
        }
        return GenericBehavior.interactCommon(this, entityplayer, hand, this.entityAIEatGrass) ? true : super.func_184645_a(player, hand);
    }

    protected ResourceLocation func_184647_J() {
        return this instanceof EntityPigletBase ? null : (this.pigType.isPrime ? new ResourceLocation("animania", "pig_prime") : new ResourceLocation("animania", "pig_regular"));
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        this.func_70628_a(wasRecentlyHit, lootingModifier);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        if (this.func_70901_n()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    public boolean func_70901_n() {
        return this.getBoolFromDataManager(SADDLED);
    }

    public void func_70900_e(boolean saddled) {
        if (saddled) {
            this.field_70180_af.func_187227_b(SADDLED, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(SADDLED, (Object)false);
        }
    }

    @Override
    public DataParameter<Boolean> getFedParam() {
        return FED;
    }

    public void setSlopFed(boolean fed) {
        if (fed) {
            this.field_70180_af.func_187227_b(FED, (Object)true);
            this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer * 2 + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(FED, (Object)false);
        }
    }

    public boolean getPlayed() {
        return this.getBoolFromDataManager(PLAYED);
    }

    public void setPlayed(boolean played) {
        if (played) {
            this.field_70180_af.func_187227_b(PLAYED, (Object)true);
            this.playedTimer = AnimaniaConfig.careAndFeeding.playTimer + this.field_70146_Z.nextInt(100);
        } else {
            this.field_70180_af.func_187227_b(PLAYED, (Object)false);
        }
    }

    @Override
    public DataParameter<Boolean> getWateredParam() {
        return WATERED;
    }

    public boolean getMuddy() {
        return this.getBoolFromDataManager(MUDDY);
    }

    public void setMuddy(boolean muddy) {
        if (muddy) {
            this.field_70180_af.func_187227_b(MUDDY, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(MUDDY, (Object)false);
        }
    }

    public Float getMudTimer() {
        return Float.valueOf(this.getFloatFromDataManager(MUDTIMER));
    }

    public void setMudTimer(Float timer) {
        this.field_70180_af.func_187227_b(MUDTIMER, (Object)Float.valueOf(timer.floatValue()));
    }

    public Float getSplashTimer() {
        return Float.valueOf(this.getFloatFromDataManager(SPLASHTIMER));
    }

    public void setSplashTimer(Float timer) {
        this.field_70180_af.func_187227_b(SPLASHTIMER, (Object)Float.valueOf(timer.floatValue()));
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            EntityPigZombie entitypigzombie = new EntityPigZombie(this.field_70170_p);
            entitypigzombie.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151010_B));
            entitypigzombie.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entitypigzombie.func_94061_f(this.func_175446_cd());
            if (this.func_70631_g_()) {
                entitypigzombie.func_82227_f(true);
            }
            if (this.func_145818_k_()) {
                entitypigzombie.func_96094_a(this.func_95999_t());
                entitypigzombie.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)entitypigzombie);
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        GenericBehavior.livingUpdateCommon(this);
        if (this.playedTimer > -1 && !AnimaniaConfig.gameRules.ambianceMode) {
            --this.playedTimer;
            if (this.playedTimer == 0) {
                this.setPlayed(false);
            }
        }
        if ((double)this.getMudTimer().floatValue() > 0.0) {
            this.setPlayed(true);
            this.playedTimer = AnimaniaConfig.careAndFeeding.playTimer + this.field_70146_Z.nextInt(100);
        }
        boolean played = this.getPlayed();
        BlockPos currentpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Block poschk = this.field_70170_p.func_180495_p(currentpos).func_177230_c();
        if (poschk != null && (poschk == BlockHandler.blockMud || poschk.func_149739_a().equals("tile.mud"))) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 2, 4, false, false));
        }
        super.func_70636_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    protected Item func_146068_u() {
        return null;
    }

    public EntityPig func_90011_a(EntityAgeable ageable) {
        return null;
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.pigType, this.gender));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    @Override
    public EntityGender getEntityGender() {
        return this.gender;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public Set<Item> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public void setLiquidFed(boolean liquidFed) {
        this.setSlopFed(liquidFed);
    }

    @Override
    public Fluid[] getFoodFluids() {
        return new Fluid[]{BlockHandler.fluidSlop};
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }

    @Override
    public void setBlinkTimer(int i) {
        this.blinkTimer = i;
    }

    @Override
    public int getEatTimer() {
        return this.eatTimer;
    }

    @Override
    public void setEatTimer(int i) {
        this.eatTimer = i;
    }

    @Override
    public int getFedTimer() {
        return this.fedTimer;
    }

    @Override
    public void setFedTimer(int i) {
        this.fedTimer = i;
    }

    @Override
    public DataParameter<Boolean> getInteractedParam() {
        return INTERACTED;
    }

    @Override
    public int getWaterTimer() {
        return this.wateredTimer;
    }

    @Override
    public void setWaterTimer(int i) {
        this.wateredTimer = i;
    }

    @Override
    public int getDamageTimer() {
        return this.damageTimer;
    }

    @Override
    public void setDamageTimer(int i) {
        this.damageTimer = i;
    }

    @Override
    public int getHappyTimer() {
        return this.happyTimer;
    }

    @Override
    public void setHappyTimer(int i) {
        this.happyTimer = i;
    }

    @Override
    public AnimaniaType getAnimalType() {
        return this.pigType;
    }
}

