/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.horses;

import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.IMateable;
import com.animania.api.interfaces.ISterilizable;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIMate;
import com.animania.common.entities.horses.EntityAnimaniaHorse;
import com.animania.common.entities.horses.EntityFoalBase;
import com.animania.common.entities.horses.EntityMareBase;
import com.animania.compat.top.providers.entity.TOPInfoProviderMateable;
import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityStallionBase
extends EntityAnimaniaHorse
implements TOPInfoProviderMateable,
IMateable,
ISterilizable {
    protected static final DataParameter<Boolean> STERILIZED = EntityDataManager.func_187226_a(EntityStallionBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityStallionBase.class, (DataSerializer)DataSerializers.field_187203_m);
    private ResourceLocation resourceLocation;
    private ResourceLocation resourceLocationBlink;
    private static final String[] HORSE_TEXTURES = new String[]{"black", "bw1", "bw2", "grey", "red", "white"};
    private boolean boosting;
    private int boostTime;
    private int totalBoostTime;

    public EntityStallionBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.8f, 2.2f);
        this.field_70130_N = 1.8f;
        this.field_70131_O = 2.2f;
        this.field_70138_W = 1.2f;
        this.mateable = true;
        this.gender = EntityGender.MALE;
        if (!this.getSterilized()) {
            this.field_70714_bg.func_75776_a(3, new GenericAIMate(this, 1.0, EntityMareBase.class, EntityFoalBase.class, EntityAnimaniaHorse.class));
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(STERILIZED, (Object)false);
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
        super.func_70088_a();
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.72;
    }

    public void func_110199_f(EntityPlayer playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            this.field_110296_bG.func_110133_a(this.func_70005_c_());
            playerEntity.func_184826_a((AbstractHorse)this, (IInventory)this.field_110296_bG);
        }
    }

    public int func_70646_bf() {
        return super.func_70646_bf();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.func_70681_au().nextInt(841) + 140;
        return true;
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        return this.func_110257_ck();
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187729_cv, 0.2f, 0.8f);
    }

    @Override
    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && !this.getSleeping()) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.2f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getHeadAngleX(float p_70890_1_) {
        if (this.func_184207_aI()) {
            return 0.0f;
        }
        if (this.eatTimer > 4 && this.eatTimer <= 156) {
            float f = ((float)(this.eatTimer - 4) - p_70890_1_) / 80.0f;
            return 0.62831855f + 0.0439823f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.eatTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public ResourceLocation getResourceLocationBlink() {
        return this.resourceLocationBlink;
    }

    @Override
    public void func_70636_d() {
        if (this.getColorNumber() > 5) {
            this.setColorNumber(0);
        }
        GenericBehavior.livingUpdateMateable(this, EntityMareBase.class);
        super.func_70636_d();
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_70631_g_() && this.func_110257_ck()) {
            if (player.func_70093_af()) {
                this.func_110199_f(player);
                return true;
            }
            return super.func_184645_a(player, hand);
        }
        if (!player.func_70093_af() && stack != null && this.func_110257_ck() && !this.getSleeping() && !this.func_184207_aI() && this.getWatered() && this.getFed()) {
            this.func_110237_h(player);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public EntityStallionBase createChild(EntityAgeable p_90011_1_) {
        return null;
    }

    @Override
    public DataParameter<Boolean> getSterilizedParam() {
        return STERILIZED;
    }

    @Override
    public void sterilize() {
        Iterator it = this.field_70714_bg.field_75782_a.iterator();
        while (it.hasNext()) {
            EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)it.next();
            EntityAIBase ai = entry.field_75733_a;
            if (!(ai instanceof GenericAIMate)) continue;
            entry.field_188524_c = false;
            ai.func_75251_c();
            it.remove();
        }
        this.setSterilized(true);
    }

    @Override
    public DataParameter<Optional<UUID>> getMateUniqueIdParam() {
        return MATE_UNIQUE_ID;
    }
}

