/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.chickens;

import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.api.interfaces.IAnimaniaAnimalBase;
import com.animania.common.ModSoundEvents;
import com.animania.common.blocks.BlockSeeds;
import com.animania.common.entities.chickens.ChickenType;
import com.animania.common.entities.chickens.EntityChickBase;
import com.animania.common.entities.chickens.ai.EntityAIWatchClosestFromSide;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAILookIdle;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISleep;
import com.animania.common.entities.generic.ai.GenericAISwimmingSmallCreatures;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWanderAvoidWater;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityAnimaniaChicken
extends EntityChicken
implements IAnimaniaAnimalBase {
    public static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemArray(AnimaniaConfig.careAndFeeding.chickenFood));
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnimaniaChicken.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaChicken.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityAnimaniaChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> INTERACTED = EntityDataManager.func_187226_a(EntityAnimaniaChicken.class, (DataSerializer)DataSerializers.field_187198_h);
    public boolean field_152118_bv;
    protected ResourceLocation resourceLocation;
    protected ResourceLocation resourceLocationBlink;
    public float field_70883_f;
    public float field_70884_g;
    public float field_70888_h;
    public float field_70889_i = 1.0f;
    private int fedTimer;
    protected int wateredTimer;
    protected int happyTimer;
    public int blinkTimer;
    private int featherTimer;
    protected int damageTimer;
    public ChickenType type;
    public EntityGender gender;
    public int lidCol;

    public EntityAnimaniaChicken(World worldIn) {
        super(worldIn);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new GenericAISwimmingSmallCreatures((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, new GenericAIPanic<EntityAnimaniaChicken>(this, 1.4));
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, new GenericAIFindWater<EntityAnimaniaChicken>(this, 1.0, null, EntityAnimaniaChicken.class, true));
            this.field_70714_bg.func_75776_a(3, new GenericAIFindFood<EntityAnimaniaChicken>(this, 1.0, null, true));
        }
        this.field_70714_bg.func_75776_a(4, new GenericAITempt<EntityAnimaniaChicken>(this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosestFromSide((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, new GenericAILookIdle<EntityAnimaniaChicken>(this));
        if (AnimaniaConfig.gameRules.animalsSleep) {
            this.field_70714_bg.func_75776_a(8, new GenericAISleep<EntityAnimaniaChicken>(this, 0.8, AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.chickenBed), AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.chickenBed2), EntityAnimaniaChicken.class));
        }
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 80 + this.field_70146_Z.nextInt(80);
        this.featherTimer = AnimaniaConfig.careAndFeeding.featherTimer + this.field_70146_Z.nextInt(1000);
        this.func_110163_bv();
    }

    protected void func_184651_r() {
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    public boolean isAIEnabled() {
        return true;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return GenericBehavior.interactCommon(this, player, hand, null) ? true : super.func_184645_a(player, hand);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public ResourceLocation getResourceLocationBlink() {
        return this.resourceLocationBlink;
    }

    protected ResourceLocation func_184647_J() {
        return this instanceof EntityChickBase ? null : (this.type.isPrime ? new ResourceLocation("animania", "chicken_prime") : new ResourceLocation("animania", "chicken_regular"));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(INTERACTED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsChickenJockey", this.field_152118_bv);
        GenericBehavior.writeCommonNBT(nbttagcompound, this);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.field_152118_bv = nbttagcompound.func_74767_n("IsChickenJockey");
        GenericBehavior.readCommonNBT(nbttagcompound, this);
    }

    @Override
    public DataParameter<Integer> getAgeParam() {
        return AGE;
    }

    public void func_70636_d() {
        super.func_70636_d();
        GenericBehavior.livingUpdateCommon(this);
        this.field_70888_h = this.field_70886_e;
        this.field_70884_g = this.field_70883_f;
        this.field_70883_f = (float)((double)this.field_70883_f + (double)(this.field_70122_E || this.func_184218_aH() ? -1 : 4) * 0.3);
        this.field_70883_f = MathHelper.func_76131_a((float)this.field_70883_f, (float)0.0f, (float)1.0f);
        this.field_70143_R = 0.0f;
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && AnimaniaConfig.gameRules.chickensDropFeathers && !this.func_152116_bZ() && --this.featherTimer <= 0) {
            this.func_184185_a(ModSoundEvents.chickenCluck2, 0.5f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_145779_a(Items.field_151008_G, 1);
            this.featherTimer = AnimaniaConfig.careAndFeeding.featherTimer + this.field_70146_Z.nextInt(1000);
        }
        if (!this.field_70122_E && !this.func_184218_aH() && this.field_70889_i < 1.0f) {
            this.field_70889_i = 1.0f;
        }
        this.field_70889_i = (float)((double)this.field_70889_i * 0.9);
        if (!this.field_70122_E && !this.func_184218_aH() && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.field_70886_e += this.field_70889_i * 2.0f;
    }

    @Override
    public DataParameter<Boolean> getFedParam() {
        return FED;
    }

    @Override
    public DataParameter<Boolean> getWateredParam() {
        return WATERED;
    }

    @Override
    public DataParameter<Boolean> getSleepingParam() {
        return SLEEPING;
    }

    @Override
    public DataParameter<Boolean> getHandFedParam() {
        return HANDFED;
    }

    protected void fall(float p_70069_1_) {
    }

    protected SoundEvent func_184639_G() {
        return GenericBehavior.getAmbientSound(this, ModSoundEvents.chickenCluck1, ModSoundEvents.chickenCluck2, ModSoundEvents.chickenCluck3, ModSoundEvents.chickenCluck4, ModSoundEvents.chickenCluck5, ModSoundEvents.chickenCluck6);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.1f, 1.4f);
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (!this.func_174814_R() && !this.getSleeping()) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundIn, this.func_184176_by(), volume, pitch);
        }
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    protected int func_70693_a(EntityPlayer player) {
        return this.func_152116_bZ() ? 10 : super.func_70693_a(player);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f2 = 0.1f;
        float f3 = 0.0f;
        passenger.func_70107_b(this.field_70165_t + (double)(0.1f * f), this.field_70163_u + (double)(this.field_70131_O * 0.5f) + passenger.func_70033_W() + 0.0, this.field_70161_v - (double)(0.1f * f1));
        if (passenger instanceof EntityLivingBase) {
            ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    public boolean func_152116_bZ() {
        return this.field_152118_bv;
    }

    public void func_152117_i(boolean jockey) {
        this.field_152118_bv = jockey;
    }

    public EntityChicken func_90011_a(EntityAgeable ageable) {
        return null;
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.type, this.gender));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    @Override
    public EntityGender getEntityGender() {
        return this.gender;
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }

    @Override
    public void setBlinkTimer(int i) {
        this.blinkTimer = i;
    }

    @Override
    public Set<Item> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public Class[] getFoodBlocks() {
        return new Class[]{BlockSeeds.class};
    }

    @Override
    public Float getSleepTimer() {
        return Float.valueOf(-100.0f);
    }

    @Override
    public void setSleepTimer(Float timer) {
    }

    @Override
    public int getEatTimer() {
        return 0;
    }

    @Override
    public void setEatTimer(int i) {
    }

    @Override
    public int getFedTimer() {
        return this.fedTimer;
    }

    @Override
    public void setFedTimer(int i) {
        this.fedTimer = i;
    }

    @Override
    public DataParameter<Boolean> getInteractedParam() {
        return INTERACTED;
    }

    @Override
    public int getWaterTimer() {
        return this.wateredTimer;
    }

    @Override
    public void setWaterTimer(int i) {
        this.wateredTimer = i;
    }

    @Override
    public int getDamageTimer() {
        return this.damageTimer;
    }

    @Override
    public void setDamageTimer(int i) {
        this.damageTimer = i;
    }

    @Override
    public int getHappyTimer() {
        return this.happyTimer;
    }

    @Override
    public void setHappyTimer(int i) {
        this.happyTimer = i;
    }

    @Override
    public AnimaniaType getAnimalType() {
        return this.type;
    }

    @Override
    public DataParameter<Float> getSleepTimerParam() {
        return null;
    }
}

