/*
 * Decompiled with CFR 0.152.
 */
package com.animania.client.render.horses;

import com.animania.client.models.ModelDraftHorseStallion;
import com.animania.client.render.layer.LayerBlinking;
import com.animania.common.entities.horses.HorseDraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderStallionDraftHorse<T extends HorseDraft.EntityStallionDraftHorse>
extends RenderLiving<T> {
    public static final Factory FACTORY = new Factory();
    private static final String modid = "animania";
    private static final String horseBaseDir = "textures/entity/horses/";
    private static final ResourceLocation[] HORSE_TEXTURES = new ResourceLocation[]{new ResourceLocation("animania", "textures/entity/horses/draft_horse_black.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_bw1.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_bw2.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_grey.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_red.png"), new ResourceLocation("animania", "textures/entity/horses/draft_horse_white.png")};
    private static ResourceLocation BLINK = new ResourceLocation("animania:textures/entity/horses/horse_blink.png");
    private static final int[] BLINK_COLORS = new int[]{0x1B1B1B, 0x181818, 0x171717, 0x797979, 9385236, 0xC1C1C1};
    private LayerBlinking blinkingLayer = new LayerBlinking(this, BLINK, 0);

    public RenderStallionDraftHorse(RenderManager rm) {
        super(rm, (ModelBase)new ModelDraftHorseStallion(), 0.8f);
        this.func_177094_a(this.blinkingLayer);
    }

    protected void preRenderScale(HorseDraft.EntityStallionDraftHorse entity, float f) {
        GL11.glScalef((float)0.85f, (float)0.85f, (float)0.85f);
        HorseDraft.EntityStallionDraftHorse entityHorse = entity;
        if (entityHorse.getSleeping()) {
            this.field_76989_e = 0.0f;
            float sleepTimer = entityHorse.getSleepTimer().floatValue();
            if (sleepTimer > -0.55f) {
                sleepTimer -= 0.01f;
            }
            entity.setSleepTimer(Float.valueOf(sleepTimer));
            GlStateManager.func_179109_b((float)-0.25f, (float)(entity.field_70131_O - 1.95f - sleepTimer), (float)-0.25f);
            GlStateManager.func_179114_b((float)6.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            this.field_76989_e = 0.8f;
            entityHorse.setSleeping(false);
            entityHorse.setSleepTimer(Float.valueOf(0.0f));
        }
    }

    protected ResourceLocation getEntityTexture(HorseDraft.EntityStallionDraftHorse entity) {
        if (entity.field_70165_t == -1.0 && entity.field_70163_u == -1.0 && entity.field_70161_v == -1.0) {
            return HORSE_TEXTURES[0];
        }
        return HORSE_TEXTURES[entity.getColorNumber()];
    }

    protected void preRenderCallback(HorseDraft.EntityStallionDraftHorse entityliving, float f) {
        this.preRenderScale(entityliving, f);
        this.blinkingLayer.setColors(BLINK_COLORS[entityliving.getColorNumber()], BLINK_COLORS[entityliving.getColorNumber()]);
    }

    static class Factory<T extends HorseDraft.EntityStallionDraftHorse>
    implements IRenderFactory<T> {
        Factory() {
        }

        public Render<? super T> createRenderFor(RenderManager manager) {
            return new RenderStallionDraftHorse(manager);
        }
    }
}

