/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.util;

import its_meow.betteranimalsplus.client.model.ModelBearHead;
import its_meow.betteranimalsplus.client.model.ModelBoarHead;
import its_meow.betteranimalsplus.client.model.ModelCoyoteHead;
import its_meow.betteranimalsplus.client.model.ModelDeerHead;
import its_meow.betteranimalsplus.client.model.ModelFeralWolfHead;
import its_meow.betteranimalsplus.client.model.ModelFoxHead;
import its_meow.betteranimalsplus.client.model.ModelHirschgeistSkull;
import its_meow.betteranimalsplus.client.model.ModelMooseHead;
import its_meow.betteranimalsplus.client.model.ModelReindeerHead;
import its_meow.betteranimalsplus.common.block.BlockGenericSkull;
import its_meow.betteranimalsplus.common.item.ItemBlockHeadType;
import its_meow.betteranimalsplus.common.tileentity.TileEntityHead;
import its_meow.betteranimalsplus.init.ModTextures;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public enum HeadTypes {
    WOLFHEAD("wolfhead", true, 6, () -> () -> ModelFeralWolfHead.class, type -> new TileEntityHead((HeadTypes)((Object)type), 0.0f, ModTextures.wolf_black, ModTextures.wolf_snowy, ModTextures.wolf_timber, ModTextures.wolf_arctic, ModTextures.wolf_brown, ModTextures.wolf_red)),
    COYOTEHEAD("coyotehead", true, 1, () -> () -> ModelCoyoteHead.class, type -> new TileEntityHead((HeadTypes)((Object)type), 0.0f, ModTextures.coyote_hostile)),
    FOXHEAD("foxhead", true, 4, () -> () -> ModelFoxHead.class, type -> new TileEntityHead((HeadTypes)((Object)type), -0.1f, ModTextures.fox_1, ModTextures.fox_2, ModTextures.fox_3, ModTextures.fox_4)),
    BOARHEAD("boarhead", false, 4, () -> () -> ModelBoarHead.class, type -> new TileEntityHead((HeadTypes)((Object)type), 0.0f, ModTextures.boar_1, ModTextures.boar_2, ModTextures.boar_3, ModTextures.boar_4)),
    BEARHEAD("bearhead", false, 3, () -> () -> ModelBearHead.class, type -> new TileEntityHead((HeadTypes)((Object)type), 0.0f, ModTextures.bear_brown, ModTextures.bear_black, ModTextures.bear_kermode)),
    DEERHEAD("deerhead", false, 4, () -> () -> ModelDeerHead.class, type -> new TileEntityHead((HeadTypes)((Object)type), 0.0f, typeNum -> {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            switch (typeNum) {
                case 1: {
                    return ModTextures.deer_1_christmas;
                }
                case 2: {
                    return ModTextures.deer_2_christmas;
                }
                case 3: {
                    return ModTextures.deer_3_christmas;
                }
                case 4: {
                    return ModTextures.deer_4_christmas;
                }
            }
            return ModTextures.deer_1_christmas;
        }
        switch (typeNum) {
            case 1: {
                return ModTextures.deer_1;
            }
            case 2: {
                return ModTextures.deer_2;
            }
            case 3: {
                return ModTextures.deer_3;
            }
            case 4: {
                return ModTextures.deer_4;
            }
        }
        return ModTextures.deer_1;
    }, new ResourceLocation[0])),
    REINDEERHEAD("reindeerhead", false, 4, () -> () -> ModelReindeerHead.class, type -> new TileEntityHead((HeadTypes)((Object)type), 0.0f, typeNum -> {
        if (typeNum <= 4) {
            return null;
        }
        switch (typeNum) {
            case 5: {
                return ModTextures.reindeer_1_christmas;
            }
            case 6: {
                return ModTextures.reindeer_2_christmas;
            }
            case 7: {
                return ModTextures.reindeer_3_christmas;
            }
            case 8: {
                return ModTextures.reindeer_4_christmas;
            }
        }
        return ModTextures.reindeer_1;
    }, ModTextures.reindeer_1, ModTextures.reindeer_2, ModTextures.reindeer_3, ModTextures.reindeer_4)),
    MOOSEHEAD("moosehead", false, 4, () -> () -> ModelMooseHead.class, type -> new TileEntityHead((HeadTypes)((Object)type), -1.35f, ModTextures.moose_1, ModTextures.moose_2, ModTextures.moose_3, ModTextures.moose_4)),
    HIRSCHGEIST("hirschgeistskull", true, 1, () -> () -> ModelHirschgeistSkull.class, type -> new TileEntityHead((HeadTypes)((Object)type), -0.2f, ModTextures.hirschgeist));

    public final String name;
    public final boolean allowFloor;
    public final int textureCount;
    public final Function<HeadTypes, TileEntityHead> teFactory;
    private final Supplier<Supplier<Class<? extends ModelBase>>> modelSupplier;
    private HashMap<Integer, Pair<BlockGenericSkull, ItemBlockHeadType>> heads = new HashMap();
    private ArrayList<ItemBlockHeadType> items = new ArrayList();
    private ArrayList<BlockGenericSkull> blocks = new ArrayList();

    private HeadTypes(String name, boolean allowFloor, int texCount, Supplier<Supplier<Class<? extends ModelBase>>> modelSupplier, Function<HeadTypes, TileEntityHead> teFactory) {
        this.name = name;
        this.allowFloor = allowFloor;
        this.teFactory = teFactory;
        this.textureCount = texCount;
        this.modelSupplier = modelSupplier;
        for (int i = 1; i <= texCount; ++i) {
            BlockGenericSkull block = new BlockGenericSkull(this, i);
            this.blocks.add(block);
            ItemBlockHeadType item = new ItemBlockHeadType((Block)block, this, i);
            this.heads.put(i, (Pair<BlockGenericSkull, ItemBlockHeadType>)Pair.of((Object)((Object)block), (Object)((Object)item)));
            this.items.add(item);
        }
    }

    public Pair<BlockGenericSkull, ItemBlockHeadType> getPair(int i) {
        return this.heads.get(i);
    }

    public BlockGenericSkull getBlock(int i) {
        if (this.getPair(i) == null) {
            return null;
        }
        return (BlockGenericSkull)((Object)this.getPair(i).getLeft());
    }

    public ItemBlockHeadType getItem(int i) {
        if (this.getPair(i) == null) {
            return null;
        }
        return (ItemBlockHeadType)((Object)this.getPair(i).getRight());
    }

    public ArrayList<ItemBlockHeadType> getItems() {
        return this.items;
    }

    public ArrayList<BlockGenericSkull> getBlocks() {
        return this.blocks;
    }

    public Supplier<Supplier<Class<? extends ModelBase>>> getModelSupplier() {
        return this.modelSupplier;
    }
}

