/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.util;

import com.cleanroommc.multiblocked.util.Vector3;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class ShapeUtils {
    public static AxisAlignedBB rotate(AxisAlignedBB AxisAlignedBB2, EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                return ShapeUtils.rotate(AxisAlignedBB2, new Vector3(0.0, 1.0, 0.0), 180.0);
            }
            case EAST: {
                return ShapeUtils.rotate(AxisAlignedBB2, new Vector3(0.0, 1.0, 0.0), -90.0);
            }
            case WEST: {
                return ShapeUtils.rotate(AxisAlignedBB2, new Vector3(0.0, 1.0, 0.0), 90.0);
            }
            case UP: {
                return ShapeUtils.rotate(AxisAlignedBB2, new Vector3(1.0, 0.0, 0.0), 90.0);
            }
            case DOWN: {
                return ShapeUtils.rotate(AxisAlignedBB2, new Vector3(1.0, 0.0, 0.0), -90.0);
            }
        }
        return AxisAlignedBB2;
    }

    public static AxisAlignedBB rotate(AxisAlignedBB AxisAlignedBB2, Vector3 axis, double degree) {
        Vector3 min = new Vector3(AxisAlignedBB2.field_72340_a, AxisAlignedBB2.field_72338_b, AxisAlignedBB2.field_72339_c).subtract(0.5);
        Vector3 max = new Vector3(AxisAlignedBB2.field_72336_d, AxisAlignedBB2.field_72337_e, AxisAlignedBB2.field_72334_f).subtract(0.5);
        double radians = Math.toRadians(degree);
        min.rotate(radians, axis);
        max.rotate(radians, axis);
        min.add(0.5);
        max.add(0.5);
        return new AxisAlignedBB(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public static List<AxisAlignedBB> rotate(List<AxisAlignedBB> shape, EnumFacing facing) {
        return shape.stream().map(AxisAlignedBB2 -> ShapeUtils.rotate(AxisAlignedBB2, facing)).collect(Collectors.toList());
    }

    public static List<AxisAlignedBB> rotate(List<AxisAlignedBB> shape, Vector3 axis, double degree) {
        return shape.stream().map(AxisAlignedBB2 -> ShapeUtils.rotate(AxisAlignedBB2, axis, degree)).collect(Collectors.toList());
    }
}

