/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class ResourceUtils {
    private static final Map<String, ResourceLocation> cachedResources = new HashMap<String, ResourceLocation>();
    public static final String RESOURCE_PREFIX = "multiblocked:";

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static ResourceLocation getResource(String rs) {
        if (!cachedResources.containsKey(rs)) {
            cachedResources.put(rs, new ResourceLocation(RESOURCE_PREFIX + rs));
        }
        return cachedResources.get(rs);
    }

    public static ResourceLocation getResourceRAW(String rs) {
        if (!cachedResources.containsKey(rs)) {
            cachedResources.put(rs, new ResourceLocation(rs));
        }
        return cachedResources.get(rs);
    }

    public static void bindTexture(String rs) {
        ResourceUtils.bindTexture(ResourceUtils.getResource(rs));
    }

    public static boolean isResourceExist(String rs) {
        if (!cachedResources.containsKey(rs)) {
            InputStream inputstream = ResourceUtils.class.getResourceAsStream(String.format("/assets/%s/%s", "multiblocked", rs));
            if (inputstream == null) {
                return false;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
            cachedResources.put(rs, new ResourceLocation("multiblocked", rs));
        }
        return true;
    }

    public static boolean isTextureExist(ResourceLocation textureResource) {
        InputStream inputstream = ResourceUtils.class.getResourceAsStream(String.format("/assets/%s/textures/%s.png", textureResource.func_110624_b(), textureResource.func_110623_a()));
        if (inputstream == null) {
            return false;
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return true;
    }

    public static ITextureObject getTextureObject(ResourceLocation location) {
        if (location == null) {
            return null;
        }
        TextureManager renderEngine = Minecraft.func_71410_x().func_175598_ae().field_78724_e;
        ITextureObject texture = renderEngine.func_110581_b(location);
        if (texture == null) {
            texture = new SimpleTexture(location);
            renderEngine.func_110579_a(location, texture);
        }
        return texture;
    }
}

