/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.persistence;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.pattern.MultiblockState;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.persistence.IAsyncThreadUpdate;
import com.cleanroommc.multiblocked.util.world.DummyWorld;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiblockWorldSavedData
extends WorldSavedData {
    private static final MultiblockWorldSavedData DUMMY = new MultiblockWorldSavedData("dummy"){

        @Override
        public void addMapping(MultiblockState state) {
        }

        @Override
        public void addLoading(ComponentTileEntity<?> tileEntity) {
        }

        @Override
        public void createSearchingThread() {
        }
    };
    @SideOnly(value=Side.CLIENT)
    public static Set<BlockPos> modelDisabled;
    @SideOnly(value=Side.CLIENT)
    public static Map<BlockPos, Collection<BlockPos>> multiDisabled;
    public static final ThreadLocal<Boolean> isBuildingChunk;
    private static WeakReference<World> worldRef;
    public final Map<BlockPos, MultiblockState> mapping;
    public final Map<ChunkPos, Set<MultiblockState>> chunkPosMapping;
    public final Map<BlockPos, ComponentTileEntity<?>> loading;
    private final CopyOnWriteArrayList<IAsyncThreadUpdate> asyncComponents = new CopyOnWriteArrayList();
    private Thread thread;
    private long periodID = Multiblocked.RNG.nextLong();
    private float tps = 4.0f;

    public static MultiblockWorldSavedData getOrCreate(World world) {
        if (world == null || world instanceof DummyWorld) {
            return DUMMY;
        }
        MapStorage perWorldStorage = world.getPerWorldStorage();
        String name = MultiblockWorldSavedData.getName(world);
        worldRef = new WeakReference<World>(world);
        MultiblockWorldSavedData mbwsd = (MultiblockWorldSavedData)perWorldStorage.func_75742_a(MultiblockWorldSavedData.class, name);
        worldRef = null;
        if (mbwsd == null) {
            mbwsd = new MultiblockWorldSavedData(name);
            perWorldStorage.func_75745_a(name, (WorldSavedData)mbwsd);
        }
        return mbwsd;
    }

    private static String getName(World world) {
        return "Multiblocked" + world.field_73011_w.func_186058_p().func_186067_c();
    }

    public MultiblockWorldSavedData(String name) {
        super(name);
        this.mapping = new Object2ObjectOpenHashMap();
        this.chunkPosMapping = new HashMap<ChunkPos, Set<MultiblockState>>();
        this.loading = new Object2ObjectOpenHashMap();
    }

    public static void clearDisabled() {
        modelDisabled.clear();
        multiDisabled.clear();
    }

    public Collection<MultiblockState> getControllerInChunk(ChunkPos chunkPos) {
        return new ArrayList<MultiblockState>(this.chunkPosMapping.getOrDefault(chunkPos, Collections.emptySet()));
    }

    public Collection<ComponentTileEntity<?>> getLoadings() {
        return this.loading.values();
    }

    public void addMapping(MultiblockState state) {
        this.mapping.put(state.controllerPos, state);
        for (BlockPos blockPos : state.getCache()) {
            this.chunkPosMapping.computeIfAbsent(new ChunkPos(blockPos), c -> new HashSet()).add(state);
        }
        this.func_76186_a(true);
    }

    public void removeMapping(MultiblockState state) {
        this.mapping.remove(state.controllerPos);
        for (Set<MultiblockState> set : this.chunkPosMapping.values()) {
            set.remove(state);
        }
        this.func_76186_a(true);
    }

    public void addLoading(ComponentTileEntity<?> tileEntity) {
        ComponentTileEntity<?> last = this.loading.put(tileEntity.func_174877_v(), tileEntity);
        if (last != tileEntity) {
            if (last instanceof IAsyncThreadUpdate) {
                this.asyncComponents.remove(last);
                if (this.asyncComponents.isEmpty()) {
                    this.releaseSearchingThread();
                }
            }
            if (tileEntity instanceof IAsyncThreadUpdate) {
                this.asyncComponents.add((IAsyncThreadUpdate)((Object)tileEntity));
                this.createSearchingThread();
            }
        }
    }

    public void removeLoading(BlockPos componentPos) {
        ComponentTileEntity<?> component = this.loading.remove(componentPos);
        if (component instanceof IAsyncThreadUpdate) {
            this.asyncComponents.remove(component);
            if (this.asyncComponents.isEmpty()) {
                this.releaseSearchingThread();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void removeDisableModel(BlockPos controllerPos) {
        Collection<BlockPos> poses = multiDisabled.remove(controllerPos);
        if (poses == null) {
            return;
        }
        modelDisabled.clear();
        multiDisabled.values().forEach(modelDisabled::addAll);
        MultiblockWorldSavedData.updateRenderChunk(poses);
    }

    @SideOnly(value=Side.CLIENT)
    private static void updateRenderChunk(Collection<BlockPos> poses) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            for (BlockPos pos : poses) {
                world.func_147458_c(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addDisableModel(BlockPos controllerPos, Collection<BlockPos> poses) {
        multiDisabled.put(controllerPos, poses);
        modelDisabled.addAll(poses);
        MultiblockWorldSavedData.updateRenderChunk(poses);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isModelDisabled(BlockPos pos) {
        if (isBuildingChunk.get().booleanValue()) {
            return modelDisabled.contains(pos);
        }
        return false;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        for (String key : nbt.func_150296_c()) {
            BlockPos pos = BlockPos.func_177969_a((long)Long.parseLong(key));
            MultiblockState state = new MultiblockState((World)worldRef.get(), pos);
            state.deserialize(new PacketBuffer(Unpooled.copiedBuffer((byte[])nbt.func_74770_j(key))));
            this.mapping.put(pos, state);
            for (BlockPos blockPos : state.getCache()) {
                this.chunkPosMapping.computeIfAbsent(new ChunkPos(blockPos), c -> new HashSet()).add(state);
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound compound) {
        this.mapping.forEach((pos, state) -> {
            ByteBuf byteBuf = Unpooled.buffer();
            state.serialize(new PacketBuffer(byteBuf));
            compound.func_74773_a(String.valueOf(pos.func_177986_g()), Arrays.copyOfRange(byteBuf.array(), 0, byteBuf.writerIndex()));
        });
        return compound;
    }

    public void createSearchingThread() {
        if (this.thread != null && !this.thread.isInterrupted()) {
            return;
        }
        this.thread = new Thread(this::searchingTask);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void searchingTask() {
        long tpsST = System.currentTimeMillis();
        while (!Thread.interrupted()) {
            long dur;
            long st = System.currentTimeMillis();
            try {
                for (IAsyncThreadUpdate asyncComponent : this.asyncComponents) {
                    asyncComponent.asyncThreadLogic(this.periodID);
                }
            }
            catch (Throwable e) {
                Multiblocked.LOGGER.error("asyncThreadLogic error: {}", (Object)e.getMessage());
            }
            ++this.periodID;
            long et = System.currentTimeMillis();
            if (this.periodID % 20L == 0L) {
                this.tps = Math.min((float)(et - tpsST) / 1250.0f, 4.0f);
                tpsST = et;
            }
            if ((dur = et - st) >= 250L) continue;
            try {
                Thread.sleep(Math.min(250L, 250L - dur));
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void releaseSearchingThread() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    public long getPeriodID() {
        return this.periodID;
    }

    public float getTPS() {
        return this.tps;
    }

    static {
        isBuildingChunk = ThreadLocal.withInitial(() -> Boolean.FALSE);
        if (Multiblocked.isClient()) {
            modelDisabled = new HashSet<BlockPos>();
            multiDisabled = new HashMap<BlockPos, Collection<BlockPos>>();
        }
    }
}

