/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.network;

import com.cleanroommc.multiblocked.network.IPacket;
import com.cleanroommc.multiblocked.network.c2s.CPacketUIClientAction;
import com.cleanroommc.multiblocked.network.s2c.SPacketCommand;
import com.cleanroommc.multiblocked.network.s2c.SPacketRemoveDisabledRendering;
import com.cleanroommc.multiblocked.network.s2c.SPacketUIOpen;
import com.cleanroommc.multiblocked.network.s2c.SPacketUIWidgetUpdate;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class MultiblockedNetworking {
    private static final SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel("multiblocked");
    private static int AUTO_ID = 0;
    static final IMessageHandler<IPacket, IPacket> S2CHandler = (message, ctx) -> {
        NetHandlerPlayClient handler = ctx.getClientHandler();
        IThreadListener threadListener = FMLCommonHandler.instance().getWorldThread((INetHandler)handler);
        if (threadListener.func_152345_ab()) {
            return message.executeClient(handler);
        }
        threadListener.func_152344_a(() -> message.executeClient(handler));
        return null;
    };
    static final IMessageHandler<IPacket, IPacket> C2SHandler = (message, ctx) -> {
        NetHandlerPlayServer handler = ctx.getServerHandler();
        IThreadListener threadListener = FMLCommonHandler.instance().getWorldThread((INetHandler)handler);
        if (threadListener.func_152345_ab()) {
            return message.executeServer(handler);
        }
        threadListener.func_152344_a(() -> message.executeServer(handler));
        return null;
    };

    public static void init() {
        MultiblockedNetworking.registerS2C(SPacketUIOpen.class);
        MultiblockedNetworking.registerS2C(SPacketUIWidgetUpdate.class);
        MultiblockedNetworking.registerS2C(SPacketRemoveDisabledRendering.class);
        MultiblockedNetworking.registerS2C(SPacketCommand.class);
        MultiblockedNetworking.registerC2S(CPacketUIClientAction.class);
    }

    private static void registerC2S(Class<? extends IPacket> clazz) {
        network.registerMessage(C2SHandler, clazz, AUTO_ID++, Side.SERVER);
    }

    private static void registerS2C(Class<? extends IPacket> clazz) {
        network.registerMessage(S2CHandler, clazz, AUTO_ID++, Side.CLIENT);
    }

    public static void sendToServer(IPacket packet) {
        network.sendToServer((IMessage)packet);
    }

    public static void sendToWorld(IPacket packet, World world) {
        network.sendToDimension((IMessage)packet, world.field_73011_w.getDimension());
    }

    public static void sendToPlayer(IPacket packet, EntityPlayerMP player) {
        network.sendTo((IMessage)packet, player);
    }
}

