/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.jei.recipeppage;

import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.gui.ingredient.IIngredientSlot;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.RecipeWidget;
import com.cleanroommc.multiblocked.api.recipe.Content;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.jei.IJeiIngredientAdapter;
import com.cleanroommc.multiblocked.jei.JeiPlugin;
import com.cleanroommc.multiblocked.jei.ModularWrapper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.input.MouseHelper;
import net.minecraft.client.Minecraft;

public class RecipeWrapper
extends ModularWrapper {
    public final Recipe recipe;
    public final RecipeWidget widget;

    public RecipeWrapper(RecipeWidget widget) {
        super(widget, widget.getSize().width, widget.getSize().height);
        this.widget = widget;
        this.recipe = widget.recipe;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        BiConsumer<MultiblockCapability, ImmutableList> inputConsumer = (capability, contents) -> {
            IJeiIngredientAdapter adapter = capability.jeiIngredientAdapter;
            if (adapter != null) {
                List jeiIngredients = contents.stream().map(Content::getContent).map(adapter.getInternalIngredientType()::cast).flatMap(adapter).collect(Collectors.toList());
                ingredients.setInputs(adapter.getJeiIngredientType(), jeiIngredients);
            }
        };
        BiConsumer<MultiblockCapability, ImmutableList> outputConsumer = (capability, contents) -> {
            IJeiIngredientAdapter adapter = capability.jeiIngredientAdapter;
            if (adapter != null) {
                List jeiIngredients = contents.stream().map(Content::getContent).map(adapter.getInternalIngredientType()::cast).flatMap(adapter).collect(Collectors.toList());
                ingredients.setOutputs(adapter.getJeiIngredientType(), jeiIngredients);
            }
        };
        this.recipe.inputs.forEach(inputConsumer);
        this.recipe.tickInputs.forEach(inputConsumer);
        this.recipe.outputs.forEach(outputConsumer);
        this.recipe.tickOutputs.forEach(outputConsumer);
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        Object ingredient;
        IFocus.Mode mode;
        mouseX = MouseHelper.getX();
        mouseY = MouseHelper.getY();
        if (mouseButton == 0) {
            mode = IFocus.Mode.OUTPUT;
        } else if (mouseButton == 1) {
            mode = IFocus.Mode.INPUT;
        } else {
            return false;
        }
        IIngredientSlot clicked = this.findClickedSlot(this.widget.inputs, mouseX, mouseY);
        if (clicked == null) {
            clicked = this.findClickedSlot(this.widget.outputs, mouseX, mouseY);
        }
        if (clicked != null && (ingredient = clicked.getIngredientOverMouse(mouseX, mouseY)) != null) {
            IJeiRuntime jeiRuntime = JeiPlugin.getJeiRuntime();
            jeiRuntime.getRecipesGui().show(jeiRuntime.getRecipeRegistry().createFocus(mode, ingredient));
            return true;
        }
        return false;
    }

    private IIngredientSlot findClickedSlot(DraggableScrollableWidgetGroup group, int mouseX, int mouseY) {
        for (Widget w : group.widgets) {
            if (!(w instanceof IIngredientSlot) || !w.isMouseOverElement(mouseX, mouseY)) continue;
            return (IIngredientSlot)((Object)w);
        }
        return null;
    }
}

