/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.jei.multipage;

import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.gui.texture.ItemStackTexture;
import com.cleanroommc.multiblocked.api.tile.BlueprintTableTileEntity;
import com.cleanroommc.multiblocked.jei.multipage.MultiblockInfoWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.client.resources.I18n;

public class MultiblockInfoCategory
implements IRecipeCategory<MultiblockInfoWrapper> {
    private static final String UID = "multiblocked:multiblock_info";
    private final IDrawable background;
    private final IDrawable icon;
    public static final List<ControllerDefinition> REGISTER = new ArrayList<ControllerDefinition>();

    public MultiblockInfoCategory(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.background = guiHelper.createBlankDrawable(176, 220);
        this.icon = guiHelper.createDrawableIngredient((Object)BlueprintTableTileEntity.tableDefinition.getStackForm());
    }

    public static void registerMultiblock(ControllerDefinition controllerDefinition) {
        REGISTER.add(controllerDefinition);
    }

    public static void registerRecipes(IModRegistry registry) {
        registry.addRecipes((Collection)REGISTER.stream().map(MultiblockInfoWrapper::new).collect(Collectors.toList()), UID);
        for (ControllerDefinition definition : REGISTER) {
            if (definition.getRecipeMap() == null) continue;
            if (definition.getRecipeMap().categoryTexture == null) {
                definition.getRecipeMap().categoryTexture = new ItemStackTexture(definition.getStackForm());
            }
            registry.addRecipeCatalyst((Object)definition.getStackForm(), new String[]{"multiblocked:" + definition.getRecipeMap().name});
        }
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"multiblocked.jei.multiblock_info", (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "multiblocked";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, MultiblockInfoWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        recipeWrapper.setRecipeLayout((RecipeLayout)recipeLayout);
    }
}

