/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.jei.ingredient;

import com.buuz135.thaumicjei.ThaumcraftJEIPlugin;
import com.cleanroommc.multiblocked.jei.ingredient.AbstractIngredient;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IIngredientType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class AspectListIngredient
extends AbstractIngredient<AspectList> {
    public static IIngredientType<AspectList> INSTANCE = Loader.isModLoaded((String)"thaumicjei") ? ThaumcraftJEIPlugin.ASPECT_LIST : new AspectListIngredient();

    private AspectListIngredient() {
    }

    @Override
    public void registerIngredients(IModIngredientRegistration registry) {
        registry.register(INSTANCE, this.getAllIngredients(), (IIngredientHelper)this, (IIngredientRenderer)this);
    }

    @Override
    public Collection<AspectList> getAllIngredients() {
        ArrayList<AspectList> aspects = new ArrayList<AspectList>();
        aspects.addAll(Aspect.getPrimalAspects().stream().map(aspect -> new AspectList().add(aspect, 1)).collect(Collectors.toList()));
        aspects.addAll(Aspect.getCompoundAspects().stream().map(aspect -> new AspectList().add(aspect, 1)).collect(Collectors.toList()));
        return aspects;
    }

    @Nonnull
    public Class<? extends AspectList> getIngredientClass() {
        return AspectList.class;
    }

    @Nonnull
    public List<AspectList> expandSubtypes(@Nonnull List<AspectList> ingredients) {
        return ingredients;
    }

    @Nullable
    public AspectList getMatch(@Nonnull Iterable<AspectList> ingredients, @Nonnull AspectList ingredientToMatch) {
        for (AspectList list : ingredients) {
            if (!list.getAspects()[0].getName().equalsIgnoreCase(ingredientToMatch.getAspects()[0].getName())) continue;
            return list;
        }
        return null;
    }

    @Nonnull
    public String getDisplayName(@Nonnull AspectList ingredient) {
        return ingredient.getAspects()[0].getName();
    }

    @Nonnull
    public String getUniqueId(@Nonnull AspectList ingredient) {
        return ingredient.getAspects()[0].getName();
    }

    @Nonnull
    public String getWildcardId(@Nonnull AspectList ingredient) {
        return this.getUniqueId(ingredient);
    }

    @Nonnull
    public String getModId(@Nonnull AspectList ingredient) {
        return "thaumcraft";
    }

    @Nonnull
    public Iterable<Color> getColors(@Nonnull AspectList ingredient) {
        return Collections.singletonList(new Color(ingredient.getAspects()[0].getColor()));
    }

    @Nonnull
    public String getResourceId(@Nonnull AspectList ingredient) {
        return ingredient.getAspects()[0].getName();
    }

    @Nonnull
    public AspectList copyIngredient(@Nonnull AspectList ingredient) {
        return ingredient.copy();
    }

    @Nonnull
    public String getErrorInfo(AspectList ingredient) {
        return "";
    }

    public void render(@Nonnull Minecraft minecraft, int xPosition, int yPosition, @Nullable AspectList ingredient) {
        if (ingredient != null && ingredient.size() > 0) {
            GlStateManager.func_179094_E();
            minecraft.field_71446_o.func_110577_a(ingredient.getAspects()[0].getImage());
            GlStateManager.func_179147_l();
            Color c = new Color(ingredient.getAspects()[0].getColor());
            GL11.glColor4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
            Gui.func_146110_a((int)xPosition, (int)yPosition, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            int amount = ingredient.getAmount(ingredient.getAspects()[0]);
            if (amount > 1) {
                minecraft.field_71466_p.func_175063_a(TextFormatting.WHITE + "" + amount, (float)((xPosition + 16) * 2), (float)((yPosition + 12) * 2), 0);
            }
            GlStateManager.func_179121_F();
        }
    }

    @Nonnull
    public List<String> getTooltip(@Nonnull Minecraft minecraft, @Nonnull AspectList ingredient, @Nonnull ITooltipFlag tooltipFlag) {
        return ingredient.size() > 0 ? Arrays.asList(TextFormatting.AQUA + ingredient.getAspects()[0].getName(), TextFormatting.GRAY + ingredient.getAspects()[0].getLocalizedDescription()) : Collections.emptyList();
    }
}

