/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.jei;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUIGuiHandler;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.FuelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ProgressWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.RecipeWidget;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeMap;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.jei.MultiblockInfoRecipeFocusShower;
import com.cleanroommc.multiblocked.jei.ingredient.AspectListIngredient;
import com.cleanroommc.multiblocked.jei.multipage.MultiblockInfoCategory;
import com.cleanroommc.multiblocked.jei.recipeppage.FuelWrapper;
import com.cleanroommc.multiblocked.jei.recipeppage.RecipeMapCategory;
import com.cleanroommc.multiblocked.jei.recipeppage.RecipeMapFuelCategory;
import com.cleanroommc.multiblocked.jei.recipeppage.RecipeWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.Internal;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.InputHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@JEIPlugin
public class JeiPlugin
implements IModPlugin {
    public static Field fieldRecipeWrapper;
    public static Field fieldRecipeLayouts;
    private static IIngredientRegistry itemRegistry;
    private static IJeiRuntime jeiRuntime;

    public static IRecipeWrapper getWrapper(RecipeLayout layout) {
        try {
            return (IRecipeWrapper)fieldRecipeWrapper.get(layout);
        }
        catch (IllegalAccessException e) {
            Multiblocked.LOGGER.error((Object)e);
            return null;
        }
    }

    public static List<RecipeLayout> getRecipeLayouts(RecipesGui recipesGui) {
        try {
            return (List)fieldRecipeLayouts.get(recipesGui);
        }
        catch (IllegalAccessException e) {
            Multiblocked.LOGGER.error((Object)e);
            return null;
        }
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        JeiPlugin.jeiRuntime = jeiRuntime;
        ArrayList<ItemStack> removed = new ArrayList<ItemStack>();
        for (ComponentDefinition definition : MbdComponents.DEFINITION_REGISTRY.values()) {
            if (definition.properties.showInJei) continue;
            removed.add(definition.getStackForm());
        }
        itemRegistry.removeIngredientsAtRuntime(VanillaTypes.ITEM, removed);
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registry) {
        Multiblocked.LOGGER.info("JEI register categories");
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new MultiblockInfoCategory(jeiHelpers)});
        for (RecipeMap recipeMap : RecipeMap.RECIPE_MAP_REGISTRY.values()) {
            if (recipeMap == RecipeMap.EMPTY) continue;
            registry.addRecipeCategories(new IRecipeCategory[]{new RecipeMapCategory(jeiHelpers, recipeMap)});
            registry.addRecipeCategories(new IRecipeCategory[]{new RecipeMapFuelCategory(jeiHelpers, recipeMap)});
        }
    }

    public void register(@Nonnull IModRegistry registry) {
        Multiblocked.LOGGER.info("JEI register");
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        ModularUIGuiHandler modularUIGuiHandler = new ModularUIGuiHandler(jeiHelpers.recipeTransferHandlerHelper());
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{modularUIGuiHandler});
        registry.addGhostIngredientHandler(modularUIGuiHandler.getGuiContainerClass(), (IGhostIngredientHandler)modularUIGuiHandler);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)modularUIGuiHandler, "universal recipe transfer handler");
        for (RecipeMap recipeMap : RecipeMap.RECIPE_MAP_REGISTRY.values()) {
            registry.addRecipes((Collection)recipeMap.recipes.values().stream().map(recipe -> new RecipeWidget(recipeMap, (Recipe)recipe, ProgressWidget.JEIProgress, ProgressWidget.JEIProgress)).map(RecipeWrapper::new).collect(Collectors.toList()), "multiblocked:" + recipeMap.name);
            if (!recipeMap.isFuelRecipeMap()) continue;
            registry.addRecipes((Collection)recipeMap.fuelRecipes.stream().map(recipe -> new FuelWidget(recipeMap, (Recipe)recipe)).map(FuelWrapper::new).collect(Collectors.toList()), "multiblocked:" + recipeMap.name + ".fuel");
        }
        MultiblockInfoCategory.registerRecipes(registry);
        itemRegistry = registry.getIngredientRegistry();
    }

    public void registerIngredients(@Nonnull IModIngredientRegistration registry) {
        Multiblocked.LOGGER.info("JEI register ingredients");
        if (Loader.isModLoaded((String)"thaumcraft") && !Loader.isModLoaded((String)"thaumicjei")) {
            ((AspectListIngredient)AspectListIngredient.INSTANCE).registerIngredients(registry);
        }
    }

    public static void setupInputHandler() {
        try {
            Field inputHandlerField = Internal.class.getDeclaredField("inputHandler");
            inputHandlerField.setAccessible(true);
            InputHandler inputHandler = (InputHandler)inputHandlerField.get(null);
            List showsRecipeFocuses = (List)ObfuscationReflectionHelper.getPrivateValue(InputHandler.class, (Object)inputHandler, (String)"showsRecipeFocuses");
            showsRecipeFocuses.add(0, new MultiblockInfoRecipeFocusShower());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IJeiRuntime getJeiRuntime() {
        return jeiRuntime != null ? jeiRuntime : (jeiRuntime = Internal.getRuntime());
    }

    static {
        try {
            fieldRecipeWrapper = RecipeLayout.class.getDeclaredField("recipeWrapper");
            fieldRecipeWrapper.setAccessible(true);
            fieldRecipeLayouts = RecipesGui.class.getDeclaredField("recipeLayouts");
            fieldRecipeLayouts.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            Multiblocked.LOGGER.error((Object)e);
        }
    }
}

