/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.integration.provider;

import com.cleanroommc.multiblocked.api.recipe.RecipeLogic;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class RecipeProgressInfoProvider
implements IProbeInfoProvider {
    public String getID() {
        return String.format("%s:recipe_progress_provider", "multiblocked");
    }

    public void addProbeInfo(@Nonnull ProbeMode probeMode, @Nonnull IProbeInfo probeInfo, @Nonnull EntityPlayer entityPlayer, @Nonnull World world, @Nonnull IBlockState blockState, @Nonnull IProbeHitData probeHitData) {
        int maxProgress;
        RecipeLogic recipeLogic;
        TileEntity tileEntity;
        if (blockState.func_177230_c().hasTileEntity(blockState) && (tileEntity = world.func_175625_s(probeHitData.getPos())) instanceof ControllerTileEntity && (recipeLogic = ((ControllerTileEntity)tileEntity).getRecipeLogic()) != null && (maxProgress = recipeLogic.duration) > 0) {
            String text;
            int currentProgress = recipeLogic.progress;
            if (maxProgress < 20) {
                text = String.format(" t / %s t", maxProgress);
            } else {
                currentProgress = Math.round((float)currentProgress / 20.0f);
                maxProgress = Math.round((float)maxProgress / 20.0f);
                text = String.format(" s / %s s", maxProgress);
            }
            IProbeInfo horizontalPane = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            horizontalPane.text(TextStyleClass.INFO + "{*multiblocked.top.recipe_progress*} ");
            horizontalPane.progress(currentProgress, maxProgress, probeInfo.defaultProgressStyle().suffix(text).filledColor(-11748585).alternateFilledColor(-11748585));
        }
    }
}

