/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.core.asm;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.capability.trait.InterfaceUser;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.api.tile.part.PartTileEntity;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class DynamicTileEntityGenerator
implements Opcodes {
    private static final String DYNAMIC_COMPONENT_TILE_CLASS_NAME = "com/cleanroommc/multiblocked/api/tile/IDynamicComponentTile";
    private static final String TRAIT_SETTERS_SIGNATURE_FORMAT = "Ljava/util/Map<Ljava/lang/String;Ljava/util/function/BiConsumer<L%s;Lcom/cleanroommc/multiblocked/api/capability/trait/CapabilityTrait;>;>;";
    private final String superClassName;
    private final List<CapabilityTrait> traits;
    private final List<Class<?>> interfaces = new ArrayList();
    private final String name;

    public DynamicTileEntityGenerator(String name, List<CapabilityTrait> traits, Class<? extends ComponentTileEntity<?>> superClass) {
        this.name = name;
        this.traits = traits;
        this.superClassName = Type.getInternalName(superClass);
        for (CapabilityTrait trait : traits) {
            Class<?> clazz = trait.getClass().getAnnotation(InterfaceUser.class).value();
            if (!clazz.isInterface()) {
                throw new IllegalArgumentException("The value of InterfaceUser annotation must be an interface!");
            }
            this.interfaces.add(clazz);
        }
    }

    public Class<?> generateClass() {
        ClassWriter classWriter = new ClassWriter(3);
        ArrayList interfaceNames = Lists.newArrayList((Object[])new String[]{DYNAMIC_COMPONENT_TILE_CLASS_NAME});
        StringBuilder signature = new StringBuilder("L").append(this.superClassName).append(";");
        String className = "com/cleanroommc/multiblocked/api/tile/part/dynamic/" + this.name;
        signature.append("L").append(DYNAMIC_COMPONENT_TILE_CLASS_NAME).append("<L").append(className).append(";>;");
        for (Class<?> anInterface : this.interfaces) {
            interfaceNames.add(Type.getInternalName(anInterface));
            signature.append(Type.getDescriptor(anInterface));
        }
        classWriter.visit(52, 33, className, signature.toString(), this.superClassName, interfaceNames.toArray(new String[0]));
        classWriter.visitSource(this.name + ".dynamic", null);
        classWriter.visitInnerClass("com/google/common/collect/ImmutableMap$Builder", "com/google/common/collect/ImmutableMap", "Builder", 9);
        classWriter.visitInnerClass("java/lang/invoke/MethodHandles$Lookup", "java/lang/invoke/MethodHandles", "Lookup", 25);
        this.constructor(classWriter, className);
        this.fields(classWriter, className);
        int startLine = 17;
        for (int i = 0; i < this.interfaces.size(); ++i) {
            startLine = this.methods(classWriter, this.interfaces.get(i), className, startLine, i);
        }
        this.classInitializer(classWriter, className);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "getTraitSetters", "()Ljava/util/Map;", "()" + String.format(TRAIT_SETTERS_SIGNATURE_FORMAT, className), null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLineNumber(startLine + 5, label0);
        methodVisitor.visitFieldInsn(178, className, "TRAIT_SETTERS", "Ljava/util/Map;");
        methodVisitor.visitInsn(176);
        Label label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", "L" + className + ";", null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        byte[] bytecode = classWriter.toByteArray();
        CustomClassLoader.INSTANCE.bytecodes.put(className.replace("/", "."), bytecode);
        try {
            return CustomClassLoader.INSTANCE.findClass(className.replace("/", "."));
        }
        catch (ClassNotFoundException e) {
            Multiblocked.LOGGER.error("Failed to generate TE class for part {}", (Object)this.name, (Object)e);
            return PartTileEntity.PartSimpleTileEntity.class;
        }
    }

    private void constructor(ClassWriter classWriter, String className) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLineNumber(13, label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, this.superClassName, "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        Label label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", "L" + className + ";", null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
    }

    private void fields(ClassWriter classWriter, String className) {
        FieldVisitor fieldVisitor = classWriter.visitField(26, "TRAIT_SETTERS", "Ljava/util/Map;", String.format(TRAIT_SETTERS_SIGNATURE_FORMAT, className), null);
        fieldVisitor.visitEnd();
        for (CapabilityTrait trait : this.traits) {
            Class<?> anInterface = trait.getClass().getAnnotation(InterfaceUser.class).value();
            fieldVisitor = classWriter.visitField(1, "trait_" + anInterface.getSimpleName(), Type.getDescriptor(anInterface), null, null);
            fieldVisitor.visitEnd();
        }
    }

    private int methods(ClassWriter classWriter, Class<?> anInterface, String className, int startLine, int index) {
        MethodVisitor methodVisitor;
        String fieldName = "trait_" + anInterface.getSimpleName();
        String fieldSignature = Type.getDescriptor(anInterface);
        for (Method method : anInterface.getMethods()) {
            if (!Modifier.isAbstract(method.getModifiers()) && !method.isDefault()) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            ArrayList<String> exceptions = new ArrayList<String>();
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                exceptions.add(Type.getInternalName(exceptionType));
            }
            methodVisitor = classWriter.visitMethod(1, method.getName(), Type.getMethodDescriptor((Method)method), null, exceptions.toArray(new String[0]));
            methodVisitor.visitCode();
            Label label0 = new Label();
            methodVisitor.visitLabel(label0);
            methodVisitor.visitLineNumber(startLine, label0);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, className, fieldName, fieldSignature);
            int varIndex = 1;
            for (Class<?> parameterType : parameterTypes) {
                if (parameterType == Long.TYPE) {
                    methodVisitor.visitVarInsn(22, varIndex);
                    ++varIndex;
                } else if (parameterType == Float.TYPE) {
                    methodVisitor.visitVarInsn(23, varIndex);
                } else if (parameterType == Double.TYPE) {
                    methodVisitor.visitVarInsn(24, varIndex);
                    ++varIndex;
                } else if (parameterType.isPrimitive()) {
                    methodVisitor.visitVarInsn(21, varIndex);
                } else {
                    methodVisitor.visitVarInsn(25, varIndex);
                }
                ++varIndex;
            }
            methodVisitor.visitMethodInsn(185, Type.getInternalName(anInterface), method.getName(), Type.getMethodDescriptor((Method)method), true);
            int returnCode = 176;
            if (returnType == Long.TYPE) {
                returnCode = 173;
            } else if (returnType == Float.TYPE) {
                returnCode = 174;
            } else if (returnType == Double.TYPE) {
                returnCode = 175;
            } else if (returnType == Void.TYPE) {
                returnCode = 177;
            } else if (returnType.isPrimitive()) {
                returnCode = 172;
            }
            if (returnCode == 177) {
                Label label1 = new Label();
                methodVisitor.visitLineNumber(++startLine, label1);
            }
            methodVisitor.visitInsn(returnCode);
            Label endLabel = new Label();
            methodVisitor.visitLabel(endLabel);
            methodVisitor.visitLocalVariable("this", "L" + className + ";", null, label0, endLabel, 0);
            varIndex = 1;
            int parameterTypesLength = parameterTypes.length;
            for (int i = 0; i < parameterTypesLength; ++i) {
                Class<?> parameterType = parameterTypes[i];
                methodVisitor.visitLocalVariable("param" + i, Type.getDescriptor(parameterType), null, label0, endLabel, varIndex);
                if (parameterType == Double.TYPE || parameterType == Long.TYPE) {
                    ++varIndex;
                }
                ++varIndex;
            }
            methodVisitor.visitMaxs(-1, -1);
            methodVisitor.visitEnd();
            startLine += 4;
        }
        methodVisitor = classWriter.visitMethod(4106, "lambda$static$" + index, "(L" + className + ";Lcom/cleanroommc/multiblocked/api/capability/trait/CapabilityTrait;)V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(anInterface));
        methodVisitor.visitFieldInsn(181, className, "trait_" + anInterface.getSimpleName(), Type.getDescriptor(anInterface));
        methodVisitor.visitInsn(177);
        Label label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("te", "L" + className + ";", null, label0, label1, 0);
        methodVisitor.visitLocalVariable("trait", "Lcom/cleanroommc/multiblocked/api/capability/trait/CapabilityTrait;", null, label0, label1, 1);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        return startLine;
    }

    public void classInitializer(ClassWriter classWriter, String className) {
        MethodVisitor methodVisitor = classWriter.visitMethod(8, "<clinit>", "()V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitMethodInsn(184, "com/google/common/collect/ImmutableMap", "builder", "()Lcom/google/common/collect/ImmutableMap$Builder;", false);
        for (int i = 0; i < this.interfaces.size(); ++i) {
            Class<?> anInterface = this.interfaces.get(i);
            methodVisitor.visitLdcInsn((Object)anInterface.getSimpleName());
            methodVisitor.visitInvokeDynamicInsn("accept", "()Ljava/util/function/BiConsumer;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), new Object[]{Type.getType((String)"(Ljava/lang/Object;Ljava/lang/Object;)V"), new Handle(6, className, "lambda$static$" + i, "(L" + className + ";Lcom/cleanroommc/multiblocked/api/capability/trait/CapabilityTrait;)V", false), Type.getType((String)("(L" + className + ";Lcom/cleanroommc/multiblocked/api/capability/trait/CapabilityTrait;)V"))});
            methodVisitor.visitMethodInsn(182, "com/google/common/collect/ImmutableMap$Builder", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/google/common/collect/ImmutableMap$Builder;", false);
        }
        methodVisitor.visitMethodInsn(182, "com/google/common/collect/ImmutableMap$Builder", "build", "()Lcom/google/common/collect/ImmutableMap;", false);
        methodVisitor.visitFieldInsn(179, className, "TRAIT_SETTERS", "Ljava/util/Map;");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 0);
        methodVisitor.visitEnd();
    }

    public static class CustomClassLoader
    extends ClassLoader {
        public static final CustomClassLoader INSTANCE = new CustomClassLoader(Multiblocked.class.getClassLoader());
        private final Map<String, byte[]> bytecodes = new HashMap<String, byte[]>();
        private final Map<String, Class<?>> classes = new HashMap();

        public CustomClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (this.classes.containsKey(name)) {
                return this.classes.get(name);
            }
            if (this.bytecodes.containsKey(name)) {
                byte[] bytecode = this.bytecodes.get(name);
                this.classes.put(name, this.defineClass(name, bytecode, 0, bytecode.length));
                return this.classes.get(name);
            }
            return super.findClass(name);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.classes.containsKey(name)) {
                return this.classes.get(name);
            }
            if (this.bytecodes.containsKey(name)) {
                byte[] bytecode = this.bytecodes.get(name);
                this.classes.put(name, this.defineClass(name, bytecode, 0, bytecode.length));
                return this.classes.get(name);
            }
            return super.loadClass(name);
        }
    }
}

