/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.recipe.conditions;

import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeCondition;
import com.cleanroommc.multiblocked.api.recipe.RecipeLogic;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ThunderCondition
extends RecipeCondition {
    public static final ThunderCondition INSTANCE = new ThunderCondition();
    private float level;

    private ThunderCondition() {
    }

    public ThunderCondition(float level) {
        this.level = level;
    }

    @Override
    public String getType() {
        return "thunder";
    }

    @Override
    public ITextComponent getTooltips() {
        return new TextComponentTranslation("multiblocked.recipe.condition.thunder.tooltip", new Object[]{Float.valueOf(this.level)});
    }

    @Override
    public boolean test(@Nonnull Recipe recipe, @Nonnull RecipeLogic recipeLogic) {
        World level = recipeLogic.controller.func_145831_w();
        return level.func_72819_i(1.0f) >= this.level;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new ThunderCondition();
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("level", (Number)Float.valueOf(this.level));
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.level = JsonUtils.func_151221_a((JsonObject)config, (String)"level", (float)0.0f);
        return this;
    }

    @Override
    public void openConfigurator(WidgetGroup group) {
        super.openConfigurator(group);
        group.addWidget(new TextFieldWidget(0, 20, 60, 15, true, null, s -> {
            this.level = Float.parseFloat(s);
        }).setCurrentString(this.level + "").setNumbersOnly(0.0f, 1.0f).setHoverTooltip("multiblocked.gui.condition.thunder.level"));
    }
}

