/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.recipe.conditions;

import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeCondition;
import com.cleanroommc.multiblocked.api.recipe.RecipeLogic;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class PositionYCondition
extends RecipeCondition {
    public static final PositionYCondition INSTANCE = new PositionYCondition();
    private int min;
    private int max;

    private PositionYCondition() {
    }

    public PositionYCondition(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public String getType() {
        return "pos_y";
    }

    @Override
    public ITextComponent getTooltips() {
        return new TextComponentTranslation("multiblocked.recipe.condition.pos_y.tooltip", new Object[]{this.min, this.max});
    }

    @Override
    public boolean test(@Nonnull Recipe recipe, @Nonnull RecipeLogic recipeLogic) {
        int y = recipeLogic.controller.func_174877_v().func_177956_o();
        return y >= this.min && y <= this.max;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new PositionYCondition();
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("min", (Number)this.min);
        config.addProperty("max", (Number)this.max);
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.min = JsonUtils.func_151208_a((JsonObject)config, (String)"min", (int)Integer.MIN_VALUE);
        this.max = JsonUtils.func_151208_a((JsonObject)config, (String)"max", (int)Integer.MAX_VALUE);
        return this;
    }

    @Override
    public void openConfigurator(WidgetGroup group) {
        super.openConfigurator(group);
        group.addWidget(new TextFieldWidget(0, 20, 60, 15, true, null, s -> {
            this.min = Integer.parseInt(s);
        }).setCurrentString(this.min + "").setNumbersOnly(Integer.MIN_VALUE, Integer.MAX_VALUE).setHoverTooltip("multiblocked.gui.condition.pos_y.min"));
        group.addWidget(new TextFieldWidget(0, 40, 60, 15, true, null, s -> {
            this.max = Integer.parseInt(s);
        }).setCurrentString(this.max + "").setNumbersOnly(Integer.MIN_VALUE, Integer.MAX_VALUE).setHoverTooltip("multiblocked.gui.condition.pos_y.max"));
    }
}

