/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.recipe.conditions;

import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SearchComponentWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectorWidget;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeCondition;
import com.cleanroommc.multiblocked.api.recipe.RecipeLogic;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DimensionCondition
extends RecipeCondition {
    public static final DimensionCondition INSTANCE = new DimensionCondition();
    private String dimension = "dummy";

    private DimensionCondition() {
    }

    public DimensionCondition(String dimension) {
        this.dimension = dimension;
    }

    @Override
    public String getType() {
        return "dimension";
    }

    @Override
    public boolean isOr() {
        return true;
    }

    @Override
    public ITextComponent getTooltips() {
        return new TextComponentTranslation("multiblocked.recipe.condition.dimension.tooltip", new Object[]{this.dimension});
    }

    @Override
    public boolean test(@Nonnull Recipe recipe, @Nonnull RecipeLogic recipeLogic) {
        World level = recipeLogic.controller.func_145831_w();
        return this.dimension.equals(level.field_73011_w.func_186058_p().func_186065_b());
    }

    @Override
    public RecipeCondition createTemplate() {
        return new DimensionCondition();
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("dim", this.dimension);
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.dimension = JsonUtils.func_151219_a((JsonObject)config, (String)"dim", (String)"dummy");
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void openConfigurator(WidgetGroup group) {
        super.openConfigurator(group);
        final Set types = Arrays.stream(DimensionType.values()).map(DimensionType::func_186065_b).collect(Collectors.toSet());
        final SelectorWidget selectorWidget = new SelectorWidget(0, 20, 80, 15, new ArrayList<String>(types), -1);
        SearchComponentWidget<String> searchComponentWidget = new SearchComponentWidget<String>(0, 40, 80, 15, new SearchComponentWidget.IWidgetSearch<String>(){

            @Override
            public void search(String word, Consumer<String> find) {
                for (String type : types) {
                    if (!type.toLowerCase().contains(word.toLowerCase())) continue;
                    find.accept(type);
                }
            }

            @Override
            public String resultDisplay(String value) {
                return value;
            }

            @Override
            public void selectResult(String value) {
                if (value != null) {
                    DimensionCondition.this.dimension = value;
                    selectorWidget.setValue(value);
                }
            }
        });
        group.addWidget(selectorWidget.setButtonBackground(new ColorRectTexture(2133732910)).setOnChanged(dim -> {
            if (dim != null && !dim.isEmpty()) {
                this.dimension = dim;
                searchComponentWidget.setCurrentString((String)dim);
            }
        }).setIsUp(true).setValue(types.contains(this.dimension) ? this.dimension : ""));
        group.addWidget(searchComponentWidget.setCapacity(2).setCurrentString(types.contains(this.dimension) ? this.dimension : ""));
    }
}

