/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.recipe.conditions;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.BlockSelectorWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeCondition;
import com.cleanroommc.multiblocked.api.recipe.RecipeLogic;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class BlockCondition
extends RecipeCondition {
    public static final BlockCondition INSTANCE = new BlockCondition();
    public IBlockState blockState = Blocks.field_150350_a.func_176223_P();
    public int count = 0;

    private BlockCondition() {
    }

    public BlockCondition(IBlockState blockState, int count) {
        this.blockState = blockState;
        this.count = count;
    }

    @Override
    public String getType() {
        return "block";
    }

    @Override
    public ITextComponent getTooltips() {
        return new TextComponentTranslation(this.blockState.func_177230_c().func_149739_a(), new Object[0]).func_150258_a(" (" + this.count + ")");
    }

    @Override
    public boolean test(@Nonnull Recipe recipe, @Nonnull RecipeLogic recipeLogic) {
        int amount = 0;
        for (BlockPos pos : recipeLogic.controller.state.getCache()) {
            if (recipeLogic.controller.func_145831_w().func_180495_p(pos) != this.blockState || ++amount < this.count) continue;
            break;
        }
        return amount >= this.count;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new BlockCondition();
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject jsonObject = super.serialize();
        jsonObject.add("block", Multiblocked.GSON.toJsonTree((Object)this.blockState));
        jsonObject.addProperty("count", (Number)this.count);
        return jsonObject;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.blockState = (IBlockState)Multiblocked.GSON.fromJson(config.get("block"), IBlockState.class);
        this.count = config.get("count").getAsInt();
        return this;
    }

    @Override
    public void openConfigurator(WidgetGroup group) {
        super.openConfigurator(group);
        group.addWidget(new BlockSelectorWidget(0, 20, true).setOnBlockStateUpdate(state -> {
            this.blockState = state;
        }).setBlock(this.blockState));
        group.addWidget(new TextFieldWidget(0, 45, 60, 15, true, null, s -> {
            this.count = Integer.parseInt(s);
        }).setCurrentString(this.count + "").setNumbersOnly(Integer.MIN_VALUE, Integer.MAX_VALUE).setHoverTooltip("multiblocked.gui.condition.block.count"));
    }
}

