/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.recipe.conditions;

import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SearchComponentWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectorWidget;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeCondition;
import com.cleanroommc.multiblocked.api.recipe.RecipeLogic;
import com.google.gson.JsonObject;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeCondition
extends RecipeCondition {
    public static final BiomeCondition INSTANCE = new BiomeCondition();
    private ResourceLocation biome = new ResourceLocation("dummy");

    private BiomeCondition() {
    }

    public BiomeCondition(ResourceLocation biome) {
        this.biome = biome;
    }

    @Override
    public String getType() {
        return "biome";
    }

    @Override
    public boolean isOr() {
        return true;
    }

    @Override
    public ITextComponent getTooltips() {
        return new TextComponentTranslation(String.format("biome.%s.%s", this.biome.func_110624_b(), this.biome.func_110623_a()), new Object[0]);
    }

    @Override
    public boolean test(@Nonnull Recipe recipe, @Nonnull RecipeLogic recipeLogic) {
        World level = recipeLogic.controller.func_145831_w();
        Biome biome = level.func_180494_b(recipeLogic.controller.func_174877_v());
        return biome.delegate.name().equals((Object)this.biome);
    }

    @Override
    public RecipeCondition createTemplate() {
        return new BiomeCondition();
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("biome", this.biome.toString());
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.biome = new ResourceLocation(JsonUtils.func_151219_a((JsonObject)config, (String)"biome", (String)"dummy"));
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void openConfigurator(WidgetGroup group) {
        super.openConfigurator(group);
        final Set types = ForgeRegistries.BIOMES.getKeys();
        final SelectorWidget selectorWidget = new SelectorWidget(0, 20, 80, 15, types.stream().map(ResourceLocation::toString).collect(Collectors.toList()), -1);
        SearchComponentWidget<ResourceLocation> searchComponentWidget = new SearchComponentWidget<ResourceLocation>(0, 40, 80, 15, new SearchComponentWidget.IWidgetSearch<ResourceLocation>(){

            @Override
            public void search(String word, Consumer<ResourceLocation> find) {
                for (ResourceLocation type : types) {
                    if (!type.toString().toLowerCase().contains(word.toLowerCase())) continue;
                    find.accept(type);
                }
            }

            @Override
            public String resultDisplay(ResourceLocation value) {
                return value.toString();
            }

            @Override
            public void selectResult(ResourceLocation value) {
                if (value != null) {
                    BiomeCondition.this.biome = value;
                    selectorWidget.setValue(value.toString());
                }
            }
        });
        group.addWidget(selectorWidget.setButtonBackground(new ColorRectTexture(2133732910)).setOnChanged(dim -> {
            if (dim != null && !dim.isEmpty()) {
                this.biome = new ResourceLocation(dim);
                searchComponentWidget.setCurrentString((String)dim);
            }
        }).setIsUp(true).setValue(types.contains(this.biome) ? this.biome.toString() : ""));
        group.addWidget(searchComponentWidget.setCapacity(2).setCurrentString(types.contains(this.biome) ? this.biome.toString() : ""));
    }
}

