/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.widget;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.util.TextFormattingUtil;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import lach_01298.qmd.particle.Particle;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.util.Units;
import nc.util.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class ParticleStackWidget
extends ContentWidget<ParticleStack> {
    @Override
    protected void onContentUpdate() {
        if (Multiblocked.isClient() && this.content != null) {
            String tips = Lang.localise((String)((ParticleStack)this.content).getParticle().getUnlocalizedName()) + '\n' + TextFormatting.YELLOW + Lang.localise((String)"gui.qmd.particlestack.amount", (Object[])new Object[]{Units.getSIFormat((double)((ParticleStack)this.content).getAmount(), (String)"pu")}) + '\n' + TextFormatting.DARK_GREEN + Lang.localise((String)"gui.qmd.particlestack.mean_energy", (Object[])new Object[]{Units.getParticleEnergy((long)((ParticleStack)this.content).getMeanEnergy())}) + '\n' + TextFormatting.RED + Lang.localise((String)"gui.qmd.particlestack.focus", (Object[])new Object[]{Units.getSIFormat((double)((ParticleStack)this.content).getFocus(), (String)"")});
            this.setHoverTooltip(tips);
        }
    }

    @Override
    public ParticleStack getJEIContent(Object content) {
        if (content instanceof ParticleStack) {
            return new ParticleStack(((ParticleStack)content).getParticle(), ((ParticleStack)this.content).getAmount(), ((ParticleStack)this.content).getMeanEnergy(), ((ParticleStack)this.content).getFocus());
        }
        return null;
    }

    @Override
    public void drawHookBackground(int mouseX, int mouseY, float partialTicks) {
        if (this.content != null) {
            Position pos = this.getPosition();
            Size size = this.getSize();
            Particle particle = ((ParticleStack)this.content).getParticle();
            if (particle != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(((ParticleStack)this.content).getParticle().getTexture());
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179147_l();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferBuilder = tessellator.func_178180_c();
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferBuilder.func_181662_b((double)(pos.x + 2), (double)(pos.y + 18), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                bufferBuilder.func_181662_b((double)(pos.x + 18), (double)(pos.y + 18), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                bufferBuilder.func_181662_b((double)(pos.x + 18), (double)(pos.y + 2), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                bufferBuilder.func_181662_b((double)(pos.x + 2), (double)(pos.y + 2), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                tessellator.func_78381_a();
                if (((ParticleStack)this.content).getAmount() > 1) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
                    String s = TextFormattingUtil.formatLongToCompactString(((ParticleStack)this.content).getAmount(), 4);
                    FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                    fontRenderer.func_175063_a(s, ((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.func_78256_a(s) + 21.0f, ((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f, 0xFFFFFF);
                    GlStateManager.func_179121_F();
                }
            }
        }
    }

    @Override
    public void openConfigurator(WidgetGroup dialog) {
        super.openConfigurator(dialog);
        int x = 65;
        int y = 25;
        dialog.addWidget(new LabelWidget(5, y + 3, "multiblocked.gui.label.amount"));
        dialog.addWidget(new TextFieldWidget(x, y, 60, 15, true, null, number -> {
            this.content = new ParticleStack(((ParticleStack)this.content).getParticle(), Integer.parseInt(number), ((ParticleStack)this.content).getMeanEnergy(), ((ParticleStack)this.content).getFocus());
            this.onContentUpdate();
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(((ParticleStack)this.content).getAmount() + ""));
        dialog.addWidget(new LabelWidget(5, y + 21, "multiblocked.gui.label.energy"));
        dialog.addWidget(new TextFieldWidget(x, y + 18, 60, 15, true, null, number -> {
            this.content = new ParticleStack(((ParticleStack)this.content).getParticle(), ((ParticleStack)this.content).getAmount(), Long.parseLong(number), ((ParticleStack)this.content).getFocus());
            this.onContentUpdate();
        }).setNumbersOnly(0L, Long.MAX_VALUE).setCurrentString(((ParticleStack)this.content).getMeanEnergy() + ""));
        dialog.addWidget(new LabelWidget(5, y + 39, "multiblocked.gui.label.focus"));
        dialog.addWidget(new TextFieldWidget(x, y + 36, 60, 15, true, null, number -> {
            this.content = new ParticleStack(((ParticleStack)this.content).getParticle(), ((ParticleStack)this.content).getAmount(), ((ParticleStack)this.content).getMeanEnergy(), (double)Float.parseFloat(number));
            this.onContentUpdate();
        }).setNumbersOnly(1.0f, Float.MAX_VALUE).setCurrentString(((ParticleStack)this.content).getFocus() + ""));
    }
}

