/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.widget;

import com.cleanroommc.multiblocked.api.gui.texture.GuiTextureGroup;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.TextFormattingUtil;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class NumberContentWidget
extends ContentWidget<Number> {
    protected boolean isDecimal;
    protected IGuiTexture contentTexture;
    protected String unit;

    public NumberContentWidget setContentTexture(IGuiTexture contentTexture) {
        this.contentTexture = contentTexture;
        return this;
    }

    public NumberContentWidget setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public Object getJEIIngredient(Number content) {
        return null;
    }

    @Override
    protected void onContentUpdate() {
        this.isDecimal = this.content instanceof Float || this.content instanceof Double;
        this.setHoverTooltip(this.content + " " + this.unit);
    }

    @Override
    public void openConfigurator(WidgetGroup dialog) {
        super.openConfigurator(dialog);
        int x = 5;
        int y = 25;
        dialog.addWidget(new LabelWidget(5, y + 3, "multiblocked.gui.label.number"));
        TextFieldWidget textFieldWidget = new TextFieldWidget(65, y, 60, 15, true, null, number -> {
            if (this.content instanceof Float) {
                this.content = Float.valueOf(Float.parseFloat(number));
            } else if (this.content instanceof Double) {
                this.content = Double.parseDouble(number);
            } else if (this.content instanceof Integer) {
                this.content = Integer.parseInt(number);
            } else if (this.content instanceof Long) {
                this.content = Long.parseLong(number);
            }
            this.onContentUpdate();
        }).setCurrentString(((Number)this.content).toString());
        dialog.addWidget(textFieldWidget);
        if (this.isDecimal) {
            textFieldWidget.setNumbersOnly(0.0f, 2.1474836E9f);
        } else if (this.content instanceof Long) {
            textFieldWidget.setNumbersOnly(0L, Long.MAX_VALUE);
        } else {
            textFieldWidget.setNumbersOnly(0, Integer.MAX_VALUE);
        }
        dialog.addWidget(this.createButton(textFieldWidget, -10000, x, y + 66));
        dialog.addWidget(this.createButton(textFieldWidget, -100, x, y + 44));
        dialog.addWidget(this.createButton(textFieldWidget, -1, x, y + 22));
        dialog.addWidget(this.createButton(textFieldWidget, 1, x + 75, y + 22));
        dialog.addWidget(this.createButton(textFieldWidget, 100, x + 75, y + 44));
        dialog.addWidget(this.createButton(textFieldWidget, 10000, x + 75, y + 66));
    }

    private ButtonWidget createButton(TextFieldWidget textFieldWidget, int num, int x, int y) {
        return (ButtonWidget)new ButtonWidget(x, y, 45, 18, new GuiTextureGroup(ResourceBorderTexture.BUTTON_COMMON, new TextTexture((num >= 0 ? "+" : "") + num)), cd -> {
            String number = textFieldWidget.getCurrentString();
            Number newValue = null;
            int scale = num * (cd.isShiftClick ? 10 : 1);
            if (this.content instanceof Float) {
                if (Float.parseFloat(number) + (float)scale >= 0.0f) {
                    newValue = Float.valueOf(Float.parseFloat(number) + (float)scale);
                }
            } else if (this.content instanceof Double) {
                if (Double.parseDouble(number) + (double)scale >= 0.0) {
                    newValue = Double.parseDouble(number) + (double)scale;
                }
            } else if (this.content instanceof Integer) {
                if (Integer.parseInt(number) + scale >= 0) {
                    newValue = Integer.parseInt(number) + scale;
                }
            } else if (this.content instanceof Long && Long.parseLong(number) + (long)scale >= 0L) {
                newValue = Long.parseLong(number) + (long)scale;
            }
            if (newValue != null) {
                this.content = newValue;
                this.onContentUpdate();
                textFieldWidget.setCurrentString(((Object)newValue).toString());
            }
        }).setHoverBorderTexture(1, -1).setHoverTooltip(LocalizationUtils.format("multiblocked.gui.shift_click", new Object[0]) + ": " + (num >= 0 ? "+" : "") + num * 10);
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.contentTexture != null) {
            this.contentTexture.updateTick();
        }
    }

    @Override
    public void drawHookBackground(int mouseX, int mouseY, float partialTicks) {
        Position position = this.getPosition();
        Size size = this.getSize();
        if (this.contentTexture != null) {
            this.contentTexture.draw(mouseX, mouseY, position.x + 1, position.y + 1, size.width - 2, size.height - 2);
        }
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        GlStateManager.func_179097_i();
        String s = TextFormattingUtil.formatLongToCompactString(((Number)this.content).intValue(), 4);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_175063_a(s, ((float)position.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.func_78256_a(s) + 21.0f, ((float)position.y + (float)size.height / 3.0f + 6.0f) * 2.0f, 0xFFFFFF);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
    }
}

