/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.widget;

import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.util.ClickData;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.PhantomSlotWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SlotWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SwitchWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.recipe.ItemsIngredient;
import com.cleanroommc.multiblocked.util.CycleItemStackHandler;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class ItemsContentWidget
extends ContentWidget<ItemsIngredient> {
    protected CycleItemStackHandler itemHandler;
    protected boolean isDurability;

    public ItemsContentWidget(boolean isDurability) {
        this.isDurability = isDurability;
    }

    public ItemsContentWidget() {
        this(false);
    }

    @Override
    protected void onContentUpdate() {
        List<List<ItemStack>> stacks = Collections.singletonList(Arrays.stream(((ItemsIngredient)((Object)this.content)).func_193365_a()).map(stack -> {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(((ItemsIngredient)((Object)((Object)this.content))).getAmount());
            return copy;
        }).collect(Collectors.toList()));
        if (this.itemHandler != null) {
            this.itemHandler.updateStacks(stacks);
        } else {
            this.itemHandler = new CycleItemStackHandler(stacks);
            this.addWidget(new SlotWidget(this.itemHandler, 0, 1, 1, false, false).setDrawOverlay(false).setOnAddedTooltips((s, l) -> {
                if (this.chance < 1.0f) {
                    l.add(this.chance == 0.0f ? LocalizationUtils.format("multiblocked.gui.content.chance_0", new Object[0]) : LocalizationUtils.format("multiblocked.gui.content.chance_1", String.format("%.1f", Float.valueOf(this.chance * 100.0f)) + "%"));
                }
                if (this.perTick) {
                    l.add(LocalizationUtils.format("multiblocked.gui.content.per_tick", new Object[0]));
                }
                if (this.isDurability) {
                    l.add(LocalizationUtils.format("multiblocked.gui.content.durability", new Object[0]));
                }
            }));
        }
        if (this.isDurability) {
            this.addWidget(new ImageWidget(1, 5, 18, 9, new TextTexture("D", -43691)));
        }
    }

    @Override
    public ItemsIngredient getJEIContent(Object content) {
        if (content instanceof ItemStack) {
            return new ItemsIngredient(((ItemsIngredient)((Object)this.content)).getAmount(), (ItemStack)content);
        }
        return null;
    }

    @Override
    public Object getJEIIngredient(ItemsIngredient content) {
        return this.itemHandler.getStackInSlot(0);
    }

    @Override
    public void openConfigurator(WidgetGroup dialog) {
        super.openConfigurator(dialog);
        int x = 5;
        int y = 25;
        dialog.addWidget(new LabelWidget(5, y + 3, this.isDurability ? "multiblocked.gui.label.durability" : "multiblocked.gui.label.amount"));
        dialog.addWidget(new TextFieldWidget(65, y, 60, 15, true, null, number -> {
            this.content = ((ItemsIngredient)((Object)((Object)this.content))).isOre() ? new ItemsIngredient(Integer.parseInt(number), ((ItemsIngredient)((Object)((Object)this.content))).getOreDict()) : new ItemsIngredient(Integer.parseInt(number), ((ItemsIngredient)((Object)((Object)this.content))).field_193371_b);
            this.onContentUpdate();
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(((ItemsIngredient)((Object)this.content)).getAmount() + ""));
        WidgetGroup groupOre = new WidgetGroup(x, y + 40, 120, 80);
        WidgetGroup groupIngredient = new WidgetGroup(x, y + 20, 120, 80);
        DraggableScrollableWidgetGroup container = new DraggableScrollableWidgetGroup(0, 20, 120, 50).setBackground(new ColorRectTexture(-5592406));
        groupIngredient.addWidget(container);
        dialog.addWidget(groupIngredient);
        dialog.addWidget(groupOre);
        TextFieldWidget ore = new TextFieldWidget(30, 3, 90, 15, true, () -> ((ItemsIngredient)((Object)((Object)this.content))).isOre() ? ((ItemsIngredient)((Object)((Object)this.content))).getOreDict() : "", null);
        groupOre.addWidget(ore);
        ItemStackHandler handler = new ItemStackHandler(1);
        PhantomSlotWidget phantomSlotWidget = new PhantomSlotWidget((IItemHandlerModifiable)handler, 0, 0, 1).setClearSlotOnRightClick(false);
        groupOre.addWidget(phantomSlotWidget);
        phantomSlotWidget.setChangeListener(() -> this.lambda$openConfigurator$5((IItemHandlerModifiable)handler, ore, phantomSlotWidget)).setBackgroundTexture(new ColorRectTexture(-1354480572));
        ore.setTextResponder(arg_0 -> this.lambda$openConfigurator$6((IItemHandlerModifiable)handler, phantomSlotWidget, arg_0));
        ore.setHoverTooltip("multiblocked.gui.trait.item.ore_dic");
        dialog.addWidget(new SwitchWidget(x, y + 22, 50, 15, (arg_0, arg_1) -> this.lambda$openConfigurator$7(groupOre, ore, groupIngredient, (IItemHandlerModifiable)handler, phantomSlotWidget, container, arg_0, arg_1)).setPressed(((ItemsIngredient)((Object)this.content)).isOre()).setHoverBorderTexture(1, -1).setBaseTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("ore (N)")).setPressedTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("ore (Y)")).setHoverTooltip("using ore dictionary"));
        groupIngredient.setVisible(!((ItemsIngredient)((Object)this.content)).isOre());
        groupOre.setVisible(((ItemsIngredient)((Object)this.content)).isOre());
        if (((ItemsIngredient)((Object)this.content)).isOre()) {
            ItemStack[] matches = ((ItemsIngredient)((Object)this.content)).func_193365_a();
            handler.setStackInSlot(0, matches.length > 0 ? matches[0] : ItemStack.field_190927_a);
            phantomSlotWidget.setHoverTooltip(LocalizationUtils.format("multiblocked.gui.trait.item.ore_dict", new Object[0]) + ":\n" + ((ItemsIngredient)((Object)this.content)).getOreDict());
        } else {
            this.updateIngredientWidget(container);
        }
        groupIngredient.addWidget(new LabelWidget(x + 50, 5, "multiblocked.gui.tips.settings"));
        groupIngredient.addWidget(new ButtonWidget(100, 0, 20, 20, cd -> {
            Object[] stacks = ((ItemsIngredient)((Object)((Object)this.content))).field_193371_b;
            this.content = new ItemsIngredient(((ItemsIngredient)((Object)((Object)this.content))).getAmount(), (ItemStack[])ArrayUtils.add((Object[])stacks, (Object)new ItemStack(Items.field_151042_j)));
            this.updateIngredientWidget(container);
            this.onContentUpdate();
        }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/add.png")).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.trait.item.add"));
    }

    private void updateIngredientWidget(DraggableScrollableWidgetGroup container) {
        container.widgets.forEach(container::waitToRemoved);
        ItemStack[] matchingStacks = (ItemStack[])ArrayUtils.clone((Object[])((ItemsIngredient)((Object)this.content)).field_193371_b);
        for (int i = 0; i < matchingStacks.length; ++i) {
            ItemStack stack = matchingStacks[i];
            int finalI = i;
            int x = i % 4 * 30;
            int y = i / 4 * 20;
            ItemStackHandler handler = new ItemStackHandler(1);
            container.addWidget(new PhantomSlotWidget((IItemHandlerModifiable)handler, 0, x + 1, y + 1).setClearSlotOnRightClick(false).setChangeListener(() -> this.lambda$updateIngredientWidget$9((IItemHandlerModifiable)handler, matchingStacks, finalI)).setBackgroundTexture(new ColorRectTexture(-1354480572)));
            handler.setStackInSlot(0, stack);
            container.addWidget(new ButtonWidget(x + 21, y + 1, 9, 9, cd -> {
                this.content = new ItemsIngredient(((ItemsIngredient)((Object)((Object)this.content))).getAmount(), (ItemStack[])ArrayUtils.remove((Object[])matchingStacks, (int)finalI));
                this.updateIngredientWidget(container);
                this.onContentUpdate();
            }).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/remove.png")).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.remove"));
        }
    }

    private /* synthetic */ void lambda$updateIngredientWidget$9(IItemHandlerModifiable handler, ItemStack[] matchingStacks, int finalI) {
        ItemStack newStack;
        matchingStacks[finalI] = newStack = handler.getStackInSlot(0);
        this.content = new ItemsIngredient(((ItemsIngredient)((Object)this.content)).getAmount(), matchingStacks);
        this.onContentUpdate();
    }

    private /* synthetic */ void lambda$openConfigurator$7(WidgetGroup groupOre, TextFieldWidget ore, WidgetGroup groupIngredient, IItemHandlerModifiable handler, PhantomSlotWidget phantomSlotWidget, DraggableScrollableWidgetGroup container, ClickData cd, Boolean r) {
        groupOre.setVisible(r);
        this.content = r != false ? new ItemsIngredient(((ItemsIngredient)((Object)this.content)).getAmount(), ore.getCurrentString()) : new ItemsIngredient(((ItemsIngredient)((Object)this.content)).getAmount(), ((ItemsIngredient)((Object)this.content)).field_193371_b);
        groupIngredient.setVisible(r == false);
        if (r.booleanValue()) {
            ItemStack[] matches = ((ItemsIngredient)((Object)this.content)).func_193365_a();
            handler.setStackInSlot(0, matches.length > 0 ? matches[0] : ItemStack.field_190927_a);
            phantomSlotWidget.setHoverTooltip("oreDict: \n" + ((ItemsIngredient)((Object)this.content)).getOreDict());
        } else {
            this.updateIngredientWidget(container);
        }
        this.onContentUpdate();
    }

    private /* synthetic */ void lambda$openConfigurator$6(IItemHandlerModifiable handler, PhantomSlotWidget phantomSlotWidget, String oreDict) {
        this.content = new ItemsIngredient(((ItemsIngredient)((Object)this.content)).getAmount(), oreDict);
        ItemStack[] matches = ((ItemsIngredient)((Object)this.content)).func_193365_a();
        handler.setStackInSlot(0, matches.length > 0 ? matches[0] : ItemStack.field_190927_a);
        phantomSlotWidget.setHoverTooltip(LocalizationUtils.format("multiblocked.gui.trait.item.ore_dict", new Object[0]) + ":\n" + ((ItemsIngredient)((Object)this.content)).getOreDict());
        this.onContentUpdate();
    }

    private /* synthetic */ void lambda$openConfigurator$5(IItemHandlerModifiable handler, TextFieldWidget ore, PhantomSlotWidget phantomSlotWidget) {
        ItemStack newStack = handler.getStackInSlot(0);
        if (newStack.func_190926_b()) {
            return;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)newStack);
        if (ids.length > 0) {
            String oreDict = OreDictionary.getOreName((int)ids[0]);
            this.content = new ItemsIngredient(((ItemsIngredient)((Object)this.content)).getAmount(), oreDict);
            ore.setCurrentString(oreDict);
            phantomSlotWidget.setHoverTooltip(LocalizationUtils.format("multiblocked.gui.trait.item.ore_dict", new Object[0]) + ": " + Arrays.stream(ids).mapToObj(OreDictionary::getOreName).reduce("", (a, b) -> a + "\n" + b));
        } else {
            this.content = new ItemsIngredient(((ItemsIngredient)((Object)this.content)).getAmount(), "");
            ore.setCurrentString("");
            handler.setStackInSlot(0, ItemStack.field_190927_a);
        }
        this.onContentUpdate();
    }
}

