/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.widget;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.api.gui.util.TextFormattingUtil;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GasStackWidget
extends ContentWidget<GasStack> {
    @Override
    protected void onContentUpdate() {
        if (Multiblocked.isClient() && this.content != null) {
            this.setHoverTooltip(TextFormatting.AQUA + ((GasStack)this.content).getGas().getLocalizedName() + TextFormatting.RESET + "\n" + LocalizationUtils.format("multiblocked.gui.trait.gas.amount", new Object[0]) + " " + ((GasStack)this.content).amount);
        }
    }

    @Override
    public GasStack getJEIContent(Object content) {
        return (GasStack)super.getJEIContent(content);
    }

    @Override
    public void drawHookBackground(int mouseX, int mouseY, float partialTicks) {
        if (this.content != null) {
            Position pos = this.getPosition();
            Size size = this.getSize();
            Minecraft minecraft = Minecraft.func_71410_x();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            this.drawGas(minecraft, pos.x + 1, pos.y + 1, (GasStack)this.content);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            String s = TextFormattingUtil.formatLongToCompactStringBuckets(((GasStack)this.content).amount, 3) + "B";
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            fontRenderer.func_175063_a(s, ((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.func_78256_a(s) + 21.0f, ((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
    }

    private void drawGas(Minecraft minecraft, int xPosition, int yPosition, @Nullable GasStack gasStack) {
        Gas gas;
        Gas gas2 = gas = gasStack == null ? null : gasStack.getGas();
        if (gas == null) {
            return;
        }
        int widthT = 18;
        int heightT = 18;
        TextureAtlasSprite fluidStillSprite = GasStackWidget.getStillGasSprite(minecraft, gas);
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        MekanismRenderer.color((Gas)gas);
        int xTileCount = widthT / 16;
        int xRemainder = widthT - xTileCount * 16;
        int yTileCount = heightT / 16;
        int yRemainder = heightT - yTileCount * 16;
        int yStart = yPosition + heightT;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = xPosition + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                DrawerHelper.drawFluidTexture(x, y, fluidStillSprite, maskTop, maskRight, 0.0);
            }
        }
        GlStateManager.func_179084_k();
        MekanismRenderer.resetColor();
    }

    private static TextureAtlasSprite getStillGasSprite(Minecraft minecraft, Gas gas) {
        TextureMap textureMapBlocks = minecraft.func_147117_R();
        ResourceLocation gasStill = gas.getIcon();
        TextureAtlasSprite gasStillSprite = null;
        if (gasStill != null) {
            gasStillSprite = textureMapBlocks.getTextureExtry(gasStill.toString());
        }
        if (gasStillSprite == null) {
            gasStillSprite = textureMapBlocks.func_174944_f();
        }
        return gasStillSprite;
    }

    @Override
    public void openConfigurator(WidgetGroup dialog) {
        super.openConfigurator(dialog);
        int x = 5;
        int y = 25;
        dialog.addWidget(new LabelWidget(5, y + 3, "multiblocked.gui.label.amount"));
        dialog.addWidget(new TextFieldWidget(65, y, 60, 15, true, null, number -> {
            this.content = new GasStack(((GasStack)this.content).getGas(), Integer.parseInt(number));
            this.onContentUpdate();
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(((GasStack)this.content).amount + ""));
    }
}

