/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.widget;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.PhantomFluidWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TankWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class FluidContentWidget
extends ContentWidget<FluidStack> {
    FluidTank fluidTank;

    @Override
    protected void onContentUpdate() {
        if (Multiblocked.isClient()) {
            ArrayList<String> tooltips = new ArrayList<String>();
            tooltips.add(((FluidStack)this.content).getFluid().getLocalizedName((FluidStack)this.content));
            tooltips.add(I18n.func_135052_a((String)"multiblocked.fluid.amount", (Object[])new Object[]{((FluidStack)this.content).amount, ((FluidStack)this.content).amount}));
            tooltips.add(I18n.func_135052_a((String)"multiblocked.fluid.temperature", (Object[])new Object[]{((FluidStack)this.content).getFluid().getTemperature((FluidStack)this.content)}));
            tooltips.add(I18n.func_135052_a((String)(((FluidStack)this.content).getFluid().isGaseous((FluidStack)this.content) ? "multiblocked.fluid.state_gas" : "multiblocked.fluid.state_liquid"), (Object[])new Object[0]));
            this.setHoverTooltip(tooltips.stream().reduce((a, b) -> a + "\n" + b).orElse("fluid"));
        }
        if (this.fluidTank != null) {
            this.fluidTank.drainInternal(Integer.MAX_VALUE, true);
            this.fluidTank.setCapacity(((FluidStack)this.content).amount);
            this.fluidTank.fillInternal(((FluidStack)this.content).copy(), true);
        } else {
            this.fluidTank = new FluidTank(((FluidStack)this.content).copy(), ((FluidStack)this.content).amount);
            this.addWidget(new TankWidget((IFluidTank)this.fluidTank, 1, 1, false, false).setDrawHoverTips(false));
        }
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        List<IGhostIngredientHandler.Target<?>> pattern = super.getPhantomTargets(ingredient);
        if (pattern != null && pattern.size() > 0) {
            return pattern;
        }
        if (!(ingredient instanceof FluidStack) && PhantomFluidWidget.drainFrom(ingredient) == null) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            @Nonnull
            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(@Nonnull Object ingredient) {
                FluidStack content = ingredient instanceof FluidStack ? (FluidStack)ingredient : PhantomFluidWidget.drainFrom(ingredient);
                if (content != null) {
                    FluidContentWidget.this.setContent(FluidContentWidget.this.io, FluidContentWidget.this.getJEIContent(content), FluidContentWidget.this.chance, FluidContentWidget.this.perTick);
                    if (FluidContentWidget.this.onPhantomUpdate != null) {
                        FluidContentWidget.this.onPhantomUpdate.accept(FluidContentWidget.this);
                    }
                }
            }
        }});
    }

    @Override
    public FluidStack getJEIContent(Object content) {
        if (content instanceof FluidStack) {
            return new FluidStack(((FluidStack)content).getFluid(), ((FluidStack)this.content).amount);
        }
        return null;
    }

    @Override
    public void openConfigurator(WidgetGroup dialog) {
        super.openConfigurator(dialog);
        int x = 5;
        int y = 25;
        dialog.addWidget(new LabelWidget(5, y + 3, "multiblocked.gui.label.amount"));
        dialog.addWidget(new TextFieldWidget(65, y, 60, 15, true, null, number -> {
            this.content = new FluidStack((FluidStack)this.content, Integer.parseInt(number));
            this.onContentUpdate();
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(((FluidStack)this.content).amount + ""));
    }
}

