/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.widget;

import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SlotWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.recipe.EntityIngredient;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EntityContentWidget
extends ContentWidget<EntityIngredient> {
    protected ItemStackHandler itemHandler;

    @Override
    protected void onContentUpdate() {
        if (this.itemHandler == null) {
            this.itemHandler = new ItemStackHandler();
            this.addWidget(new SlotWidget((IItemHandler)this.itemHandler, 0, 1, 1, false, false).setDrawOverlay(false).setOnAddedTooltips((s, l) -> {
                if (this.chance < 1.0f) {
                    l.add(this.chance == 0.0f ? LocalizationUtils.format("multiblocked.gui.content.chance_0", new Object[0]) : LocalizationUtils.format("multiblocked.gui.content.chance_1", String.format("%.1f", Float.valueOf(this.chance * 100.0f))));
                }
                if (this.perTick) {
                    l.add(LocalizationUtils.format("multiblocked.gui.content.per_tick", new Object[0]));
                }
            }));
        }
        if (((EntityIngredient)this.content).isEntityItem()) {
            this.itemHandler.setStackInSlot(0, ((EntityIngredient)this.content).getEntityItem());
        } else {
            ItemStack itemStack;
            EntityList.EntityEggInfo egg = ((EntityIngredient)this.content).type.getEgg();
            if (egg == null) {
                itemStack = ItemStack.field_190927_a;
            } else {
                itemStack = new ItemStack(Items.field_151063_bx);
                ItemMonsterPlacer.func_185078_a((ItemStack)itemStack, (ResourceLocation)egg.field_75613_a);
            }
            this.itemHandler.setStackInSlot(0, itemStack);
        }
    }

    @Override
    public EntityIngredient getJEIContent(Object content) {
        EntityIngredient ingredient = new EntityIngredient();
        if (content instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)content;
            if (itemStack.func_77973_b() instanceof ItemMonsterPlacer) {
                ResourceLocation id = ItemMonsterPlacer.func_190908_h((ItemStack)itemStack);
                ingredient.type = (EntityEntry)ForgeRegistries.ENTITIES.getValue(id);
            } else {
                ingredient.type = EntityIngredient.ITEM;
                ingredient.tag = new NBTTagCompound();
                ingredient.tag.func_74782_a("Item", (NBTBase)itemStack.func_77955_b(new NBTTagCompound()));
            }
        }
        return ingredient;
    }

    @Override
    public Object getJEIIngredient(EntityIngredient content) {
        ItemStack item = this.itemHandler.getStackInSlot(0);
        return item.func_190926_b() ? null : item;
    }

    @Override
    public void openConfigurator(WidgetGroup dialog) {
        super.openConfigurator(dialog);
        int y = 25;
        dialog.addWidget(new LabelWidget(5, y + 3, "multiblocked.gui.label.entity_type"));
        TextFieldWidget type = new TextFieldWidget(65, y, 60, 15, null, string -> {
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(string));
            ((EntityIngredient)this.content).type = entry == null ? ((EntityIngredient)this.content).type : entry;
            this.onContentUpdate();
        });
        dialog.addWidget(type);
        dialog.addWidget(new LabelWidget(5, y + 23, "multiblocked.gui.label.entity_tag"));
        TextFieldWidget tag = new TextFieldWidget(65, y + 20, 60, 15, null, string -> {
            try {
                ((EntityIngredient)this.content).tag = JsonToNBT.func_180713_a((String)string);
                this.onContentUpdate();
            }
            catch (NBTException nBTException) {
                // empty catch block
            }
        });
        dialog.addWidget(tag);
        if (this.content != null) {
            type.setCurrentString(((EntityIngredient)this.content).type.getRegistryName().toString());
            if (((EntityIngredient)this.content).tag != null) {
                tag.setCurrentString(((EntityIngredient)this.content).tag.toString());
            }
        }
    }
}

