/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.trait;

import com.cleanroommc.multiblocked.api.capability.trait.InterfaceUser;
import com.cleanroommc.multiblocked.api.capability.trait.ProgressCapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SwitchWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ProgressWidget;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.common.capability.StarlightAstralCapability;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.starlight.IStarlightTransmission;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightUpdateHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SkyCollectionHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@InterfaceUser(value=StarlightAstralCapability.ILinkableStarlightReceiver.class)
public class StarlightCapabilityTrait
extends ProgressCapabilityTrait
implements StarlightAstralCapability.ILinkableStarlightReceiver {
    private int starlight;
    private int capacity;
    private IConstellation constellation;
    private boolean passiveStarlight = true;
    private boolean isNetworkInformed;
    private boolean canSeeSky;
    private float posDistribution = -1.0f;

    public StarlightCapabilityTrait() {
        super(StarlightAstralCapability.CAP);
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        super.serialize(jsonElement);
        if (jsonElement == null) {
            jsonElement = new JsonObject();
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        this.capacity = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"capacity", (int)2000);
        this.passiveStarlight = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"passiveStarlight", (boolean)true);
    }

    @Override
    public JsonElement deserialize() {
        JsonObject jsonObject = super.deserialize().getAsJsonObject();
        jsonObject.addProperty("capacity", (Number)this.capacity);
        jsonObject.addProperty("passiveStarlight", Boolean.valueOf(this.passiveStarlight));
        return jsonObject;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.starlight = compound.func_74762_e("starlight");
        this.constellation = IConstellation.readFromNBT((NBTTagCompound)compound, (String)"constellation");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("starlight", this.starlight);
        this.constellation.writeToNBT(compound, "constellation");
    }

    @Override
    public void createUI(ComponentTileEntity<?> component, WidgetGroup group, EntityPlayer player) {
        group.addWidget(new ProgressWidget(this::getProgress, this.x, this.y, this.width, this.height, new ResourceTexture(this.texture)){
            private IConstellation lastConstellation;

            @Override
            public void detectAndSendChanges() {
                if (this.lastConstellation != StarlightCapabilityTrait.this.constellation) {
                    this.lastConstellation = StarlightCapabilityTrait.this.constellation;
                    this.writeUpdateInfo(1, buffer -> buffer.func_180714_a(StarlightCapabilityTrait.this.constellation.getUnlocalizedName()));
                }
                super.detectAndSendChanges();
            }

            @Override
            public void readUpdateInfo(int id, PacketBuffer buffer) {
                if (id == 1) {
                    this.lastConstellation = StarlightCapabilityTrait.this.constellation = ConstellationRegistry.getConstellationByName((String)buffer.func_150789_c(Short.MAX_VALUE));
                }
                super.readUpdateInfo(id, buffer);
            }
        }.setDynamicHoverTips(this::dynamicHoverTips).setFillDirection(this.fillDirection));
    }

    @Override
    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot) {
        super.initSettingDialog(dialog, slot);
        dialog.addWidget(new TextFieldWidget(60, 5, 100, 15, true, null, s -> {
            this.capacity = Integer.parseInt(s);
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(this.capacity + "").setHoverTooltip("multiblocked.gui.trait.starlight.tips.0"));
        dialog.addWidget(new SwitchWidget(60, 25, 15, 15, (clickData, bool) -> {
            this.passiveStarlight = bool;
        }).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.0, 1.0, 0.5)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.5, 1.0, 0.5)).setHoverTexture(new ColorBorderTexture(1, -11249833)).setPressed(this.passiveStarlight).setHoverTooltip("multiblocked.gui.trait.starlight.tips.1"));
        dialog.addWidget(new LabelWidget(80, 25, "passiveStarlight"));
    }

    @Override
    public boolean hasUpdate() {
        return true;
    }

    @Override
    public void update() {
        if (this.component.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.isNetworkInformed && !this.isInAstralNetwork()) {
            this.informNetworkPlacement();
            this.isNetworkInformed = true;
        }
        if (this.passiveStarlight) {
            this.passiveStarlight();
        }
    }

    @Override
    public void onDrops(NonNullList<ItemStack> drops, EntityPlayer player) {
        if (this.component.func_145831_w().field_72995_K) {
            return;
        }
        this.informNetworkRemoval();
        this.isNetworkInformed = false;
    }

    @Override
    protected String dynamicHoverTips(double progress) {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(LocalizationUtils.format("multiblocked.gui.trait.starlight.current", (int)(progress * (double)this.getStarlightCapacity()), this.getStarlightCapacity()));
        if (this.getFocusedConstellation() != null) {
            stringJoiner.add(LocalizationUtils.format("multiblocked.gui.trait.starlight.constellation", LocalizationUtils.format(this.getFocusedConstellation().getUnlocalizedName(), new Object[0])));
        } else {
            stringJoiner.add(LocalizationUtils.format("multiblocked.gui.trait.starlight.no_constellation", new Object[0]));
        }
        return stringJoiner.toString();
    }

    @Override
    protected double getProgress() {
        return (double)this.getStarlightStored() / (double)this.getStarlightCapacity();
    }

    public World getLinkWorld() {
        return this.getTrWorld();
    }

    public BlockPos getLinkPos() {
        return this.getTrPos();
    }

    @Nullable
    public String getUnLocalizedDisplayName() {
        return this.component.func_145838_q().func_149739_a() + ".name";
    }

    public void onLinkCreate(EntityPlayer entityPlayer, BlockPos blockPos) {
    }

    public boolean tryLink(EntityPlayer entityPlayer, BlockPos blockPos) {
        return false;
    }

    public boolean tryUnlink(EntityPlayer entityPlayer, BlockPos blockPos) {
        return false;
    }

    public List<BlockPos> getLinkedPositions() {
        return new LinkedList<BlockPos>();
    }

    @Nonnull
    public ITransmissionReceiver provideEndpoint(BlockPos blockPos) {
        return new MultiblockedTransmissionReceiver(blockPos);
    }

    @Nonnull
    public BlockPos getTrPos() {
        return this.component.func_174877_v();
    }

    @Nonnull
    public World getTrWorld() {
        return this.component.func_145831_w();
    }

    @Override
    public int getStarlightStored() {
        return this.starlight;
    }

    @Override
    public void setStarlightStored(int starlight) {
        this.starlight = starlight;
        this.markAsDirty();
    }

    @Override
    public int getStarlightCapacity() {
        return this.capacity;
    }

    @Override
    public IConstellation getFocusedConstellation() {
        return this.constellation;
    }

    @Override
    public void setFocusedConstellation(IConstellation constellation) {
        if (this.constellation == null || !this.constellation.equals(constellation)) {
            this.constellation = constellation;
        }
    }

    private boolean isInAstralNetwork() {
        WorldNetworkHandler networkHandler = WorldNetworkHandler.getNetworkHandler((World)this.getTrWorld());
        return networkHandler.getTransmissionNode(this.getTrPos()) != null;
    }

    private void informNetworkPlacement() {
        WorldNetworkHandler networkHandler = WorldNetworkHandler.getNetworkHandler((World)this.getTrWorld());
        networkHandler.addTransmissionTile((IStarlightTransmission)this);
        IPrismTransmissionNode node = networkHandler.getTransmissionNode(this.getTrPos());
        if (node != null && node.needsUpdate()) {
            StarlightUpdateHandler.getInstance().addNode(this.getTrWorld(), node);
        }
    }

    private void informNetworkRemoval() {
        WorldNetworkHandler networkHandler = WorldNetworkHandler.getNetworkHandler((World)this.getTrWorld());
        IPrismTransmissionNode node = networkHandler.getTransmissionNode(this.getTrPos());
        if (node != null) {
            StarlightUpdateHandler.getInstance().removeNode(this.getTrWorld(), node);
        }
        networkHandler.removeTransmission((IStarlightTransmission)this);
    }

    private void passiveStarlight() {
        int yLevel;
        if ((this.component.getTimer() & 0xF) == 0) {
            this.canSeeSky = MiscUtils.canSeeSky((World)this.component.func_145831_w(), (BlockPos)this.component.func_174877_v().func_177984_a(), (boolean)true, (boolean)this.canSeeSky);
        }
        this.starlight = (int)((double)this.starlight * 0.95);
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler(this.component.func_145831_w());
        if (this.canSeeSky && handle != null && (yLevel = this.component.func_174877_v().func_177956_o()) > 40) {
            float collect = 160.0f;
            float dstr = yLevel > 120 ? 1.0f + (float)(yLevel - 120) / 272.0f : (float)(yLevel - 20) / 100.0f;
            if (this.posDistribution == -1.0f) {
                this.posDistribution = SkyCollectionHelper.getSkyNoiseDistribution((World)this.component.func_145831_w(), (BlockPos)this.component.func_174877_v());
            }
            collect *= dstr;
            collect = (float)((double)collect * (0.6 + 0.4 * (double)this.posDistribution));
            collect = (float)((double)collect * (0.2 + 0.8 * (double)ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.component.func_145831_w())));
            this.setStarlightStored(Math.min(this.getStarlightCapacity(), (int)((float)this.getStarlightStored() + collect)));
            this.markAsDirty();
        }
    }

    public static class MultiblockedTransmissionProvider
    implements TransmissionClassRegistry.TransmissionProvider {
        public IPrismTransmissionNode provideEmptyNode() {
            return new MultiblockedTransmissionReceiver(null);
        }

        public String getIdentifier() {
            return "multiblocked:StarlightTrait";
        }
    }

    public static class MultiblockedTransmissionReceiver
    extends SimpleTransmissionReceiver {
        public MultiblockedTransmissionReceiver(BlockPos thisPos) {
            super(thisPos);
        }

        public void onStarlightReceive(World world, boolean isChunkLoaded, IWeakConstellation type, double amount) {
            if (isChunkLoaded) {
                if (amount <= 0.001) {
                    return;
                }
                StarlightAstralCapability.ILinkableStarlightReceiver tile = (StarlightAstralCapability.ILinkableStarlightReceiver)MiscUtils.getTileAt((IBlockAccess)world, (BlockPos)this.getLocationPos(), StarlightAstralCapability.ILinkableStarlightReceiver.class, (boolean)false);
                if (tile != null) {
                    tile.setStarlightStored(Math.min(tile.getStarlightCapacity(), (int)((double)tile.getStarlightStored() + amount * 200.0)));
                    tile.setFocusedConstellation((IConstellation)type);
                    ((TileEntity)tile).func_70296_d();
                }
            }
        }

        public TransmissionClassRegistry.TransmissionProvider getProvider() {
            return new MultiblockedTransmissionProvider();
        }
    }
}

