/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.trait;

import com.cleanroommc.multiblocked.api.capability.trait.InterfaceUser;
import com.cleanroommc.multiblocked.api.capability.trait.SingleCapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.util.DrawerHelper;
import com.cleanroommc.multiblocked.api.gui.widget.Widget;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.common.capability.PneumaticPressureCapability;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.block.tubes.IPneumaticPosProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@InterfaceUser(value=IPneumaticPosProvider.class)
public class PneumaticMachineTrait
extends SingleCapabilityTrait
implements IPneumaticPosProvider {
    private IAirHandler airHandler;
    public float dangerPressure;
    public float criticalPressure;
    public int volume;
    private int lastAir;

    public PneumaticMachineTrait() {
        super(PneumaticPressureCapability.CAP);
    }

    @Override
    public JsonElement deserialize() {
        JsonObject jsonObject = super.deserialize().getAsJsonObject();
        jsonObject.addProperty("dangerPressure", (Number)Float.valueOf(this.dangerPressure));
        jsonObject.addProperty("criticalPressure", (Number)Float.valueOf(this.criticalPressure));
        jsonObject.addProperty("volume", (Number)this.volume);
        return jsonObject;
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        super.serialize(jsonElement);
        if (jsonElement == null) {
            jsonElement = new JsonObject();
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        this.dangerPressure = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"dangerPressure", (float)5.0f);
        this.criticalPressure = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"criticalPressure", (float)7.0f);
        this.volume = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"volume", (int)10000);
        this.airHandler = PneumaticCraftAPIHandler.getInstance().getAirHandlerSupplier().createAirHandler(this.dangerPressure, this.criticalPressure, this.volume);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.airHandler.readFromNBT(compound);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        this.airHandler.writeToNBT(compound);
    }

    public IAirHandler getAirHandler(EnumFacing enumFacing) {
        return this.airHandler;
    }

    public World world() {
        return this.component.func_145831_w();
    }

    public BlockPos pos() {
        return this.component.func_174877_v();
    }

    @Override
    public void validate() {
        this.airHandler.validate((TileEntity)this.component);
    }

    @Override
    public void update() {
        this.airHandler.update();
        if (this.lastAir != this.airHandler.getAir()) {
            this.lastAir = this.airHandler.getAir();
            this.markAsDirty();
        }
    }

    @Override
    public boolean hasUpdate() {
        return true;
    }

    @Override
    public void createUI(ComponentTileEntity<?> component, WidgetGroup group, EntityPlayer player) {
        super.createUI(component, group, player);
        group.addWidget(new PressureWidget(this.x, this.y, this.dangerPressure, this.criticalPressure, this.airHandler.getPressure(), this.airHandler.getVolume(), this.airHandler.getAir()));
    }

    @Override
    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot) {
        super.initSettingDialog(dialog, slot);
        dialog.addWidget(new TextFieldWidget(60, 25, 100, 15, true, null, s -> {
            this.dangerPressure = Float.parseFloat(s);
            this.updateSettings();
        }).setNumbersOnly(0.0f, Float.MAX_VALUE).setCurrentString(this.dangerPressure + "").setHoverTooltip("multiblocked.gui.trait.pressure.tips.0"));
        dialog.addWidget(new TextFieldWidget(60, 45, 100, 15, true, null, s -> {
            this.criticalPressure = Float.parseFloat(s);
            this.updateSettings();
        }).setNumbersOnly(0.0f, Float.MAX_VALUE).setCurrentString(this.criticalPressure + "").setHoverTooltip("multiblocked.gui.trait.pressure.tips.1"));
        dialog.addWidget(new TextFieldWidget(60, 65, 100, 15, true, null, s -> {
            this.volume = Integer.parseInt(s);
            this.updateSettings();
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(this.volume + "").setHoverTooltip("multiblocked.gui.trait.pressure.tips.2"));
    }

    @Override
    public void onNeighborChanged() {
        this.airHandler.onNeighborChange();
    }

    public void updateSettings() {
        int air = this.airHandler.getAir();
        this.airHandler = PneumaticCraftAPIHandler.getInstance().getAirHandlerSupplier().createAirHandler(this.dangerPressure, this.criticalPressure, this.volume);
        this.airHandler.addAir(air);
        if (this.component != null) {
            this.airHandler.validate((TileEntity)this.component);
        }
    }

    public class PressureWidget
    extends Widget {
        private float dangerPressure;
        private float criticalPressure;
        private float pressure;
        private int volume;
        private int air;

        public PressureWidget(int xPosition, int yPosition, float dangerPressure, float criticalPressure, float pressure, int volume, int air) {
            super(new Position(xPosition, yPosition), new Size(44, 44));
            this.dangerPressure = dangerPressure;
            this.criticalPressure = criticalPressure;
            this.pressure = pressure;
            this.volume = volume;
            this.air = air;
        }

        @Override
        public void drawInBackground(int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawPressureGauge((FontRenderer)Minecraft.func_71410_x().field_71466_p, (float)-1.0f, (float)this.criticalPressure, (float)this.dangerPressure, (float)-3.4028235E38f, (float)this.pressure, (int)this.getPosition().x, (int)this.getPosition().y, (float)0.0f);
        }

        @Override
        public void drawInForeground(int mouseX, int mouseY, float partialTicks) {
            if (this.gui != null && this.isMouseOverElement(mouseX + 22, mouseY + 22)) {
                GlStateManager.func_179126_j();
                ArrayList tooltip = Lists.newArrayList((Object[])new String[]{LocalizationUtils.format("multiblocked.gui.trait.pressure.current", Float.valueOf(this.pressure)), LocalizationUtils.format("multiblocked.gui.trait.pressure.air", this.air), LocalizationUtils.format("multiblocked.gui.trait.pressure.volume", this.volume)});
                DrawerHelper.drawHoveringText(ItemStack.field_190927_a, tooltip, 300, mouseX, mouseY, this.gui.getScreenWidth(), this.gui.getScreenHeight());
            }
        }

        @Override
        public void detectAndSendChanges() {
            if (PneumaticMachineTrait.this.dangerPressure - this.dangerPressure != 0.0f) {
                this.dangerPressure = PneumaticMachineTrait.this.dangerPressure;
                this.writeUpdateInfo(0, buffer -> buffer.writeFloat(this.dangerPressure));
            }
            if (PneumaticMachineTrait.this.criticalPressure - this.criticalPressure != 0.0f) {
                this.criticalPressure = PneumaticMachineTrait.this.criticalPressure;
                this.writeUpdateInfo(1, buffer -> buffer.writeFloat(this.criticalPressure));
            }
            if (PneumaticMachineTrait.this.airHandler.getPressure() - this.pressure != 0.0f) {
                this.pressure = PneumaticMachineTrait.this.airHandler.getPressure();
                this.writeUpdateInfo(2, buffer -> buffer.writeFloat(this.pressure));
            }
            if (PneumaticMachineTrait.this.airHandler.getVolume() != this.volume) {
                this.volume = PneumaticMachineTrait.this.airHandler.getVolume();
                this.writeUpdateInfo(3, buffer -> buffer.writeInt(this.volume));
            }
            if (PneumaticMachineTrait.this.airHandler.getAir() != this.air) {
                this.air = PneumaticMachineTrait.this.airHandler.getAir();
                this.writeUpdateInfo(4, buffer -> buffer.writeInt(this.air));
            }
        }

        @Override
        public void readUpdateInfo(int id, PacketBuffer buffer) {
            switch (id) {
                case 0: {
                    this.dangerPressure = buffer.readFloat();
                    break;
                }
                case 1: {
                    this.criticalPressure = buffer.readFloat();
                    break;
                }
                case 2: {
                    this.pressure = buffer.readFloat();
                    break;
                }
                case 3: {
                    this.volume = buffer.readInt();
                    break;
                }
                case 4: {
                    this.air = buffer.readInt();
                    PneumaticMachineTrait.this.airHandler.addAir(-PneumaticMachineTrait.this.airHandler.getAir());
                    PneumaticMachineTrait.this.airHandler.addAir(this.air);
                }
            }
        }
    }
}

