/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.trait;

import com.cleanroommc.multiblocked.api.capability.trait.InterfaceUser;
import com.cleanroommc.multiblocked.api.capability.trait.ProgressCapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SwitchWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.common.capability.ManaBotaniaCapability;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.google.common.base.Predicates;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.AxisAlignedBB;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;

@InterfaceUser(value=ISparkAttachable.class)
public class ManaCapabilityTrait
extends ProgressCapabilityTrait
implements ISparkAttachable {
    private int mana;
    private int capacity;
    private boolean allowSpark;

    public ManaCapabilityTrait() {
        super(ManaBotaniaCapability.CAP);
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        super.serialize(jsonElement);
        if (jsonElement == null) {
            jsonElement = new JsonObject();
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        this.capacity = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"capacity", (int)1000000);
        this.allowSpark = JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"allowSpark", (boolean)false);
    }

    @Override
    public JsonElement deserialize() {
        JsonObject jsonObject = super.deserialize().getAsJsonObject();
        jsonObject.addProperty("capacity", (Number)this.capacity);
        jsonObject.addProperty("allowSpark", Boolean.valueOf(this.allowSpark));
        return jsonObject;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("mana", this.mana);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.mana = compound.func_74762_e("mana");
    }

    @Override
    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot) {
        super.initSettingDialog(dialog, slot);
        dialog.addWidget(new TextFieldWidget(60, 5, 100, 15, true, null, s -> {
            this.capacity = Integer.parseInt(s);
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(this.capacity + "").setHoverTooltip("multiblocked.gui.trait.mana.tips.0"));
        dialog.addWidget(new SwitchWidget(60, 25, 15, 15, (clickData, bool) -> {
            this.allowSpark = bool;
        }).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.0, 1.0, 0.5)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.5, 1.0, 0.5)).setHoverTexture(new ColorBorderTexture(1, -11249833)).setPressed(this.allowSpark).setHoverTooltip("multiblocked.gui.trait.mana.tips.1"));
        dialog.addWidget(new LabelWidget(80, 25, "allowSpark"));
    }

    public boolean isFull() {
        return this.getCurrentMana() >= this.capacity;
    }

    public void recieveMana(int i) {
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + i, this.capacity));
        this.markAsDirty();
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    protected String dynamicHoverTips(double progress) {
        return LocalizationUtils.format("multiblocked.gui.trait.mana.progress", (int)(progress * (double)this.capacity), this.capacity);
    }

    @Override
    protected double getProgress() {
        return (double)this.getCurrentMana() / (double)this.capacity;
    }

    public boolean canAttachSpark(ItemStack itemStack) {
        return this.allowSpark;
    }

    public void attachSpark(ISparkEntity iSparkEntity) {
    }

    public int getAvailableSpaceForMana() {
        return Math.max(0, this.capacity - this.getCurrentMana());
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.component.func_145831_w().func_175647_a(Entity.class, new AxisAlignedBB(this.component.func_174877_v().func_177984_a(), this.component.func_174877_v().func_177984_a().func_177982_a(1, 1, 1)), Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            return (ISparkEntity)sparks.get(0);
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return false;
    }
}

