/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.trait;

import com.cleanroommc.multiblocked.api.capability.trait.InterfaceUser;
import com.cleanroommc.multiblocked.api.capability.trait.ProgressCapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.common.capability.LaserMekanismCapability;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

@InterfaceUser(value=ILaserReceptor.class)
public class LaserCapabilityTrait
extends ProgressCapabilityTrait
implements ILaserReceptor {
    private double energy;
    private double capacity;

    public LaserCapabilityTrait() {
        super(LaserMekanismCapability.CAP);
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        JsonObject jsonObject;
        super.serialize(jsonElement);
        if (jsonElement == null) {
            jsonElement = new JsonObject();
        }
        this.capacity = (jsonObject = jsonElement.getAsJsonObject()).has("capacity") ? jsonObject.get("capacity").getAsDouble() : Double.MAX_VALUE;
    }

    @Override
    public JsonElement deserialize() {
        JsonObject jsonObject = super.deserialize().getAsJsonObject();
        jsonObject.addProperty("capacity", (Number)this.capacity);
        return jsonObject;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74780_a("energy", this.energy);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.energy = compound.func_74769_h("energy");
    }

    @Override
    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot) {
        super.initSettingDialog(dialog, slot);
        dialog.addWidget(new TextFieldWidget(60, 5, 100, 15, true, null, s -> {
            this.capacity = Double.parseDouble(s);
        }).setNumbersOnly(1L, Long.MAX_VALUE).setCurrentString(this.capacity + "").setHoverTooltip("multiblocked.gui.trait.laser.tips.0"));
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.LASER_RECEPTOR_CAPABILITY ? Capabilities.LASER_RECEPTOR_CAPABILITY.cast((Object)this) : null);
    }

    @Override
    @Nullable
    public <T> T getInnerCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.LASER_RECEPTOR_CAPABILITY ? Capabilities.LASER_RECEPTOR_CAPABILITY.cast((Object)this) : null);
    }

    @Override
    protected String dynamicHoverTips(double progress) {
        return LocalizationUtils.format("multiblocked.gui.trait.laser.progress", progress * this.capacity, this.capacity);
    }

    @Override
    protected double getProgress() {
        return this.energy / this.capacity;
    }

    public void setEnergy(double energy) {
        this.energy = Math.max(0.0, Math.min(energy, this.capacity));
    }

    public double getEnergy() {
        return this.energy;
    }

    public void receiveLaserEnergy(double v, EnumFacing enumFacing) {
        this.setEnergy(this.getEnergy() + v);
    }

    public boolean canLasersDig() {
        return false;
    }
}

