/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.trait;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.trait.MultiCapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.GuiUtils;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SlotWidget;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.common.capability.ItemMultiblockCapability;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class ItemCapabilityTrait
extends MultiCapabilityTrait {
    private ItemStackHandler handler;
    private ItemStack[][] validItems;

    public ItemCapabilityTrait() {
        super(ItemMultiblockCapability.CAP);
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        super.serialize(jsonElement);
        if (jsonElement == null) {
            jsonElement = new JsonArray();
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        int size = jsonArray.size();
        this.validItems = new ItemStack[size][];
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            if (!jsonObject.has("valid")) continue;
            this.validItems[i] = new ItemStack[0];
            for (JsonElement item : jsonObject.get("valid").getAsJsonArray()) {
                this.validItems[i] = (ItemStack[])ArrayUtils.add((Object[])this.validItems[i], (Object)Multiblocked.GSON.fromJson(item.getAsString(), ItemStack.class));
            }
        }
        this.handler = new ItemStackHandler(size){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (ItemCapabilityTrait.this.validItems[slot] != null) {
                    for (ItemStack itemStack : ItemCapabilityTrait.this.validItems[slot]) {
                        if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemStack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack)) continue;
                        return true;
                    }
                    return false;
                }
                return super.isItemValid(slot, stack);
            }
        };
    }

    @Override
    public JsonElement deserialize() {
        JsonArray jsonArray = super.deserialize().getAsJsonArray();
        for (int i = 0; i < this.capabilityIO.length; ++i) {
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            if (this.validItems[i] == null) continue;
            JsonArray items = new JsonArray();
            for (ItemStack itemStack : this.validItems[i]) {
                items.add(Multiblocked.GSON.toJson((Object)itemStack));
            }
            jsonObject.add("valid", (JsonElement)items);
        }
        return jsonArray;
    }

    @Override
    public void onDrops(NonNullList<ItemStack> drops, EntityPlayer player) {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            drops.add((Object)this.handler.getStackInSlot(i));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagList tagList = compound.func_74775_l("_").func_150295_c("Items", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.handler.getSlots()) continue;
            this.handler.setStackInSlot(slot, new ItemStack(itemTags));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74782_a("_", (NBTBase)this.handler.serializeNBT());
    }

    @Override
    public void createUI(ComponentTileEntity<?> component, WidgetGroup group, EntityPlayer player) {
        super.createUI(component, group, player);
        if (this.handler != null) {
            for (int i = 0; i < this.handler.getSlots(); ++i) {
                group.addWidget(new SlotWidget(new ProxyItemHandler(this.handler, this.guiIO, this.slotName, null), i, this.x[i], this.y[i], true, true));
            }
        }
    }

    @Override
    public boolean hasUpdate() {
        return ArrayUtils.contains((boolean[])this.autoIO, (boolean)true);
    }

    @Override
    public void update() {
        for (int i = 0; i < this.autoIO.length; ++i) {
            ItemStack already;
            if (!this.autoIO[i]) continue;
            if (this.capabilityIO[i] == IO.IN) {
                already = this.handler.getStackInSlot(i);
                int need = this.handler.getSlotLimit(i) - already.func_190916_E();
                if (need <= 0) continue;
                EnumFacing[] enumFacingArray = this.getIOFacing();
                int n = enumFacingArray.length;
                for (int j = 0; j < n; ++j) {
                    IItemHandler handler;
                    EnumFacing facing = enumFacingArray[j];
                    TileEntity te = this.component.func_145831_w().func_175625_s(this.component.func_174877_v().func_177972_a(facing));
                    if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()) || (handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) == null) continue;
                    for (int j2 = 0; j2 < handler.getSlots(); ++j2) {
                        ItemStack extracted = handler.extractItem(j2, need, true);
                        if (extracted.func_190926_b() || !already.func_190926_b() && !extracted.func_77969_a(already)) continue;
                        this.handler.insertItem(i, handler.extractItem(j2, need, false).func_77946_l(), false);
                        return;
                    }
                }
                continue;
            }
            if (this.capabilityIO[i] != IO.OUT || (already = this.handler.getStackInSlot(i)).func_190926_b()) continue;
            for (EnumFacing facing : this.getIOFacing()) {
                IItemHandler handler;
                TileEntity te = this.component.func_145831_w().func_175625_s(this.component.func_174877_v().func_177972_a(facing));
                if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()) || (handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) == null) continue;
                for (int j = 0; j < handler.getSlots(); ++j) {
                    ItemStack left = handler.insertItem(j, already.func_77946_l(), false);
                    if (left.func_190916_E() == already.func_190916_E()) continue;
                    this.handler.extractItem(i, already.func_190916_E() - left.func_190916_E(), false);
                    return;
                }
            }
        }
        super.update();
    }

    @Override
    protected void addSlot() {
        super.addSlot();
        this.validItems = (ItemStack[][])ArrayUtils.add((Object[])this.validItems, null);
    }

    @Override
    protected void removeSlot(int index) {
        super.removeSlot(index);
        this.validItems = (ItemStack[][])ArrayUtils.remove((Object[])this.validItems, (int)index);
    }

    @Override
    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot, int index) {
        super.initSettingDialog(dialog, slot, index);
        WidgetGroup widget = new WidgetGroup(5, 73, 200, 200);
        dialog.addWidget(widget);
        dialog.addWidget(GuiUtils.createBoolSwitch(5, 60, "Item Filter", "", this.validItems[index] != null, result -> {
            if (result.booleanValue()) {
                this.validItems[index] = new ItemStack[0];
                widget.addWidget(GuiUtils.createItemStackSelector(dialog, 0, 0, "Valid Items", Arrays.stream(this.validItems[index]).collect(Collectors.toList()), list -> {
                    this.validItems[index] = list.toArray(new ItemStack[0]);
                }));
            } else {
                widget.clearAllWidgets();
                this.validItems[index] = null;
            }
        }));
        if (this.validItems[index] != null) {
            widget.addWidget(GuiUtils.createItemStackSelector(dialog, 0, 0, "Valid Items", Arrays.stream(this.validItems[index]).collect(Collectors.toList()), list -> {
                this.validItems[index] = list.toArray(new ItemStack[0]);
            }));
        }
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new ProxyItemHandler(this.handler, this.capabilityIO, this.slotName, null)) : null);
    }

    @Override
    @Nullable
    public <T> T getInnerCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing, @Nullable String slotName) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new ProxyItemHandler(this.handler, this.getRealMbdIO(), this.slotName, slotName)) : null);
    }

    private class ProxyItemHandler
    implements IItemHandler,
    IItemHandlerModifiable {
        public ItemStackHandler proxy;
        public IO[] ios;
        public String[] slotNames;
        public String slotName;

        public ProxyItemHandler(ItemStackHandler proxy, IO[] ios, @Nullable String[] slotNames, String slotName) {
            this.proxy = proxy;
            this.ios = ios;
            this.slotNames = slotNames;
            this.slotName = slotName;
        }

        public int getSlots() {
            return this.proxy.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.proxy.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.slotName != null && !this.slotNames[slot].equals(this.slotName)) {
                return stack;
            }
            IO io = this.ios[slot];
            if (io == IO.BOTH || io == IO.IN) {
                if (!simulate) {
                    ItemCapabilityTrait.this.markAsDirty();
                }
                return this.proxy.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.slotName != null && !this.slotNames[slot].equals(this.slotName)) {
                return ItemStack.field_190927_a;
            }
            IO io = this.ios[slot];
            if (io == IO.BOTH || io == IO.OUT) {
                if (!simulate) {
                    ItemCapabilityTrait.this.markAsDirty();
                }
                return this.proxy.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return this.proxy.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.proxy.isItemValid(slot, stack);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.proxy.setStackInSlot(slot, stack);
        }
    }
}

