/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.trait;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.trait.ProgressCapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.common.capability.ImpetusThaumicAugmentationCapability;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import thaumcraft.api.aspects.Aspect;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.ConsumeResult;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.BufferedImpetusProsumer;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;

public class ImpetusCapabilityTrait
extends ProgressCapabilityTrait {
    private ImpetusStorageProxy storage;
    private ImpetusNodeProxy node;
    private int capacity;
    private int maxReceive;
    private int maxExtract;
    private int maxInputs;
    private int maxOutputs;
    private double beamEndpointXOffset;
    private double beamEndpointYOffset;
    private double beamEndpointZOffset;

    public ImpetusCapabilityTrait() {
        super(ImpetusThaumicAugmentationCapability.CAP);
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        super.serialize(jsonElement);
        if (jsonElement == null) {
            jsonElement = new JsonObject();
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        this.capacity = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"capacity", (int)300);
        this.maxReceive = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"maxReceive", (int)50);
        this.maxExtract = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"maxExtract", (int)50);
        this.maxInputs = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"maxInputs", (int)1);
        this.maxOutputs = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"maxOutputs", (int)1);
        this.beamEndpointXOffset = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"beamEndpointXOffset", (float)0.5f);
        this.beamEndpointYOffset = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"beamEndpointYOffset", (float)0.5f);
        this.beamEndpointZOffset = JsonUtils.func_151221_a((JsonObject)jsonObject, (String)"beamEndpointZOffset", (float)0.5f);
        this.storage = new ImpetusStorageProxy(this.capacity, this.maxReceive, this.maxExtract);
        this.node = new ImpetusNodeProxy(this.maxInputs, this.maxOutputs, (IImpetusStorage)this.storage);
    }

    private static Vec3d rotateYCCW(Vec3d toRotate) {
        double a = toRotate.field_72450_a - 0.5;
        double b = toRotate.field_72449_c - 0.5;
        return new Vec3d(b + 0.5, toRotate.field_72448_b, -a + 0.5);
    }

    @Override
    public JsonElement deserialize() {
        JsonObject jsonObject = super.deserialize().getAsJsonObject();
        jsonObject.addProperty("capacity", (Number)this.capacity);
        jsonObject.addProperty("maxReceive", (Number)this.maxReceive);
        jsonObject.addProperty("maxExtract", (Number)this.maxExtract);
        jsonObject.addProperty("maxInputs", (Number)this.maxInputs);
        jsonObject.addProperty("maxOutputs", (Number)this.maxOutputs);
        jsonObject.addProperty("beamEndpointXOffset", (Number)this.beamEndpointXOffset);
        jsonObject.addProperty("beamEndpointYOffset", (Number)this.beamEndpointYOffset);
        jsonObject.addProperty("beamEndpointZOffset", (Number)this.beamEndpointZOffset);
        return jsonObject;
    }

    @Override
    protected String dynamicHoverTips(double progress) {
        return LocalizationUtils.format("multiblocked.gui.trait.impetus.progress", (long)((double)this.capacity * progress), this.capacity);
    }

    @Override
    protected double getProgress() {
        return (double)this.storage.getEnergyStored() * 1.0 / (double)this.capacity;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b("node")) {
            NBTTagCompound impetus = compound.func_74775_l("node");
            this.node.deserializeNBT(impetus);
        }
        this.storage.setEnergyStored(compound.func_74763_f("impetus"));
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagCompound nbt = this.node.serializeNBT();
        nbt.func_74782_a("node", (NBTBase)nbt);
        compound.func_74772_a("impetus", this.storage.getEnergyStored());
    }

    @Override
    public void onLoad() {
        this.node.setLocation(new DimensionalBlockPos(this.component.func_174877_v(), this.component.func_145831_w().field_73011_w.getDimension()));
        this.node.init(this.component.func_145831_w());
        ThaumicAugmentation.proxy.registerRenderableImpetusNode((IImpetusNode)this.node);
    }

    @Override
    public void onChunkUnload() {
        this.node.unload();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode((IImpetusNode)this.node);
    }

    @Override
    public boolean receiveClientEvent(int id, int type) {
        World world = this.component.func_145831_w();
        BlockPos pos = this.component.func_174877_v();
        ThaumicAugmentation.proxy.getRenderHelper().renderSpark(world, (double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)((float)pos.func_177956_o() + world.field_73012_v.nextFloat()), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat()), 1.5f, Aspect.ELDRITCH.getColor(), false);
        return true;
    }

    @Override
    public void invalidate() {
        if (this.component.func_145831_w().field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode((IImpetusNode)this.node);
        }
        this.node.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode((IImpetusNode)this.node);
    }

    @Override
    public void receiveCustomData(int id, PacketBuffer buffer) {
        if (id == 0) {
            this.storage.setEnergyStored(buffer.readLong());
        }
    }

    @Override
    public void update() {
        if (this.capabilityIO != IO.OUT) {
            ConsumeResult result = this.node.consume(Math.min((long)this.maxReceive, this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()), false);
            if (result.energyConsumed != 0L) {
                this.writeCustomData(0, buffer -> buffer.writeLong(this.storage.getEnergyStored()));
                this.component.markAsDirty();
            }
        }
    }

    @Override
    public boolean hasUpdate() {
        return true;
    }

    @Override
    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot) {
        super.initSettingDialog(dialog, slot);
        dialog.addWidget(new TextFieldWidget(60, 25, 100, 15, true, null, s -> {
            this.capacity = Integer.parseInt(s);
            this.updateSettings();
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(this.capacity + "").setHoverTooltip("multiblocked.gui.trait.impetus.tips.0"));
        dialog.addWidget(new TextFieldWidget(60, 45, 100, 15, true, null, s -> {
            this.maxReceive = Integer.parseInt(s);
            this.updateSettings();
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(this.maxReceive + "").setHoverTooltip("multiblocked.gui.trait.impetus.tips.1"));
        dialog.addWidget(new TextFieldWidget(60, 65, 100, 15, true, null, s -> {
            this.maxExtract = Integer.parseInt(s);
            this.updateSettings();
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(this.maxExtract + "").setHoverTooltip("multiblocked.gui.trait.impetus.tips.2"));
        dialog.addWidget(new TextFieldWidget(60, 85, 100, 15, true, null, s -> {
            this.maxInputs = Integer.parseInt(s);
            this.updateSettings();
        }).setNumbersOnly(0, 10).setCurrentString(this.maxInputs + "").setHoverTooltip("multiblocked.gui.trait.impetus.tips.3"));
        dialog.addWidget(new TextFieldWidget(60, 105, 100, 15, true, null, s -> {
            this.maxOutputs = Integer.parseInt(s);
            this.updateSettings();
        }).setNumbersOnly(0, 10).setCurrentString(this.maxOutputs + "").setHoverTooltip("multiblocked.gui.trait.impetus.tips.4"));
        dialog.addWidget(new TextFieldWidget(60, 125, 100, 15, true, null, s -> {
            this.beamEndpointXOffset = Float.parseFloat(s);
            this.updateSettings();
        }).setNumbersOnly(-5.0f, 5.0f).setCurrentString(this.beamEndpointXOffset + "").setHoverTooltip("multiblocked.gui.trait.impetus.tips.5"));
        dialog.addWidget(new TextFieldWidget(60, 145, 100, 15, true, null, s -> {
            this.beamEndpointYOffset = Float.parseFloat(s);
            this.updateSettings();
        }).setNumbersOnly(-5.0f, 5.0f).setCurrentString(this.beamEndpointYOffset + "").setHoverTooltip("multiblocked.gui.trait.impetus.tips.6"));
        dialog.addWidget(new TextFieldWidget(60, 165, 100, 15, true, null, s -> {
            this.beamEndpointZOffset = Float.parseFloat(s);
            this.updateSettings();
        }).setNumbersOnly(-5.0f, 5.0f).setCurrentString(this.beamEndpointZOffset + "").setHoverTooltip("multiblocked.gui.trait.impetus.tips.7"));
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.node);
        }
        if (capability == CapabilityImpetusStorage.IMPETUS_STORAGE) {
            return (T)CapabilityImpetusStorage.IMPETUS_STORAGE.cast((Object)this.storage);
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T getInnerCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityImpetusStorage.IMPETUS_STORAGE ? CapabilityImpetusStorage.IMPETUS_STORAGE.cast((Object)this.storage) : null);
    }

    public void updateSettings() {
        this.storage.updateSettings();
        this.node.updateSettings();
    }

    private class ImpetusNodeProxy
    extends BufferedImpetusProsumer {
        public ImpetusNodeProxy(int totalInputs, int totalOutputs, IImpetusStorage owning) {
            super(totalInputs, totalOutputs, owning);
        }

        void updateSettings() {
            this.maxInputs = ImpetusCapabilityTrait.this.maxInputs;
            this.maxOutputs = ImpetusCapabilityTrait.this.maxOutputs;
        }

        public Vec3d getBeamEndpoint() {
            Vec3d offset = new Vec3d(ImpetusCapabilityTrait.this.beamEndpointXOffset, ImpetusCapabilityTrait.this.beamEndpointYOffset, ImpetusCapabilityTrait.this.beamEndpointZOffset);
            EnumFacing frontFacing = ImpetusCapabilityTrait.this.component.getFrontFacing();
            for (EnumFacing currentFacing = EnumFacing.NORTH; currentFacing != frontFacing; currentFacing = currentFacing.func_176735_f()) {
                offset = ImpetusCapabilityTrait.rotateYCCW(offset);
            }
            return new Vec3d((Vec3i)ImpetusCapabilityTrait.this.component.func_174877_v()).func_178787_e(offset);
        }
    }

    private class ImpetusStorageProxy
    extends ImpetusStorage {
        public ImpetusStorageProxy(long maxEnergy, long maxReceive, long maxExtract) {
            super(maxEnergy, maxReceive, maxExtract);
        }

        void updateSettings() {
            this.maxEnergy = ImpetusCapabilityTrait.this.capacity;
            this.maxExtract = ImpetusCapabilityTrait.this.maxExtract;
            this.maxReceive = ImpetusCapabilityTrait.this.maxReceive;
        }

        void setEnergyStored(long energy) {
            this.energy = energy;
        }
    }
}

