/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.trait;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.trait.MultiCapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.GuiTextureGroup;
import com.cleanroommc.multiblocked.api.gui.texture.ProgressTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.GuiUtils;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SelectorWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TankWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs.ResourceTextureWidget;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.common.capability.FluidMultiblockCapability;
import com.cleanroommc.multiblocked.util.JsonUtil;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.Size;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.apache.commons.lang3.ArrayUtils;

public class FluidCapabilityTrait
extends MultiCapabilityTrait {
    private static final String EMPTY_TEX = "multiblocked:textures/void.png";
    private FluidTankList handler;
    private int[] tankCapability;
    private FluidStack[][] validFluids;
    protected int[] width;
    protected int[] height;
    protected String[] texture;
    protected ProgressTexture.FillDirection[] fillDirection;

    public FluidCapabilityTrait() {
        super(FluidMultiblockCapability.CAP);
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        super.serialize(jsonElement);
        if (jsonElement == null) {
            jsonElement = new JsonArray();
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        int size = jsonArray.size();
        this.tankCapability = new int[size];
        this.width = new int[size];
        this.height = new int[size];
        this.texture = new String[size];
        this.fillDirection = new ProgressTexture.FillDirection[size];
        this.validFluids = new FluidStack[size][];
        int i = 0;
        for (JsonElement element : jsonArray) {
            JsonObject jsonObject = element.getAsJsonObject();
            this.tankCapability[i] = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"tC", (int)1000);
            this.width[i] = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"w", (int)18);
            this.height[i] = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"h", (int)18);
            this.texture[i] = JsonUtils.func_151219_a((JsonObject)jsonObject, (String)"tex", (String)EMPTY_TEX);
            this.fillDirection[i] = JsonUtil.getEnumOr(jsonObject, "fillDir", ProgressTexture.FillDirection.class, ProgressTexture.FillDirection.ALWAYS_FULL);
            if (jsonObject.has("valid")) {
                this.validFluids[i] = new FluidStack[0];
                for (JsonElement fluid : jsonObject.get("valid").getAsJsonArray()) {
                    this.validFluids[i] = (FluidStack[])ArrayUtils.add((Object[])this.validFluids[i], (Object)Multiblocked.GSON.fromJson(fluid.getAsString(), FluidStack.class));
                }
            }
            ++i;
        }
        FluidTank[] fluidTanks = new FluidTank[this.tankCapability.length];
        for (int j = 0; j < this.tankCapability.length; ++j) {
            final FluidStack[] fluids = this.validFluids[j];
            fluidTanks[j] = new FluidTank(this.tankCapability[j]){

                public boolean canFillFluidType(FluidStack fluid) {
                    if (fluids != null) {
                        for (FluidStack fluidStack : fluids) {
                            if (!fluidStack.isFluidEqual(fluid)) continue;
                            return super.canFillFluidType(fluid);
                        }
                        return false;
                    }
                    return super.canFillFluidType(fluid);
                }

                public boolean canDrainFluidType(@Nullable FluidStack fluid) {
                    if (fluids != null) {
                        for (FluidStack fluidStack : fluids) {
                            if (!fluidStack.isFluidEqual(fluid)) continue;
                            return super.canDrainFluidType(fluid);
                        }
                        return false;
                    }
                    return super.canDrainFluidType(fluid);
                }
            };
        }
        this.handler = new FluidTankList(this.capabilityIO, Arrays.asList(fluidTanks), this.slotName, null);
    }

    @Override
    public JsonElement deserialize() {
        JsonArray jsonArray = super.deserialize().getAsJsonArray();
        for (int i = 0; i < this.capabilityIO.length; ++i) {
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            jsonObject.addProperty("tC", (Number)this.tankCapability[i]);
            jsonObject.addProperty("w", (Number)this.width[i]);
            jsonObject.addProperty("h", (Number)this.height[i]);
            if (!this.texture[i].equals(EMPTY_TEX)) {
                jsonObject.addProperty("tex", this.texture[i]);
            }
            jsonObject.addProperty("fillDir", this.fillDirection[i].name());
            if (this.validFluids[i] == null) continue;
            JsonArray fluids = new JsonArray();
            for (FluidStack fluid : this.validFluids[i]) {
                fluids.add(Multiblocked.GSON.toJson((Object)fluid));
            }
            jsonObject.add("valid", (JsonElement)fluids);
        }
        return jsonArray;
    }

    @Override
    public boolean hasUpdate() {
        return ArrayUtils.contains((boolean[])this.autoIO, (boolean)true);
    }

    @Override
    public void update() {
        for (int i = 0; i < this.autoIO.length; ++i) {
            FluidStack fluidStack;
            FluidTank already;
            if (!this.autoIO[i]) continue;
            if (this.capabilityIO[i] == IO.IN) {
                already = this.handler.getTankAt(i);
                fluidStack = already.getFluid();
                int need = already.getCapacity() - already.getFluidAmount();
                if (need <= 0) continue;
                EnumFacing[] enumFacingArray = this.getIOFacing();
                int n = enumFacingArray.length;
                for (int j = 0; j < n; ++j) {
                    IFluidHandler handler;
                    EnumFacing facing = enumFacingArray[j];
                    TileEntity te = this.component.func_145831_w().func_175625_s(this.component.func_174877_v().func_177972_a(facing));
                    if (te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()) || (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) == null || !(fluidStack != null ? already.fill(handler.drain(new FluidStack(fluidStack.getFluid(), need), true), true) > 0 : already.fill(handler.drain(need, true), true) > 0)) continue;
                    return;
                }
                continue;
            }
            if (this.capabilityIO[i] != IO.OUT || (fluidStack = (already = this.handler.getTankAt(i)).getFluid()) == null || already.getFluidAmount() <= 0) continue;
            for (EnumFacing facing : this.getIOFacing()) {
                IFluidHandler handler;
                TileEntity te = this.component.func_145831_w().func_175625_s(this.component.func_174877_v().func_177972_a(facing));
                if (te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()) || (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) == null || already.drain(handler.fill(fluidStack.copy(), true), true) == null) continue;
                return;
            }
        }
        super.update();
    }

    @Override
    protected void refreshSlots(DraggableScrollableWidgetGroup dragGroup) {
        dragGroup.widgets.forEach(dragGroup::waitToRemoved);
        int i = 0;
        while (i < this.guiIO.length) {
            int finalI = i++;
            ButtonWidget setting = (ButtonWidget)new ButtonWidget(this.width[finalI] - 8, 0, 8, 8, new ResourceTexture("multiblocked:textures/gui/option.png"), null).setHoverBorderTexture(1, -1).setHoverTooltip("multiblocked.gui.tips.settings");
            ImageWidget imageWidget = new ImageWidget(0, 0, this.width[finalI], this.height[finalI], new GuiTextureGroup(this.createAutoProgressTexture(finalI), new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO[finalI]))));
            setting.setVisible(false);
            DraggableWidgetGroup slot = new DraggableWidgetGroup(this.x[finalI], this.y[finalI], this.width[finalI], this.height[finalI]);
            slot.setOnSelected(w -> setting.setVisible(true));
            slot.setOnUnSelected(w -> setting.setVisible(false));
            slot.addWidget(imageWidget);
            slot.addWidget(setting);
            slot.setOnEndDrag(b -> {
                this.x[finalI] = b.getSelfPosition().x;
                this.y[finalI] = b.getSelfPosition().y;
            });
            dragGroup.addWidget(slot);
            setting.setOnPressCallback(cd2 -> {
                DialogWidget dialog = new DialogWidget(dragGroup, true);
                dialog.addWidget(new ImageWidget(0, 0, 176, 256, new ColorRectTexture(-1358954496)));
                dialog.addWidget(new ButtonWidget(5, 5, 85, 20, new GuiTextureGroup(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("multiblocked.gui.trait.remove_slot")), cd3 -> {
                    this.removeSlot(finalI);
                    this.refreshSlots(dragGroup);
                    dialog.close();
                }).setHoverBorderTexture(1, -1));
                this.initSettingDialog(dialog, slot, finalI);
            });
        }
    }

    @Override
    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot, int index) {
        super.initSettingDialog(dialog, slot, index);
        dialog.addWidget(new LabelWidget(5, 60, "multiblocked.gui.label.tank_capability"));
        dialog.addWidget(new TextFieldWidget(5, 70, 100, 15, true, null, s -> {
            this.tankCapability[index] = Integer.parseInt(s);
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(this.tankCapability[index] + ""));
        WidgetGroup widget = new WidgetGroup(5, 103, 200, 200);
        dialog.addWidget(widget);
        dialog.addWidget(GuiUtils.createBoolSwitch(5, 90, "Fluid Filter", "", this.validFluids[index] != null, result -> {
            if (result.booleanValue()) {
                this.validFluids[index] = new FluidStack[0];
                widget.addWidget(GuiUtils.createFluidStackSelector(dialog, 0, 0, "Valid Fluids", Arrays.stream(this.validFluids[index]).collect(Collectors.toList()), list -> {
                    this.validFluids[index] = list.toArray(new FluidStack[0]);
                }));
            } else {
                widget.clearAllWidgets();
                this.validFluids[index] = null;
            }
        }));
        if (this.validFluids[index] != null) {
            widget.addWidget(GuiUtils.createFluidStackSelector(dialog, 0, 0, "Valid Fluids", Arrays.stream(this.validFluids[index]).collect(Collectors.toList()), list -> {
                this.validFluids[index] = list.toArray(new FluidStack[0]);
            }));
        }
        WidgetGroup group = new WidgetGroup(0, 180, 50, 50);
        dialog.addWidget(group);
        ImageWidget imageWidget = (ImageWidget)slot.widgets.get(0);
        ButtonWidget setting = (ButtonWidget)slot.widgets.get(1);
        ButtonWidget imageSelector = (ButtonWidget)new ButtonWidget(60, 45, this.width[index], this.height[index], new GuiTextureGroup(new ColorBorderTexture(1, -1), this.createAutoProgressTexture(index)), null).setHoverTooltip("multiblocked.gui.tips.select_image");
        group.addWidget(new TextFieldWidget(5, 25, 50, 15, null, s -> {
            this.width[index] = Integer.parseInt(s);
            Size size = new Size(this.width[index], this.height[index]);
            slot.setSize(size);
            imageWidget.setSize(size);
            imageSelector.setSize(size);
            setting.setSelfPosition(new Position(this.width[index] - 8, 0));
        }).setCurrentString(this.width[index] + "").setNumbersOnly(1, 180).setHoverTooltip("multiblocked.gui.trait.set_width"));
        group.addWidget(new TextFieldWidget(5, 45, 50, 15, null, s -> {
            this.height[index] = Integer.parseInt(s);
            Size size = new Size(this.width[index], this.height[index]);
            slot.setSize(size);
            imageWidget.setSize(size);
            imageSelector.setSize(size);
            setting.setSelfPosition(new Position(this.width[index] - 8, 0));
        }).setCurrentString(this.height[index] + "").setNumbersOnly(1, 180).setHoverTooltip("multiblocked.gui.trait.set_height"));
        group.addWidget(imageSelector);
        group.addWidget(new SelectorWidget(60, 25, 90, 15, Arrays.stream(ProgressTexture.FillDirection.values()).map(Enum::name).collect(Collectors.toList()), -1).setIsUp(true).setValue(this.fillDirection[index].name()).setOnChanged(io -> {
            this.fillDirection[index] = ProgressTexture.FillDirection.valueOf(io);
            ResourceTexture autoProgressTexture = this.createAutoProgressTexture(index);
            imageSelector.setButtonTexture(new GuiTextureGroup(new ColorBorderTexture(1, -1), autoProgressTexture));
            imageWidget.setImage(new GuiTextureGroup(autoProgressTexture, new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO[index]))));
        }).setButtonBackground(ResourceBorderTexture.BUTTON_COMMON).setBackground(new ColorRectTexture(-5592406)).setHoverTooltip("multiblocked.gui.trait.fill_direction"));
        imageSelector.setOnPressCallback(cd -> new ResourceTextureWidget((WidgetGroup)dialog.parent.getGui().guiWidgets.get((Object)0), texture1 -> {
            if (texture1 != null) {
                this.texture[index] = texture1.imageLocation.toString();
                ResourceTexture autoProgressTexture = this.createAutoProgressTexture(index);
                imageSelector.setButtonTexture(new GuiTextureGroup(new ColorBorderTexture(1, -1), autoProgressTexture));
                imageWidget.setImage(new GuiTextureGroup(autoProgressTexture, new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO[index]))));
            }
        }));
    }

    @Override
    protected void updateImageWidget(ImageWidget imageWidget, int index) {
        imageWidget.setImage(new GuiTextureGroup(this.createAutoProgressTexture(index), new ColorBorderTexture(1, this.getColorByIO(this.capabilityIO[index]))));
    }

    private ResourceTexture createAutoProgressTexture(int index) {
        return new ResourceTexture(this.texture[index]);
    }

    @Override
    protected void addSlot() {
        super.addSlot();
        this.tankCapability = ArrayUtils.add((int[])this.tankCapability, (int)1000);
        this.validFluids = (FluidStack[][])ArrayUtils.add((Object[])this.validFluids, null);
        this.width = ArrayUtils.add((int[])this.width, (int)18);
        this.height = ArrayUtils.add((int[])this.height, (int)18);
        this.texture = (String[])ArrayUtils.add((Object[])this.texture, (Object)EMPTY_TEX);
        this.fillDirection = (ProgressTexture.FillDirection[])ArrayUtils.add((Object[])this.fillDirection, (Object)((Object)ProgressTexture.FillDirection.ALWAYS_FULL));
    }

    @Override
    protected void removeSlot(int index) {
        super.removeSlot(index);
        this.tankCapability = ArrayUtils.remove((int[])this.tankCapability, (int)index);
        this.validFluids = (FluidStack[][])ArrayUtils.remove((Object[])this.validFluids, (int)index);
        this.width = ArrayUtils.remove((int[])this.width, (int)index);
        this.height = ArrayUtils.remove((int[])this.height, (int)index);
        this.texture = (String[])ArrayUtils.remove((Object[])this.texture, (int)index);
        this.fillDirection = (ProgressTexture.FillDirection[])ArrayUtils.remove((Object[])this.fillDirection, (int)index);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.handler.deserializeNBT(compound.func_74775_l("_"));
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74782_a("_", (NBTBase)this.handler.serializeNBT());
    }

    @Override
    public void createUI(ComponentTileEntity<?> component, WidgetGroup group, EntityPlayer player) {
        super.createUI(component, group, player);
        if (this.handler != null) {
            for (int i = 0; i < this.guiIO.length; ++i) {
                group.addWidget(new TankWidget(new ProxyFluidHandler(this.handler.getTankAt(i), this.guiIO[i]), this.x[i], this.y[i], this.width[i], this.height[i], true, true).setOverlay(new ResourceTexture(this.texture[i])).setFillDirection(this.fillDirection[i]).setShowTips(this.fillDirection[i] == ProgressTexture.FillDirection.ALWAYS_FULL));
            }
        }
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.handler) : null);
    }

    @Override
    @Nullable
    public <T> T getInnerCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing, @Nullable String slotName) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidTankList(this.getRealMbdIO(), this.handler.fluidTanks, this.slotName, slotName)) : null);
    }

    public class FluidTankList
    implements IFluidHandler,
    INBTSerializable<NBTTagCompound> {
        public IO[] cIOs;
        protected final List<FluidTank> fluidTanks;
        private IFluidTankProperties[] fluidTankProperties;
        public String[] slotNames;
        public String slotName;

        private FluidTankList(IO[] cIOs, List<FluidTank> fluidTanks, @Nullable String[] slotNames, String slotName) {
            this.cIOs = cIOs;
            this.fluidTanks = fluidTanks;
            this.slotNames = slotNames;
            this.slotName = slotName;
        }

        public List<FluidTank> getFluidTanks() {
            return Collections.unmodifiableList(this.fluidTanks);
        }

        @Nonnull
        public Iterator<FluidTank> iterator() {
            return this.getFluidTanks().iterator();
        }

        public int getTanks() {
            return this.fluidTanks.size();
        }

        public FluidTank getTankAt(int index) {
            return this.fluidTanks.get(index);
        }

        public IFluidTankProperties[] getTankProperties() {
            if (this.fluidTankProperties == null) {
                ArrayList<IFluidTankProperties> propertiesList = new ArrayList<IFluidTankProperties>();
                for (IFluidTank iFluidTank : this.fluidTanks) {
                    if (!(iFluidTank instanceof IFluidHandler)) continue;
                    IFluidHandler fluidHandler = (IFluidHandler)iFluidTank;
                    propertiesList.addAll(Arrays.asList(fluidHandler.getTankProperties()));
                }
                this.fluidTankProperties = propertiesList.toArray(new IFluidTankProperties[0]);
            }
            return this.fluidTankProperties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null || resource.amount <= 0) {
                return 0;
            }
            if (doFill) {
                FluidCapabilityTrait.this.markAsDirty();
            }
            return this.fillTanksImpl(resource.copy(), doFill);
        }

        private int fillTanksImpl(FluidStack resource, boolean doFill) {
            int filledAmount;
            FluidTank handler;
            IO io;
            int i;
            int totalFilled = 0;
            for (i = 0; i < this.fluidTanks.size(); ++i) {
                io = this.cIOs[i];
                if (io == IO.OUT || this.slotName != null && !this.slotNames[i].equals(this.slotName) || !resource.isFluidEqual((handler = this.fluidTanks.get(i)).getFluid())) continue;
                filledAmount = handler.fill(resource, doFill);
                totalFilled += filledAmount;
                resource.amount -= filledAmount;
                if (resource.amount != 0) continue;
                return totalFilled;
            }
            for (i = 0; i < this.fluidTanks.size(); ++i) {
                io = this.cIOs[i];
                if (io == IO.OUT || this.slotName != null && !this.slotNames[i].equals(this.slotName) || (handler = this.fluidTanks.get(i)).getFluidAmount() != 0) continue;
                filledAmount = handler.fill(resource, doFill);
                totalFilled += filledAmount;
                resource.amount -= filledAmount;
                if (resource.amount != 0) continue;
                return totalFilled;
            }
            return totalFilled;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || resource.amount <= 0) {
                return null;
            }
            if (doDrain) {
                FluidCapabilityTrait.this.markAsDirty();
            }
            resource = resource.copy();
            FluidStack totalDrained = null;
            for (int i = 0; i < this.fluidTanks.size(); ++i) {
                FluidStack drain;
                FluidTank handler;
                IO io = this.cIOs[i];
                if (io == IO.IN || this.slotName != null && !this.slotNames[i].equals(this.slotName) || !resource.isFluidEqual((handler = this.fluidTanks.get(i)).getFluid()) || (drain = handler.drain(resource.amount, doDrain)) == null) continue;
                if (totalDrained == null) {
                    totalDrained = drain;
                } else {
                    totalDrained.amount += drain.amount;
                }
                resource.amount -= drain.amount;
                if (resource.amount == 0) break;
            }
            return totalDrained;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain == 0) {
                return null;
            }
            if (doDrain) {
                FluidCapabilityTrait.this.markAsDirty();
            }
            FluidStack totalDrained = null;
            for (int i = 0; i < this.fluidTanks.size(); ++i) {
                IO io = this.cIOs[i];
                if (io == IO.IN || this.slotName != null && !this.slotNames[i].equals(this.slotName)) continue;
                FluidTank handler = this.fluidTanks.get(i);
                if (totalDrained == null) {
                    totalDrained = handler.drain(maxDrain, doDrain);
                    if (totalDrained != null) {
                        maxDrain -= totalDrained.amount;
                    }
                } else {
                    FluidStack copy = totalDrained.copy();
                    copy.amount = maxDrain;
                    if (!copy.isFluidEqual(handler.getFluid())) continue;
                    FluidStack drain = handler.drain(copy.amount, doDrain);
                    if (drain != null) {
                        totalDrained.amount += drain.amount;
                        maxDrain -= drain.amount;
                    }
                }
                if (maxDrain <= 0) break;
            }
            return totalDrained;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound fluidInventory = new NBTTagCompound();
            fluidInventory.func_74768_a("TankAmount", this.getTanks());
            NBTTagList tanks = new NBTTagList();
            for (int i = 0; i < this.getTanks(); ++i) {
                FluidTank fluidTank = this.fluidTanks.get(i);
                NBTTagCompound writeTag = fluidTank != null ? fluidTank.writeToNBT(new NBTTagCompound()) : new NBTTagCompound();
                tanks.func_74742_a((NBTBase)writeTag);
            }
            fluidInventory.func_74782_a("Tanks", (NBTBase)tanks);
            return fluidInventory;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            NBTTagList tanks = nbt.func_150295_c("Tanks", 10);
            for (int i = 0; i < Math.min(this.fluidTanks.size(), nbt.func_74762_e("TankAmount")); ++i) {
                NBTBase nbtTag = tanks.func_179238_g(i);
                FluidTank fluidTank = this.fluidTanks.get(i);
                if (fluidTank == null) continue;
                fluidTank.readFromNBT((NBTTagCompound)nbtTag);
            }
        }
    }

    private class ProxyFluidHandler
    implements IFluidTank,
    IFluidHandler {
        public FluidTank proxy;
        public IO io;

        public ProxyFluidHandler(FluidTank proxy, IO io) {
            this.proxy = proxy;
            this.io = io;
        }

        @Nullable
        public FluidStack getFluid() {
            return this.proxy.getFluid();
        }

        public int getFluidAmount() {
            return this.proxy.getFluidAmount();
        }

        public int getCapacity() {
            return this.proxy.getCapacity();
        }

        public FluidTankInfo getInfo() {
            return this.proxy.getInfo();
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.proxy.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.io == IO.OUT) {
                return 0;
            }
            FluidCapabilityTrait.this.markAsDirty();
            return this.proxy.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.proxy.drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.io == IO.IN) {
                return null;
            }
            FluidCapabilityTrait.this.markAsDirty();
            return this.proxy.drain(maxDrain, doDrain);
        }
    }
}

