/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.trait;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.trait.ProgressCapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.common.capability.FEMultiblockCapability;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class FECapabilityTrait
extends ProgressCapabilityTrait {
    private EnergyStorage handler;
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public FECapabilityTrait() {
        super(FEMultiblockCapability.CAP);
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        super.serialize(jsonElement);
        if (jsonElement == null) {
            jsonElement = new JsonObject();
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        this.capacity = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"capacity", (int)10000);
        this.maxReceive = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"maxReceive", (int)500);
        this.maxExtract = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"maxExtract", (int)500);
        this.handler = new EnergyStorage(this.capacity, this.maxReceive, this.maxExtract);
    }

    @Override
    public JsonElement deserialize() {
        JsonObject jsonObject = super.deserialize().getAsJsonObject();
        jsonObject.addProperty("capacity", (Number)this.capacity);
        jsonObject.addProperty("maxReceive", (Number)this.maxReceive);
        jsonObject.addProperty("maxExtract", (Number)this.maxExtract);
        return jsonObject;
    }

    @Override
    protected String dynamicHoverTips(double progress) {
        return LocalizationUtils.format("multiblocked.gui.trait.fe.progress", (int)((double)this.handler.getMaxEnergyStored() * progress), this.handler.getMaxEnergyStored());
    }

    @Override
    protected double getProgress() {
        return (float)this.handler.getEnergyStored() * 1.0f / (float)this.handler.getMaxEnergyStored();
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b("_")) {
            this.handler = new EnergyStorage(this.capacity, this.maxReceive, this.maxExtract, Math.min(compound.func_74762_e("_"), this.capacity));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("_", this.handler.getEnergyStored());
    }

    @Override
    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot) {
        super.initSettingDialog(dialog, slot);
        dialog.addWidget(new TextFieldWidget(60, 5, 100, 15, true, null, s -> {
            this.capacity = Integer.parseInt(s);
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(this.capacity + "").setHoverTooltip("multiblocked.gui.trait.fe.tips.0"));
        dialog.addWidget(new TextFieldWidget(60, 25, 100, 15, true, null, s -> {
            this.maxReceive = Integer.parseInt(s);
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(this.maxReceive + "").setHoverTooltip("multiblocked.gui.trait.fe.tips.1"));
        dialog.addWidget(new TextFieldWidget(60, 45, 100, 15, true, null, s -> {
            this.maxExtract = Integer.parseInt(s);
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(this.maxExtract + "").setHoverTooltip("multiblocked.gui.trait.fe.tips.2"));
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)new ProxyEnergyStorage(this.handler, this.capabilityIO)) : null);
    }

    @Override
    @Nullable
    public <T> T getInnerCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)new ProxyEnergyStorage(this.handler, this.guiIO)) : null);
    }

    private class ProxyEnergyStorage
    implements IEnergyStorage {
        public EnergyStorage proxy;
        public IO io;

        public ProxyEnergyStorage(EnergyStorage proxy, IO io) {
            this.proxy = proxy;
            this.io = io;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.io == IO.BOTH || this.io == IO.IN) {
                if (!simulate) {
                    FECapabilityTrait.this.markAsDirty();
                }
                return this.proxy.receiveEnergy(maxReceive, simulate);
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (this.io == IO.BOTH || this.io == IO.OUT) {
                if (!simulate) {
                    FECapabilityTrait.this.markAsDirty();
                }
                return this.proxy.extractEnergy(maxExtract, simulate);
            }
            return 0;
        }

        public int getEnergyStored() {
            return this.proxy.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return this.proxy.getMaxEnergyStored();
        }

        public boolean canExtract() {
            if (this.io == IO.BOTH || this.io == IO.OUT) {
                return this.proxy.canExtract();
            }
            return false;
        }

        public boolean canReceive() {
            if (this.io == IO.BOTH || this.io == IO.IN) {
                return this.proxy.canReceive();
            }
            return false;
        }
    }
}

