/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability.trait;

import com.cleanroommc.multiblocked.api.block.CustomProperties;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.trait.ProgressCapabilityTrait;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.common.capability.EnergyGTCECapability;
import com.cleanroommc.multiblocked.util.LocalizationUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.capabilities.Capability;

public class EnergyCapabilityTrait
extends ProgressCapabilityTrait {
    private EnergyContainerHandler handler;
    protected int capacity;

    public EnergyCapabilityTrait() {
        super(EnergyGTCECapability.CAP);
    }

    @Override
    public void serialize(@Nullable JsonElement jsonElement) {
        super.serialize(jsonElement);
        if (jsonElement == null) {
            jsonElement = new JsonObject();
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        this.capacity = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"capacity", (int)10000);
        this.handler = new EnergyContainerHandler(this.capacity);
    }

    @Override
    public JsonElement deserialize() {
        JsonObject jsonObject = super.deserialize().getAsJsonObject();
        jsonObject.addProperty("capacity", (Number)this.capacity);
        return jsonObject;
    }

    @Override
    protected String dynamicHoverTips(double progress) {
        return LocalizationUtils.format("multiblocked.gui.trait.energy.progress", (int)((double)this.handler.getEnergyCapacity() * progress), this.handler.getEnergyCapacity());
    }

    @Override
    protected double getProgress() {
        return (float)this.handler.getEnergyStored() * 1.0f / (float)this.handler.getEnergyCapacity();
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b("_")) {
            this.handler.deserializeNBT(compound.func_74775_l("_"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74782_a("_", (NBTBase)this.handler.serializeNBT());
    }

    @Override
    protected void initSettingDialog(DialogWidget dialog, DraggableWidgetGroup slot) {
        super.initSettingDialog(dialog, slot);
        dialog.addWidget(new TextFieldWidget(60, 5, 100, 15, true, null, s -> {
            this.capacity = Integer.parseInt(s);
        }).setNumbersOnly(1, Integer.MAX_VALUE).setCurrentString(this.capacity + "").setHoverTooltip("multiblocked.gui.trait.energy.tips"));
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER ? GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)new ProxyEnergyStorage(this.handler, this.capabilityIO)) : null);
    }

    @Override
    @Nullable
    public <T> T getInnerCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER ? GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)new ProxyEnergyStorage(this.handler, this.guiIO)) : null);
    }

    @Override
    public boolean hasUpdate() {
        return true;
    }

    @Override
    public void update() {
        this.handler.update();
    }

    public class EnergyContainerHandler
    implements IEnergyContainer {
        protected final long maxCapacity;
        protected long energyStored;
        protected long amps = 0L;

        public EnergyContainerHandler(long maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74772_a("EnergyStored", this.energyStored);
            return compound;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            this.energyStored = compound.func_74763_f("EnergyStored");
        }

        public long getEnergyStored() {
            return this.energyStored;
        }

        public void setEnergyStored(long energyStored) {
            this.energyStored = energyStored;
            EnergyCapabilityTrait.this.markAsDirty();
        }

        public void update() {
            if (((EnergyCapabilityTrait)EnergyCapabilityTrait.this).component.func_145831_w().field_72995_K || EnergyCapabilityTrait.this.capabilityIO == IO.IN) {
                return;
            }
            long energyUsed = 0L;
            this.amps = 0L;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (!this.outputsEnergy(side)) continue;
                TileEntity tileEntity = EnergyCapabilityTrait.this.component.func_145831_w().func_175625_s(EnergyCapabilityTrait.this.component.func_174877_v().func_177972_a(side));
                EnumFacing oppositeSide = side.func_176734_d();
                if (tileEntity == null || !tileEntity.hasCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, oppositeSide)) continue;
                IEnergyContainer energyContainer = (IEnergyContainer)tileEntity.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, oppositeSide);
                if (energyContainer != null && energyContainer.inputsEnergy(oppositeSide)) {
                    long outputV = energyContainer.getInputVoltage();
                    if (outputV > this.getEnergyStored() - energyUsed) continue;
                    energyUsed += energyContainer.acceptEnergyFromNetwork(oppositeSide, outputV, 1L) * energyContainer.getInputVoltage();
                }
                if (energyUsed >= this.getEnergyStored()) break;
            }
            if (energyUsed > 0L) {
                this.setEnergyStored(this.getEnergyStored() - energyUsed);
            }
        }

        public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
            long amperesAccepted;
            if (this.amps >= this.getInputAmperage()) {
                return 0L;
            }
            long canAccept = this.getEnergyCapacity() - this.getEnergyStored();
            if (voltage > 0L && (side == null || this.inputsEnergy(side)) && canAccept >= voltage && (amperesAccepted = Math.min(canAccept / voltage, amperage)) > 0L) {
                this.setEnergyStored(this.getEnergyStored() + voltage * amperesAccepted);
                this.amps += amperesAccepted;
                return amperesAccepted;
            }
            return 0L;
        }

        public long getEnergyCapacity() {
            return this.maxCapacity;
        }

        public boolean inputsEnergy(EnumFacing side) {
            return true;
        }

        public boolean outputsEnergy(EnumFacing side) {
            return EnergyCapabilityTrait.this.component.getFrontFacing() == side || ((ComponentDefinition)((EnergyCapabilityTrait)EnergyCapabilityTrait.this).component.getDefinition()).properties.rotationState == CustomProperties.RotationState.NONE;
        }

        public long changeEnergy(long energyToAdd) {
            long newEnergyStored;
            long oldEnergyStored = this.getEnergyStored();
            long l = newEnergyStored = this.maxCapacity - oldEnergyStored < energyToAdd ? this.maxCapacity : oldEnergyStored + energyToAdd;
            if (newEnergyStored < 0L) {
                newEnergyStored = 0L;
            }
            this.setEnergyStored(newEnergyStored);
            return newEnergyStored - oldEnergyStored;
        }

        public long getOutputVoltage() {
            return 0L;
        }

        public long getOutputAmperage() {
            return 0L;
        }

        public long getInputAmperage() {
            return Long.MAX_VALUE;
        }

        public long getInputVoltage() {
            return Long.MAX_VALUE;
        }
    }

    private static class ProxyEnergyStorage
    implements IEnergyContainer {
        public EnergyContainerHandler proxy;
        public IO io;

        public ProxyEnergyStorage(EnergyContainerHandler proxy, IO io) {
            this.proxy = proxy;
            this.io = io;
        }

        public long acceptEnergyFromNetwork(EnumFacing enumFacing, long l, long l1) {
            if (this.io == IO.BOTH || this.io == IO.IN) {
                return this.proxy.acceptEnergyFromNetwork(enumFacing, l, l1);
            }
            return 0L;
        }

        public boolean inputsEnergy(EnumFacing enumFacing) {
            if (this.io == IO.BOTH || this.io == IO.IN) {
                return this.proxy.inputsEnergy(enumFacing);
            }
            return false;
        }

        public boolean outputsEnergy(EnumFacing side) {
            if (this.io == IO.BOTH || this.io == IO.OUT) {
                return this.proxy.outputsEnergy(side);
            }
            return false;
        }

        public long changeEnergy(long l) {
            if (l > 0L ? this.io == IO.BOTH || this.io == IO.IN : this.io == IO.BOTH || this.io == IO.OUT) {
                return this.proxy.changeEnergy(l);
            }
            return 0L;
        }

        public long getEnergyStored() {
            return this.proxy.getEnergyStored();
        }

        public long getEnergyCapacity() {
            return this.proxy.getEnergyCapacity();
        }

        public long getInputAmperage() {
            return this.proxy.getInputAmperage();
        }

        public long getInputVoltage() {
            return this.proxy.getInputVoltage();
        }
    }
}

