/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.trait.StarlightCapabilityTrait;
import com.cleanroommc.multiblocked.common.capability.widget.StarlightWidget;
import com.cleanroommc.multiblocked.common.recipe.content.Starlight;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import hellfirepvp.astralsorcery.common.auxiliary.link.ILinkableTile;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.starlight.IStarlightReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionClassRegistry;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JsonUtils;

public class StarlightAstralCapability
extends MultiblockCapability<Starlight> {
    public static final StarlightAstralCapability CAP = new StarlightAstralCapability();

    protected StarlightAstralCapability() {
        super("starlight_as", new Color(11317425).getRGB());
        TransmissionClassRegistry.register((TransmissionClassRegistry.TransmissionProvider)new StarlightCapabilityTrait.MultiblockedTransmissionProvider());
    }

    @Override
    public Starlight defaultContent() {
        return new Starlight(800, null);
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return tileEntity instanceof ILinkableStarlightReceiver;
    }

    @Override
    public Starlight copyInner(Starlight content) {
        return content.copy();
    }

    @Override
    public Starlight copyInnerByModifier(Starlight content, ContentModifier modifier) {
        return new Starlight((int)modifier.apply(content.getValue()), content.getConstellation());
    }

    @Override
    public CapabilityProxy<? extends Starlight> createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new StarlightAstralProxy(tileEntity);
    }

    @Override
    public boolean hasTrait() {
        return true;
    }

    @Override
    public CapabilityTrait createTrait() {
        return new StarlightCapabilityTrait();
    }

    @Override
    public ContentWidget<? super Starlight> createContentWidget() {
        return new StarlightWidget();
    }

    public Starlight deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        int starlight = JsonUtils.func_151203_m((JsonObject)jsonObject, (String)"starlight");
        JsonElement constellationJson = jsonObject.get("constellation");
        IConstellation constellation = constellationJson == null || constellationJson.isJsonNull() ? null : ConstellationRegistry.getConstellationByName((String)constellationJson.getAsString());
        return new Starlight(starlight, constellation);
    }

    public JsonElement serialize(Starlight src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("starlight", (Number)src.getValue());
        jsonObject.addProperty("constellation", src.getConstellation() == null ? null : src.getConstellation().getUnlocalizedName());
        return jsonObject;
    }

    public static interface ILinkableStarlightReceiver
    extends ILinkableTile,
    IStarlightReceiver {
        public int getStarlightStored();

        public void setStarlightStored(int var1);

        public int getStarlightCapacity();

        public IConstellation getFocusedConstellation();

        public void setFocusedConstellation(IConstellation var1);
    }

    public static class StarlightAstralProxy
    extends CapabilityProxy<Starlight> {
        IConstellation lastConstellation;
        int lastStarlight;

        public StarlightAstralProxy(TileEntity tileEntity) {
            super(CAP, tileEntity);
        }

        public ILinkableStarlightReceiver getCapability() {
            return (ILinkableStarlightReceiver)this.getTileEntity();
        }

        public boolean matchConstellation(Starlight starlight) {
            IConstellation constellation = starlight.getConstellation();
            return constellation == null || constellation.equals(this.getCapability().getFocusedConstellation());
        }

        @Override
        protected List<Starlight> handleRecipeInner(IO io, Recipe recipe, List<Starlight> left, @Nullable String slotName, boolean simulate) {
            ILinkableStarlightReceiver tileEntity = (ILinkableStarlightReceiver)this.getTileEntity();
            int sum = left.stream().filter(this::matchConstellation).mapToInt(Starlight::getValue).sum();
            boolean accepted = false;
            switch (io) {
                case IN: {
                    if (tileEntity.getStarlightStored() < sum) break;
                    if (!simulate) {
                        tileEntity.setStarlightStored(tileEntity.getStarlightStored() - sum);
                    }
                    accepted = true;
                    break;
                }
                case OUT: {
                    if (tileEntity.getStarlightStored() + sum > tileEntity.getStarlightCapacity()) break;
                    if (!simulate) {
                        tileEntity.setStarlightStored(tileEntity.getStarlightStored() + sum);
                    }
                    accepted = true;
                }
            }
            if (accepted) {
                left.removeIf(this::matchConstellation);
            }
            return left.isEmpty() ? null : left;
        }

        @Override
        protected boolean hasInnerChanged() {
            ILinkableStarlightReceiver capability = this.getCapability();
            if (capability == null) {
                return false;
            }
            if (this.lastStarlight != capability.getStarlightStored() || this.lastConstellation != capability.getFocusedConstellation()) {
                this.lastStarlight = capability.getStarlightStored();
                this.lastConstellation = capability.getFocusedConstellation();
                return true;
            }
            return false;
        }
    }
}

