/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.trait.PneumaticMachineTrait;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IPneumaticMachine;
import me.desht.pneumaticcraft.common.block.Blockss;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class PneumaticPressureCapability
extends MultiblockCapability<Float> {
    public static final PneumaticPressureCapability CAP = new PneumaticPressureCapability();

    protected PneumaticPressureCapability() {
        super("pneumatic_pressure", new Color(16727040).getRGB());
    }

    @Override
    public Float defaultContent() {
        return Float.valueOf(2.0f);
    }

    @Override
    public Float copyInner(Float content) {
        return content;
    }

    @Override
    public Float copyInnerByModifier(Float content, ContentModifier modifier) {
        return Float.valueOf((float)modifier.apply(content.floatValue()));
    }

    @Override
    public CapabilityProxy<? extends Float> createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new Proxy(tileEntity);
    }

    public Float deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return Float.valueOf(json.getAsFloat());
    }

    public JsonElement serialize(Float src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)src);
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return tileEntity instanceof IPneumaticMachine;
    }

    @Override
    public BlockInfo[] getCandidates() {
        return new BlockInfo[]{new BlockInfo(Blockss.AIR_COMPRESSOR), new BlockInfo(Blockss.LIQUID_COMPRESSOR), new BlockInfo(Blockss.ADVANCED_AIR_COMPRESSOR), new BlockInfo(Blockss.ADVANCED_LIQUID_COMPRESSOR), new BlockInfo(Blockss.CREATIVE_COMPRESSOR)};
    }

    @Override
    public boolean hasTrait() {
        return true;
    }

    @Override
    public ContentWidget<? super Float> createContentWidget() {
        return new NumberContentWidget().setContentTexture(new TextTexture("P", this.color)).setUnit("bar");
    }

    @Override
    public CapabilityTrait createTrait() {
        return new PneumaticMachineTrait();
    }

    private static class Proxy
    extends CapabilityProxy<Float> {
        int air;
        int volume;

        public Proxy(TileEntity tileEntity) {
            super(CAP, tileEntity);
        }

        public IAirHandler getAirHandler() {
            IPneumaticMachine machine = (IPneumaticMachine)this.getTileEntity();
            if (machine != null) {
                for (EnumFacing value : EnumFacing.values()) {
                    IAirHandler airHandler = machine.getAirHandler(value);
                    if (airHandler == null) continue;
                    return airHandler;
                }
            }
            return null;
        }

        @Override
        protected boolean hasInnerChanged() {
            IAirHandler airHandler = this.getAirHandler();
            if (airHandler == null) {
                return false;
            }
            if (airHandler.getAir() == this.air && airHandler.getVolume() == this.volume) {
                return false;
            }
            this.air = airHandler.getAir();
            this.volume = airHandler.getVolume();
            return true;
        }

        @Override
        protected List<Float> handleRecipeInner(IO io, Recipe recipe, List<Float> left, @Nullable String slotName, boolean simulate) {
            int air;
            IAirHandler handler = this.getAirHandler();
            float sum = left.stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue();
            int consumeAir = (int)(sum * 50.0f);
            if (handler != null && io == IO.IN && Math.signum(air = handler.getAir()) == Math.signum(consumeAir) && Math.abs(air) >= Math.abs(consumeAir) && Math.abs(handler.getPressure()) >= Math.abs(sum)) {
                if (!simulate) {
                    handler.addAir(-consumeAir);
                }
                return null;
            }
            return left;
        }
    }
}

