/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.widget.ParticleStackWidget;
import com.cleanroommc.multiblocked.jei.IJeiIngredientAdapter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.block.QMDBlocks;
import lach_01298.qmd.jei.ingredient.ParticleType;
import lach_01298.qmd.particle.ITileParticleStorage;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.particle.ParticleStorage;
import lach_01298.qmd.particle.Particles;
import mezz.jei.api.recipe.IIngredientType;
import net.minecraft.tileentity.TileEntity;

public class ParticleQMDCapability
extends MultiblockCapability<ParticleStack> {
    public static final ParticleQMDCapability CAP = new ParticleQMDCapability();

    private ParticleQMDCapability() {
        super("qmd_particle", new Color(-841638468, true).getRGB(), new ParticleJeiAdapter());
    }

    @Override
    public ParticleStack defaultContent() {
        return new ParticleStack(Particles.antidown);
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return tileEntity instanceof ITileParticleStorage;
    }

    public ParticleQMDCapabilityProxy createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new ParticleQMDCapabilityProxy(tileEntity);
    }

    @Override
    public ParticleStack copyInner(ParticleStack content) {
        return content.copy();
    }

    @Override
    public ParticleStack copyInnerByModifier(ParticleStack content, ContentModifier modifier) {
        ParticleStack copy = content.copy();
        copy.setAmount((int)modifier.apply(content.getAmount()));
        return copy;
    }

    @Override
    public ContentWidget<ParticleStack> createContentWidget() {
        return new ParticleStackWidget();
    }

    @Override
    public BlockInfo[] getCandidates() {
        return new BlockInfo[]{BlockInfo.fromBlockState(QMDBlocks.acceleratorBeamPort.func_176223_P()), BlockInfo.fromBlockState(QMDBlocks.acceleratorSynchrotronPort.func_176223_P()), BlockInfo.fromBlockState(QMDBlocks.beamline.func_176223_P()), BlockInfo.fromBlockState(QMDBlocks.particleChamberBeamPort.func_176223_P())};
    }

    public ParticleStack deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        return new ParticleStack(Particles.getParticleFromName((String)jsonObj.get("particle").getAsString()), jsonObj.get("amount").getAsInt(), jsonObj.get("energy").getAsLong(), jsonObj.get("focus").getAsDouble());
    }

    public JsonElement serialize(ParticleStack particleStack, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("particle", particleStack.getParticle().getName());
        jsonObj.addProperty("amount", (Number)particleStack.getAmount());
        jsonObj.addProperty("focus", (Number)particleStack.getFocus());
        jsonObj.addProperty("energy", (Number)particleStack.getMeanEnergy());
        return jsonObj;
    }

    public static class ParticleJeiAdapter
    implements IJeiIngredientAdapter<ParticleStack, ParticleStack> {
        @Override
        public Class<ParticleStack> getInternalIngredientType() {
            return ParticleStack.class;
        }

        @Override
        public IIngredientType<ParticleStack> getJeiIngredientType() {
            return ParticleType.Particle;
        }

        @Override
        public Stream<ParticleStack> apply(ParticleStack particleStack) {
            return Stream.of(particleStack);
        }
    }

    public static class ParticleQMDCapabilityProxy
    extends CapabilityProxy<ParticleStack> {
        ParticleStack[] lastStacks = new ParticleStack[0];
        long[] lastMaxEnergy = new long[0];
        long[] lastMinEnergy = new long[0];
        int[] lastCapacity = new int[0];

        public ParticleQMDCapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity);
        }

        public ITileParticleStorage getCapability() {
            return (ITileParticleStorage)this.getTileEntity();
        }

        @Override
        protected List<ParticleStack> handleRecipeInner(IO io, Recipe recipe, List<ParticleStack> left, @Nullable String slotName, boolean simulate) {
            block8: {
                Iterator<ParticleStack> iterator;
                ITileParticleStorage capability;
                block7: {
                    capability = this.getCapability();
                    if (capability == null) {
                        return left;
                    }
                    iterator = left.iterator();
                    if (io != IO.IN) break block7;
                    block0: while (iterator.hasNext()) {
                        ParticleStack particleStack = iterator.next();
                        for (ParticleStorage storage : capability.getParticleBeams()) {
                            ParticleStack stored = storage.getParticleStack();
                            if (stored == null || !storage.canExtractParticle(null) || stored.getParticle() != particleStack.getParticle() || stored.getMeanEnergy() < particleStack.getMeanEnergy()) continue;
                            int leftAmount = particleStack.getAmount() - stored.getAmount();
                            if (!simulate) {
                                storage.extractParticle(null, particleStack.getParticle(), particleStack.getAmount());
                            }
                            particleStack.setAmount(leftAmount);
                            if (leftAmount > 0) continue;
                            iterator.remove();
                            continue block0;
                        }
                    }
                    break block8;
                }
                if (io != IO.OUT) break block8;
                block2: while (iterator.hasNext()) {
                    ParticleStack particleStack = iterator.next();
                    for (ParticleStorage storage : capability.getParticleBeams()) {
                        if (!storage.canReciveParticle(null, particleStack)) continue;
                        if (simulate) {
                            storage.reciveParticle(null, particleStack);
                        }
                        iterator.remove();
                        continue block2;
                    }
                }
            }
            return left.isEmpty() ? null : left;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean hasInnerChanged() {
            ParticleStorage tank;
            int i;
            ITileParticleStorage capability = this.getCapability();
            if (capability == null) {
                return false;
            }
            List storages = capability.getParticleBeams();
            boolean same = true;
            if (this.lastStacks.length != storages.size()) {
                same = false;
            } else {
                for (i = 0; i < storages.size(); ++i) {
                    long lastCap;
                    long cap;
                    tank = (ParticleStorage)storages.get(i);
                    ParticleStack content = tank.getParticleStack();
                    ParticleStack lastContent = this.lastStacks[i];
                    if (content == null) {
                        if (lastContent != null) {
                            same = false;
                            break;
                        }
                    } else {
                        if (lastContent == null) {
                            same = false;
                            break;
                        }
                        if (content.getParticle() != lastContent.getParticle() || content.getFocus() != lastContent.getFocus() || content.getMeanEnergy() != lastContent.getMeanEnergy() || content.getAmount() != lastContent.getAmount()) {
                            same = false;
                            break;
                        }
                    }
                    if ((cap = tank.getMaxEnergy()) != (lastCap = this.lastMaxEnergy[i])) {
                        same = false;
                        break;
                    }
                    cap = tank.getMinEnergy();
                    if (cap != (lastCap = this.lastMinEnergy[i])) {
                        same = false;
                        break;
                    }
                    cap = tank.getCapacity();
                    if (cap == (lastCap = (long)this.lastCapacity[i])) continue;
                    same = false;
                    break;
                }
            }
            if (same) {
                return false;
            }
            this.lastStacks = new ParticleStack[storages.size()];
            this.lastMaxEnergy = new long[storages.size()];
            this.lastMinEnergy = new long[storages.size()];
            this.lastCapacity = new int[storages.size()];
            i = 0;
            while (i < storages.size()) {
                tank = (ParticleStorage)storages.get(i);
                this.lastStacks[i] = tank.getParticleStack() == null ? null : tank.getParticleStack().copy();
                this.lastMaxEnergy[i] = tank.getMaxEnergy();
                this.lastMinEnergy[i] = tank.getMinEnergy();
                this.lastCapacity[i] = tank.getCapacity();
                ++i;
            }
            return true;
        }
    }
}

