/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapCapabilityProxy;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import mysticalmechanics.handler.RegistryHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class MystMechPowerCapability
extends MultiblockCapability<Double> {
    public static final MystMechPowerCapability CAP = new MystMechPowerCapability();

    private MystMechPowerCapability() {
        super("mm_mech_power", new Color(10658537).getRGB());
    }

    @Override
    public Double defaultContent() {
        return 0.0;
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return tileEntity.hasCapability(MysticalMechanicsAPI.MECH_CAPABILITY, EnumFacing.func_82600_a((int)tileEntity.func_145832_p()).func_176734_d());
    }

    @Override
    public Double copyInner(Double content) {
        return content;
    }

    @Override
    public Double copyInnerByModifier(Double content, ContentModifier modifier) {
        return modifier.apply(content);
    }

    public MystMechPowerCapabilityProxy createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new MystMechPowerCapabilityProxy(tileEntity);
    }

    @Override
    public ContentWidget<? super Double> createContentWidget() {
        return new NumberContentWidget().setContentTexture(new TextTexture("Mechanical Power", this.color)).setUnit("MP");
    }

    @Override
    public BlockInfo[] getCandidates() {
        return new BlockInfo[]{BlockInfo.fromBlockState(RegistryHandler.GEARBOX_FRAME.func_176223_P()), BlockInfo.fromBlockState(RegistryHandler.MERGEBOX_FRAME.func_176223_P())};
    }

    public Double deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return json.getAsDouble();
    }

    public JsonElement serialize(Double aDouble, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)aDouble);
    }

    public static class MystMechPowerCapabilityProxy
    extends CapCapabilityProxy<IMechCapability, Double> {
        double lastPower = Double.MIN_VALUE;

        public MystMechPowerCapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity, MysticalMechanicsAPI.MECH_CAPABILITY);
        }

        public EnumFacing getTargetFacingDirection() {
            return EnumFacing.func_82600_a((int)this.getTileEntity().func_145832_p()).func_176734_d();
        }

        @Override
        protected List<Double> handleRecipeInner(IO io, Recipe recipe, List<Double> left, @Nullable String slotName, boolean simulate) {
            IMechCapability capability = (IMechCapability)this.getCapability(slotName);
            if (capability == null || capability.getPower(this.getTargetFacingDirection()) < left.get(0)) {
                return left;
            }
            return null;
        }

        @Override
        protected boolean hasInnerChanged() {
            IMechCapability capability = (IMechCapability)this.getCapability(null);
            if (capability == null || capability.getPower(this.getTargetFacingDirection()) == 0.0) {
                return false;
            }
            if (this.lastPower == capability.getPower(this.getTargetFacingDirection())) {
                return false;
            }
            this.lastPower = capability.getPower(this.getTargetFacingDirection());
            return true;
        }
    }
}

