/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.trait.LaserCapabilityTrait;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class LaserMekanismCapability
extends MultiblockCapability<Double> {
    public static final LaserMekanismCapability CAP = new LaserMekanismCapability();

    public LaserMekanismCapability() {
        super("mek_laser", new Color(0xFF0000).getRGB());
    }

    @Override
    public Double defaultContent() {
        return 5.0;
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return !this.getCapability(Capabilities.LASER_RECEPTOR_CAPABILITY, tileEntity).isEmpty();
    }

    @Override
    public Double copyInner(Double content) {
        return content;
    }

    @Override
    public Double copyInnerByModifier(Double content, ContentModifier modifier) {
        return modifier.apply(content);
    }

    @Override
    public CapabilityProxy<? extends Double> createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new MekanismLaserProxy(tileEntity);
    }

    @Override
    public ContentWidget<? super Double> createContentWidget() {
        return new NumberContentWidget().setContentTexture(new TextTexture("LZ", this.color)).setUnit("Mekanism Laser");
    }

    public Double deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return json.getAsDouble();
    }

    public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)src);
    }

    @Override
    public boolean hasTrait() {
        return true;
    }

    @Override
    public CapabilityTrait createTrait() {
        return new LaserCapabilityTrait();
    }

    public static class MekanismLaserProxy
    extends CapabilityProxy<Double> {
        public MekanismLaserProxy(TileEntity tileEntity) {
            super(CAP, tileEntity);
        }

        public ILaserReceptor getCapability() {
            return (ILaserReceptor)this.getTileEntity();
        }

        @Override
        protected List<Double> handleRecipeInner(IO io, Recipe recipe, List<Double> left, @Nullable String slotName, boolean simulate) {
            ILaserReceptor capability = this.getCapability();
            if (capability == null) {
                return left;
            }
            double sum = left.stream().reduce(0.0, Double::sum);
            if (io == IO.IN) {
                if (!simulate) {
                    capability.receiveLaserEnergy(-sum, EnumFacing.DOWN);
                }
            } else if (io == IO.OUT && !simulate) {
                capability.receiveLaserEnergy(sum, EnumFacing.DOWN);
            }
            return null;
        }
    }
}

