/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.common.capability.trait.LPPlayerCapabilityTrait;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;

public class LPBloodMagicCapability
extends MultiblockCapability<Integer> {
    public static final LPBloodMagicCapability CAP = new LPBloodMagicCapability();

    private LPBloodMagicCapability() {
        super("bg_lp", new Color(15944782).getRGB());
    }

    @Override
    public Integer defaultContent() {
        return 1;
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return tileEntity instanceof ComponentTileEntity && ((ComponentTileEntity)tileEntity).hasTrait(CAP);
    }

    @Override
    public Integer copyInner(Integer content) {
        return content;
    }

    @Override
    public Integer copyInnerByModifier(Integer content, ContentModifier modifier) {
        return (int)modifier.apply(content.intValue());
    }

    @Override
    public CapabilityProxy<? extends Integer> createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new LPBloodMagicCapabilityProxy(tileEntity);
    }

    public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return json.getAsInt();
    }

    public JsonElement serialize(Integer src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)src);
    }

    @Override
    public ContentWidget<? super Integer> createContentWidget() {
        return new NumberContentWidget().setContentTexture(new TextTexture("LP", this.color)).setUnit("LP");
    }

    @Override
    public boolean hasTrait() {
        return true;
    }

    @Override
    public CapabilityTrait createTrait() {
        return new LPPlayerCapabilityTrait();
    }

    public static class LPBloodMagicCapabilityProxy
    extends CapabilityProxy<Integer> {
        int lastLP = Integer.MIN_VALUE;

        public LPBloodMagicCapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity);
        }

        public LPPlayerCapabilityTrait getTrait() {
            CapabilityTrait trait;
            TileEntity te = this.getTileEntity();
            if (te instanceof ComponentTileEntity && ((ComponentTileEntity)te).hasTrait(CAP) && (trait = ((ComponentTileEntity)te).getTrait(CAP)) instanceof LPPlayerCapabilityTrait) {
                return (LPPlayerCapabilityTrait)trait;
            }
            return null;
        }

        @Override
        protected List<Integer> handleRecipeInner(IO io, Recipe recipe, List<Integer> left, @Nullable String slotName, boolean simulate) {
            LPPlayerCapabilityTrait trait = this.getTrait();
            if (trait == null) {
                return left;
            }
            int sum = left.stream().reduce(0, Integer::sum);
            sum = trait.updateLP(io == IO.IN ? -sum : sum, simulate);
            return sum <= 0 ? null : Collections.singletonList(sum);
        }

        @Override
        protected boolean hasInnerChanged() {
            LPPlayerCapabilityTrait trait = this.getTrait();
            if (trait == null) {
                return false;
            }
            SoulNetwork capability = trait.getCapability();
            if (capability == null) {
                return false;
            }
            if (this.lastLP == capability.getCurrentEssence()) {
                return false;
            }
            this.lastLP = capability.getCurrentEssence();
            return true;
        }
    }
}

